/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.utils;

import com.android.tools.ndk.jni.utils.JniUtilsKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\f\u0010\n\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/ndk/jni/utils/NameGenerator;", "", "namesToAvoid", "", "", "([Ljava/lang/String;)V", "", "(Ljava/util/Set;)V", "generateUniqueName", "s", "next", "android-ndk"})
public final class NameGenerator {
    @NotNull
    private final Set<String> namesToAvoid;

    public NameGenerator(@NotNull Set<String> namesToAvoid) {
        Intrinsics.checkNotNullParameter(namesToAvoid, (String)"namesToAvoid");
        this.namesToAvoid = namesToAvoid;
    }

    public /* synthetic */ NameGenerator(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        this(set);
    }

    public NameGenerator(String ... namesToAvoid) {
        Intrinsics.checkNotNullParameter((Object)namesToAvoid, (String)"namesToAvoid");
        this(ArraysKt.toMutableSet((Object[])namesToAvoid));
    }

    @NotNull
    public final String generateUniqueName(@NotNull String s) {
        String string;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (this.namesToAvoid.contains(s)) {
            string = this.generateUniqueName(this.next(s));
        } else {
            this.namesToAvoid.add(s);
            string = s;
        }
        return string;
    }

    private final String next(String $this$next) {
        MatchResult matchResult = JniUtilsKt.access$getEND_WITH_NUMBER_PATTERN$p().matchEntire((CharSequence)$this$next);
        if (matchResult == null) {
            return $this$next + "_1";
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String string = matchGroup.getValue();
        MatchGroup matchGroup2 = match.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        return string + "_" + (Integer.parseInt(matchGroup2.getValue()) + 1);
    }

    public NameGenerator() {
        this(null, 1, null);
    }
}

