/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.service;

import com.android.tools.ndk.jni.model.ClassTypeInfo;
import com.android.tools.ndk.jni.model.ConcreteTypeInfo;
import com.android.tools.ndk.jni.model.IllegalTypeInfo;
import com.android.tools.ndk.jni.model.JvmArrayType;
import com.android.tools.ndk.jni.model.JvmObjectType;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmPrimitiveTypeSymbol;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeInfo;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.model.SimpleTypeInfo;
import com.android.tools.ndk.jni.model.WildcardTypeInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000bJ\u001c\u0010\u0011\u001a\u00020\u000b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u000bJ\u0019\u0010\u000f\u001a\u00020\u000b*\u0004\u0018\u00010\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0015H\u0086\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/ndk/jni/service/JvmTypeChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "javaPsiFacade", "Lcom/intellij/psi/JavaPsiFacade;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "areUnifiableBySubtyping", "", "t1", "Lcom/android/tools/ndk/jni/model/JvmType;", "t2", "isAssignableFrom", "isPrimitiveAutoCastAllowed", "containsMembersOf", "Lcom/android/tools/ndk/jni/model/ConcreteTypeInfo;", "that", "forStaticField", "Lcom/android/tools/ndk/jni/model/JvmTypeInfo;", "Companion", "android-ndk"})
public final class JvmTypeChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaPsiFacade javaPsiFacade;
    @NotNull
    private final GlobalSearchScope searchScope;

    public JvmTypeChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade, (String)"getInstance(project)");
        this.javaPsiFacade = javaPsiFacade;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.javaPsiFacade.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(javaPsiFacade.project)");
        this.searchScope = globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean isAssignableFrom(@Nullable JvmTypeInfo $this$isAssignableFrom, @Nullable JvmTypeInfo that) {
        boolean bl;
        if ($this$isAssignableFrom == null) return true;
        if (that == null) {
            return true;
        }
        JvmTypeInfo jvmTypeInfo = $this$isAssignableFrom;
        if (jvmTypeInfo instanceof ConcreteTypeInfo) {
            JvmTypeInfo jvmTypeInfo2 = that;
            if (jvmTypeInfo2 instanceof ConcreteTypeInfo) {
                bl = JvmTypeChecker.isAssignableFrom$default(this, ((ConcreteTypeInfo)$this$isAssignableFrom).getType(), ((ConcreteTypeInfo)that).getType(), false, 4, null);
                return bl;
            }
            if (jvmTypeInfo2 instanceof WildcardTypeInfo) {
                bl = this.areUnifiableBySubtyping(((ConcreteTypeInfo)$this$isAssignableFrom).getType(), ((WildcardTypeInfo)that).getBound());
                return bl;
            }
            if (!(jvmTypeInfo2 instanceof IllegalTypeInfo)) throw new NoWhenBranchMatchedException();
            return false;
        }
        if (!(jvmTypeInfo instanceof WildcardTypeInfo)) {
            if (!(jvmTypeInfo instanceof IllegalTypeInfo)) throw new NoWhenBranchMatchedException();
            return false;
        }
        JvmTypeInfo jvmTypeInfo3 = that;
        if (jvmTypeInfo3 instanceof ConcreteTypeInfo) {
            bl = JvmTypeChecker.isAssignableFrom$default(this, ((WildcardTypeInfo)$this$isAssignableFrom).getBound(), ((ConcreteTypeInfo)that).getType(), false, 4, null);
            return bl;
        }
        if (jvmTypeInfo3 instanceof WildcardTypeInfo) {
            bl = this.areUnifiableBySubtyping(((WildcardTypeInfo)$this$isAssignableFrom).getBound(), ((WildcardTypeInfo)that).getBound());
            return bl;
        }
        if (!(jvmTypeInfo3 instanceof IllegalTypeInfo)) throw new NoWhenBranchMatchedException();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsMembersOf(@NotNull ConcreteTypeInfo $this$containsMembersOf, @NotNull ConcreteTypeInfo that, boolean forStaticField) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$containsMembersOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        ConcreteTypeInfo concreteTypeInfo = $this$containsMembersOf;
        if (concreteTypeInfo instanceof SimpleTypeInfo) {
            ConcreteTypeInfo concreteTypeInfo2 = that;
            if (concreteTypeInfo2 instanceof SimpleTypeInfo) {
                if (!($this$containsMembersOf.getType() instanceof JvmObjectType)) return false;
                if (!JvmTypeChecker.isAssignableFrom$default(this, that.getType(), $this$containsMembersOf.getType(), false, 4, null)) return false;
                return true;
            }
            if (!(concreteTypeInfo2 instanceof ClassTypeInfo)) throw new NoWhenBranchMatchedException();
            bl = JvmTypeChecker.isAssignableFrom$default(this, ((ClassTypeInfo)that).getType(), $this$containsMembersOf.getType(), false, 4, null);
            return bl;
        } else {
            if (!(concreteTypeInfo instanceof ClassTypeInfo)) throw new NoWhenBranchMatchedException();
            ConcreteTypeInfo concreteTypeInfo3 = that;
            if (concreteTypeInfo3 instanceof SimpleTypeInfo) {
                bl = JvmTypeChecker.isAssignableFrom$default(this, that.getType(), ((ClassTypeInfo)$this$containsMembersOf).getType(), false, 4, null);
                return bl;
            } else {
                if (!(concreteTypeInfo3 instanceof ClassTypeInfo)) throw new NoWhenBranchMatchedException();
                bl = forStaticField ? Intrinsics.areEqual((Object)((ClassTypeInfo)that).getClassType(), (Object)((ClassTypeInfo)$this$containsMembersOf).getClassType()) : JvmTypeChecker.isAssignableFrom$default(this, ((ClassTypeInfo)that).getClassType(), ((ClassTypeInfo)$this$containsMembersOf).getClassType(), false, 4, null);
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean containsMembersOf$default(JvmTypeChecker jvmTypeChecker, ConcreteTypeInfo concreteTypeInfo, ConcreteTypeInfo concreteTypeInfo2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jvmTypeChecker.containsMembersOf(concreteTypeInfo, concreteTypeInfo2, bl);
    }

    public final boolean isAssignableFrom(@NotNull JvmType t1, @NotNull JvmType t2, boolean isPrimitiveAutoCastAllowed) {
        Intrinsics.checkNotNullParameter((Object)t1, (String)"t1");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t2");
        if (Intrinsics.areEqual((Object)t1, (Object)t2)) {
            return true;
        }
        if (t1 instanceof JvmPrimitiveType && t2 instanceof JvmPrimitiveType && isPrimitiveAutoCastAllowed) {
            return ((JvmPrimitiveType)t1).getSymbol() == ((JvmPrimitiveType)t2).getSymbol() || ((JvmPrimitiveType)t1).getSymbol().compareTo((Enum)JvmPrimitiveTypeSymbol.INT) <= 0 && ((JvmPrimitiveType)t2).getSymbol().compareTo((Enum)JvmPrimitiveTypeSymbol.INT) <= 0;
        }
        if (t1 instanceof JvmPrimitiveType || t2 instanceof JvmPrimitiveType) {
            return false;
        }
        if (Intrinsics.areEqual((Object)t1, (Object)JvmTypeKt.getOBJECT_TYPE())) {
            return true;
        }
        if (t1 instanceof JvmArrayType && t2 instanceof JvmArrayType) {
            return this.isAssignableFrom(((JvmArrayType)t1).getType(), ((JvmArrayType)t2).getType(), false);
        }
        if (t1 instanceof JvmObjectType && t2 instanceof JvmObjectType) {
            PsiClass psiClass = this.javaPsiFacade.findClass(((JvmObjectType)t1).getName().getJava(), this.searchScope);
            if (psiClass == null) {
                return true;
            }
            PsiClass t1Class = psiClass;
            PsiClass psiClass2 = this.javaPsiFacade.findClass(((JvmObjectType)t2).getName().getJava(), this.searchScope);
            if (psiClass2 == null) {
                return true;
            }
            PsiClass t2Class = psiClass2;
            return t2Class.isInheritor(t1Class, true);
        }
        return false;
    }

    public static /* synthetic */ boolean isAssignableFrom$default(JvmTypeChecker jvmTypeChecker, JvmType jvmType, JvmType jvmType2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return jvmTypeChecker.isAssignableFrom(jvmType, jvmType2, bl);
    }

    private final boolean areUnifiableBySubtyping(JvmType t1, JvmType t2) {
        if (Intrinsics.areEqual((Object)t1, (Object)t2)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)t1, (Object)JvmTypeKt.getOBJECT_TYPE()) || Intrinsics.areEqual((Object)t2, (Object)JvmTypeKt.getOBJECT_TYPE())) {
            return true;
        }
        if (t1 instanceof JvmPrimitiveType || t2 instanceof JvmPrimitiveType) {
            return false;
        }
        if (t1 instanceof JvmArrayType && t2 instanceof JvmArrayType) {
            return false;
        }
        if (t1 instanceof JvmObjectType && t2 instanceof JvmObjectType) {
            PsiClass psiClass = this.javaPsiFacade.findClass(((JvmObjectType)t1).getName().getJava(), this.searchScope);
            if (psiClass == null) {
                return true;
            }
            PsiClass t1Class = psiClass;
            PsiClass psiClass2 = this.javaPsiFacade.findClass(((JvmObjectType)t2).getName().getJava(), this.searchScope);
            if (psiClass2 == null) {
                return true;
            }
            PsiClass t2Class = psiClass2;
            return t1Class.isInterface() || t2Class.isInterface() || t1Class.isInheritor(t2Class, true) || t2Class.isInheritor(t1Class, true);
        }
        return false;
    }

    @JvmStatic
    public static final JvmTypeChecker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/jni/service/JvmTypeChecker$Companion;", "", "()V", "getInstance", "Lcom/android/tools/ndk/jni/service/JvmTypeChecker;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final JvmTypeChecker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (JvmTypeChecker)project.getComponent(JvmTypeChecker.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

