/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.refactor;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\fH\u0016J4\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J<\u0010\u0015\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J8\u0010\u001a\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J0\u0010\u001f\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006 "}, d2={"Lcom/android/tools/ndk/jni/refactor/JniRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "prepareRenaming", "", "newName", "", "elementsToRename", "", "renameFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "jniMethodResolver", "Lcom/android/tools/ndk/jni/service/JniMethodResolver;", "collectConflictingMethodsDueToOverloading", "conflictingJvmMethodInfos", "", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "collectElements", "jvmMethodInfo", "nativeMethodIdManipulator", "Lkotlin/Function1;", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "collectElementsForClassRenaming", "oldClassName", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "newClassName", "methodElement", "collectElementsRelatedToMethod", "android-ndk"})
public final class JniRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return NdkHelper.isNdkProject(element.getProject()) && (element instanceof PsiMethod || element instanceof KtFunction || element instanceof PsiClass || element instanceof KtClassOrObject || element instanceof KtFile);
    }

    /*
     * WARNING - void declaration
     */
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> elementsToRename) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(elementsToRename, (String)"elementsToRename");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        JniMethodResolver jniMethodResolver2 = JniMethodResolver.Companion.getInstance(project);
        PsiElement psiElement = element;
        if (psiElement instanceof KtFunction) {
            if (JniUtilsKt.getOverriddenJvmName((KtAnnotated)element) == null) {
                this.collectElementsRelatedToMethod(elementsToRename, jniMethodResolver2, element, newName);
            }
        } else if (psiElement instanceof PsiMethod) {
            this.collectElementsRelatedToMethod(elementsToRename, jniMethodResolver2, element, newName);
        } else if (psiElement instanceof KtClassOrObject) {
            void $this$forEach$iv;
            FullyQualifiedClassName fullyQualifiedClassName = JniUtilsKt.getJvmClass((KtClassOrObject)element);
            if (fullyQualifiedClassName == null) {
                return;
            }
            FullyQualifiedClassName oldClassName = fullyQualifiedClassName;
            FullyQualifiedClassName newClassName = oldClassName.withLastClassNameAs(newName);
            Iterable iterable = JniUtilsKt.findAllNativeFunctions((KtClassOrObject)element, (Function1<? super KtFunction, Boolean>)((Function1)new Function1<KtFunction, Boolean>(oldClassName){
                final /* synthetic */ FullyQualifiedClassName $oldClassName;
                {
                    this.$oldClassName = $oldClassName;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtFunction it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    FullyQualifiedClassName fullyQualifiedClassName = JniUtilsKt.getContainingJvmClass((KtDeclaration)it);
                    return fullyQualifiedClassName != null ? fullyQualifiedClassName.hasPrefix(this.$oldClassName) : false;
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtFunction it = (KtFunction)element$iv;
                boolean bl = false;
                this.collectElementsForClassRenaming(elementsToRename, jniMethodResolver2, oldClassName, newClassName, (PsiElement)it);
            }
            PsiElement psiElement2 = ((KtClassOrObject)element).getParent();
            KtFile ktFile = psiElement2 instanceof KtFile ? (KtFile)psiElement2 : null;
            if (ktFile == null) {
                return;
            }
            KtFile containingFile = ktFile;
            String string = containingFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"containingFile.name");
            if (Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)string, (CharSequence)".kt"), (Object)((KtClassOrObject)element).getName())) {
                this.renameFile(containingFile, newName + ".kt", elementsToRename, jniMethodResolver2);
            }
        } else if (psiElement instanceof KtFile) {
            this.renameFile((KtFile)element, newName, elementsToRename, jniMethodResolver2);
        } else if (psiElement instanceof PsiClass) {
            FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromJavaClass((PsiClass)element);
            if (fullyQualifiedClassName == null) {
                return;
            }
            FullyQualifiedClassName oldClassName = fullyQualifiedClassName;
            FullyQualifiedClassName newClassName = oldClassName.withLastClassNameAs(newName);
            Iterable $this$forEach$iv = JniUtilsKt.findAllNativeMethods$default((PsiClass)element, null, 1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                boolean bl = false;
                this.collectElementsForClassRenaming(elementsToRename, jniMethodResolver2, oldClassName, newClassName, (PsiElement)it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renameFile(KtFile element, String newName, Map<PsiElement, String> elementsToRename, JniMethodResolver jniMethodResolver2) {
        void $this$forEach$iv;
        if (JniUtilsKt.getOverriddenJvmName((KtAnnotated)element) != null) {
            return;
        }
        FullyQualifiedClassName oldClassName = JniUtilsKt.getJvmClass(element);
        FullyQualifiedClassName newClassName = oldClassName.withLastClassNameAs(StringsKt.removeSuffix((String)CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)newName), (CharSequence)".kt") + "Kt");
        Iterable iterable = JniUtilsKt.findAllNativeFunctions(element, (Function1<? super KtFunction, Boolean>)((Function1)new Function1<KtFunction, Boolean>(oldClassName){
            final /* synthetic */ FullyQualifiedClassName $oldClassName;
            {
                this.$oldClassName = $oldClassName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FullyQualifiedClassName fullyQualifiedClassName = JniUtilsKt.getContainingJvmClass((KtDeclaration)it);
                return fullyQualifiedClassName != null ? fullyQualifiedClassName.hasPrefix(this.$oldClassName) : false;
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFunction it = (KtFunction)element$iv;
            boolean bl = false;
            this.collectElementsForClassRenaming(elementsToRename, jniMethodResolver2, oldClassName, newClassName, (PsiElement)it);
        }
    }

    private final void collectElementsForClassRenaming(Map<PsiElement, String> $this$collectElementsForClassRenaming, JniMethodResolver jniMethodResolver2, FullyQualifiedClassName oldClassName, FullyQualifiedClassName newClassName, PsiElement methodElement) {
        MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement$default(MethodInfo.Companion, methodElement, false, 2, null);
        JvmMethodInfo jvmMethodInfo = methodInfo instanceof JvmMethodInfo ? (JvmMethodInfo)methodInfo : null;
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo jvmMethodInfo2 = jvmMethodInfo;
        this.collectElements($this$collectElementsForClassRenaming, jniMethodResolver2, jvmMethodInfo2, (Function1<? super JniNativeMethodId, JniNativeMethodId>)((Function1)new Function1<JniNativeMethodId, JniNativeMethodId>(oldClassName, newClassName){
            final /* synthetic */ FullyQualifiedClassName $oldClassName;
            final /* synthetic */ FullyQualifiedClassName $newClassName;
            {
                this.$oldClassName = $oldClassName;
                this.$newClassName = $newClassName;
                super(1);
            }

            @NotNull
            public final JniNativeMethodId invoke(@NotNull JniNativeMethodId oldNativeMethodId) {
                Intrinsics.checkNotNullParameter((Object)oldNativeMethodId, (String)"oldNativeMethodId");
                return JniNativeMethodId.copy$default(oldNativeMethodId, oldNativeMethodId.getClassName().replacePrefix(this.$oldClassName, this.$newClassName), null, null, 6, null);
            }
        }));
    }

    private final void collectElementsRelatedToMethod(Map<PsiElement, String> $this$collectElementsRelatedToMethod, JniMethodResolver jniMethodResolver2, PsiElement element, String newName) {
        MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement$default(MethodInfo.Companion, element, false, 2, null);
        JvmMethodInfo jvmMethodInfo = methodInfo instanceof JvmMethodInfo ? (JvmMethodInfo)methodInfo : null;
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo jvmMethodInfo2 = jvmMethodInfo;
        this.collectElements($this$collectElementsRelatedToMethod, jniMethodResolver2, jvmMethodInfo2, (Function1<? super JniNativeMethodId, JniNativeMethodId>)((Function1)new Function1<JniNativeMethodId, JniNativeMethodId>(newName){
            final /* synthetic */ String $newName;
            {
                this.$newName = $newName;
                super(1);
            }

            @NotNull
            public final JniNativeMethodId invoke(@NotNull JniNativeMethodId oldNativeMethodId) {
                Intrinsics.checkNotNullParameter((Object)oldNativeMethodId, (String)"oldNativeMethodId");
                return JniNativeMethodId.copy$default(oldNativeMethodId, null, this.$newName, null, 5, null);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void collectElements(Map<PsiElement, String> $this$collectElements, JniMethodResolver jniMethodResolver2, JvmMethodInfo jvmMethodInfo, Function1<? super JniNativeMethodId, JniNativeMethodId> nativeMethodIdManipulator) {
        void $this$filterTo$iv$iv;
        String string;
        JniNativeMethodId newNativeMethodId = (JniNativeMethodId)nativeMethodIdManipulator.invoke((Object)jvmMethodInfo.toJniNativeMethodId(false));
        JniNativeMethodId newNativeMethodIdWithoutArgs = JniNativeMethodId.copy$default(newNativeMethodId, null, null, null, 3, null);
        List<JvmMethodInfo> matchedJvmMethodInfos = jniMethodResolver2.resolveImplicitlyLinkedNativeMethod(newNativeMethodIdWithoutArgs);
        if (jvmMethodInfo.isOverloadedNativeMethod() || !((Collection)matchedJvmMethodInfos).isEmpty()) {
            this.collectConflictingMethodsDueToOverloading($this$collectElements, jniMethodResolver2, matchedJvmMethodInfos);
            string = newNativeMethodId.getFunctionName();
        } else {
            string = newNativeMethodIdWithoutArgs.getFunctionName();
        }
        String newNativeFunctionName = string;
        Iterable $this$filter$iv = jniMethodResolver2.resolveJavaOrKotlinMethod(jvmMethodInfo);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NativeMethodInfo it = (NativeMethodInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.getNativeMethodId() instanceof JniNativeMethodId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (NativeMethodInfo nativeMethodInfo : (List)destination$iv$iv) {
            OCDeclarator declarator;
            if (nativeMethodInfo.getPsiElement().getDeclarator() == null) continue;
            $this$collectElements.put((PsiElement)declarator, newNativeFunctionName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectConflictingMethodsDueToOverloading(Map<PsiElement, String> $this$collectConflictingMethodsDueToOverloading, JniMethodResolver jniMethodResolver2, List<JvmMethodInfo> conflictingJvmMethodInfos) {
        for (JvmMethodInfo conflictingJvmMethodInfo : conflictingJvmMethodInfos) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = jniMethodResolver2.resolveJavaOrKotlinMethod(conflictingJvmMethodInfo);
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NativeMethodInfo it = (NativeMethodInfo)element$iv$iv;
                boolean bl = false;
                if (!(it.getNativeMethodId() instanceof JniNativeMethodId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (NativeMethodInfo conflictingNativeMethodId : (List)destination$iv$iv) {
                OCDeclarator declarator;
                NativeMethodId nativeMethodId = conflictingNativeMethodId.getNativeMethodId();
                if (!(nativeMethodId instanceof JniNativeMethodId) || ((JniNativeMethodId)nativeMethodId).getArgTypes() != null || conflictingNativeMethodId.getPsiElement().getDeclarator() == null) continue;
                $this$collectConflictingMethodsDueToOverloading.put((PsiElement)declarator, conflictingJvmMethodInfo.toJniNativeMethodId(false).getFunctionName());
            }
        }
    }
}

