/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.refactor;

import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.refactor.JniInplaceCxxFunctionRenamer;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniRenameCxxFunctionHandler
extends OCInplaceRenameHandler
implements TitledHandler {
    @Nullable
    public VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        OCSymbol symbol;
        MethodInfo nativeMethodInfo = MethodInfo.fromPsiElement(elementToRename);
        if (nativeMethodInfo instanceof NativeMethodInfo && ((NativeMethodInfo)nativeMethodInfo).getNativeMethodId() instanceof JniNativeMethodId && (symbol = OCRenameUtil.getSymbolToRename((PsiElement)elementToRename)) != null) {
            return new JniInplaceCxxFunctionRenamer((NativeMethodInfo)nativeMethodInfo, editor, symbol);
        }
        return super.createRenamer(elementToRename, editor);
    }

    @NotNull
    public String getActionTitle() {
        return "Rename JNI function";
    }
}

