/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.refactor;

import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0015*\u00020 2\u0006\u0010!\u001a\u00020 H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/android/tools/ndk/jni/refactor/JniInplaceCxxFunctionRenamer;", "Lcom/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenamer;", "nativeMethodInfo", "Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "(Lcom/android/tools/ndk/jni/model/NativeMethodInfo;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/cidr/lang/symbols/OCSymbol;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "myJvmMethodInfos", "", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "getNativeMethodInfo", "()Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "getSymbol", "()Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "isIdentifier", "", "newName", "", "language", "Lcom/intellij/lang/Language;", "performOnInvalidIdentifier", "", "nameSuggestions", "Ljava/util/LinkedHashSet;", "performRenameInner", "element", "Lcom/intellij/psi/PsiElement;", "findIssueWhenRenamedFrom", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "oldNativeMethodId", "android-ndk"})
public final class JniInplaceCxxFunctionRenamer
extends OCInplaceRenamer {
    @NotNull
    private final NativeMethodInfo nativeMethodInfo;
    @NotNull
    private final Editor editor;
    @NotNull
    private final OCSymbol symbol;
    @NotNull
    private final List<JvmMethodInfo> myJvmMethodInfos;

    public JniInplaceCxxFunctionRenamer(@NotNull NativeMethodInfo nativeMethodInfo, @NotNull Editor editor, @NotNull OCSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)nativeMethodInfo, (String)"nativeMethodInfo");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        OCDeclarator oCDeclarator = nativeMethodInfo.getPsiElement().getDeclarator();
        Intrinsics.checkNotNull((Object)oCDeclarator);
        super((PsiNamedElement)oCDeclarator, symbol, editor, false, nativeMethodInfo.getPsiElement().getName(), nativeMethodInfo.getPsiElement().getName());
        this.nativeMethodInfo = nativeMethodInfo;
        this.editor = editor;
        this.symbol = symbol;
        Project project = this.nativeMethodInfo.getPsiElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"nativeMethodInfo.psiElement.project");
        this.myJvmMethodInfos = JniMethodResolver.Companion.getInstance(project).resolveNativeMethod(this.nativeMethodInfo);
    }

    @NotNull
    public final NativeMethodInfo getNativeMethodInfo() {
        return this.nativeMethodInfo;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final OCSymbol getSymbol() {
        return this.symbol;
    }

    protected boolean isIdentifier(@NotNull String newName, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!super.isIdentifier(newName, language)) {
            return false;
        }
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        if (jniNativeMethodId == null) {
            return false;
        }
        JniNativeMethodId nativeMethodId = jniNativeMethodId;
        NativeMethodId nativeMethodId2 = this.nativeMethodInfo.getNativeMethodId();
        Intrinsics.checkNotNull((Object)nativeMethodId2, (String)"null cannot be cast to non-null type com.android.tools.ndk.jni.model.JniNativeMethodId");
        return this.findIssueWhenRenamedFrom(nativeMethodId, (JniNativeMethodId)nativeMethodId2) == null;
    }

    protected void performOnInvalidIdentifier(@NotNull String newName, @NotNull LinkedHashSet<String> nameSuggestions) {
        String issue;
        String string;
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(nameSuggestions, (String)"nameSuggestions");
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        if (jniNativeMethodId != null) {
            NativeMethodId nativeMethodId = this.nativeMethodInfo.getNativeMethodId();
            Intrinsics.checkNotNull((Object)nativeMethodId, (String)"null cannot be cast to non-null type com.android.tools.ndk.jni.model.JniNativeMethodId");
            string = this.findIssueWhenRenamedFrom(jniNativeMethodId, (JniNativeMethodId)nativeMethodId);
        } else {
            string = issue = null;
        }
        if (issue != null) {
            JniInplaceCxxFunctionRenamer.performOnInvalidIdentifier$showPopup(this, issue);
        } else {
            JniInplaceCxxFunctionRenamer.performOnInvalidIdentifier$showPopup(this, "Invalid JNI-mangled function name.");
        }
    }

    private final String findIssueWhenRenamedFrom(JniNativeMethodId $this$findIssueWhenRenamedFrom, JniNativeMethodId oldNativeMethodId) {
        if (!Intrinsics.areEqual((Object)$this$findIssueWhenRenamedFrom.getClassName(), (Object)oldNativeMethodId.getClassName())) {
            return "Cannot rename Java or Kotlin package and classes here. Please rename them in Java or Kotlin code instead.";
        }
        if (!Intrinsics.areEqual($this$findIssueWhenRenamedFrom.getArgTypes(), oldNativeMethodId.getArgTypes())) {
            return "Cannot change the mangled argument signature.";
        }
        return null;
    }

    public void performRenameInner(@NotNull PsiElement element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        JniNativeMethodId jniNativeMethodId = JniNativeMethodId.Companion.fromJniMethodName(newName);
        Intrinsics.checkNotNull((Object)jniNativeMethodId);
        JniNativeMethodId newNativeMethodId = jniNativeMethodId;
        if (!((Collection)this.myJvmMethodInfos).isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(this, newNativeMethodId){
                final /* synthetic */ JniInplaceCxxFunctionRenamer this$0;
                final /* synthetic */ JniNativeMethodId $newNativeMethodId;
                {
                    this.this$0 = $receiver;
                    this.$newNativeMethodId = $newNativeMethodId;
                }

                public final void run() {
                    for (JvmMethodInfo methodInfo : JniInplaceCxxFunctionRenamer.access$getMyJvmMethodInfos$p(this.this$0)) {
                        PsiElement psiElement = methodInfo.getPsiElement();
                        RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement((PsiElement)psiElement);
                        JniNativeMethodId jniNativeMethodId = this.$newNativeMethodId;
                        RenamePsiElementProcessor $this$run_u24lambda_u2d1 = renamePsiElementProcessor;
                        boolean bl = false;
                        Collection collection = $this$run_u24lambda_u2d1.findReferences(psiElement);
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findReferences(psiElement)");
                        Iterable $this$forEach$iv = collection;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            PsiReference it = (PsiReference)element$iv;
                            boolean bl2 = false;
                            it.handleElementRename(jniNativeMethodId.getMethodName());
                        }
                        boolean $i$f$emptyArray = false;
                        $this$run_u24lambda_u2d1.renameElement(psiElement, jniNativeMethodId.getMethodName(), (UsageInfo[])((Object[])new UsageInfo[0]), null);
                    }
                }
            });
        }
        super.performRenameInner(element, newName);
    }

    private static final void performOnInvalidIdentifier$showPopup(JniInplaceCxxFunctionRenamer this$0, String message) {
        JBPopupFactory.getInstance().createMessage(message).showInBestPositionFor(this$0.myEditor);
    }

    public static final /* synthetic */ List access$getMyJvmMethodInfos$p(JniInplaceCxxFunctionRenamer $this) {
        return $this.myJvmMethodInfos;
    }
}

