/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "Lcom/android/tools/ndk/jni/model/MethodInfo;", "nativeMethodId", "Lcom/android/tools/ndk/jni/model/NativeMethodId;", "psiElement", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "(Lcom/android/tools/ndk/jni/model/NativeMethodId;Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;)V", "isCpp", "", "()Z", "isDefinition", "nameIdentifier", "Lcom/intellij/psi/PsiElement;", "getNameIdentifier", "()Lcom/intellij/psi/PsiElement;", "getNativeMethodId", "()Lcom/android/tools/ndk/jni/model/NativeMethodId;", "getPsiElement", "()Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "Companion", "android-ndk"})
public final class NativeMethodInfo
extends MethodInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativeMethodId nativeMethodId;
    @NotNull
    private final OCFunctionDeclaration psiElement;

    public NativeMethodInfo(@NotNull NativeMethodId nativeMethodId, @NotNull OCFunctionDeclaration psiElement) {
        Intrinsics.checkNotNullParameter((Object)nativeMethodId, (String)"nativeMethodId");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        super(null);
        this.nativeMethodId = nativeMethodId;
        this.psiElement = psiElement;
    }

    @NotNull
    public final NativeMethodId getNativeMethodId() {
        return this.nativeMethodId;
    }

    @NotNull
    public OCFunctionDeclaration getPsiElement() {
        return this.psiElement;
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifier() {
        PsiElement psiElement = this.getPsiElement().getNameIdentifier();
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }

    public final boolean isDefinition() {
        return this.getPsiElement() instanceof OCFunctionDefinition;
    }

    public final boolean isCpp() {
        return OCLanguageKindCalculator.calculateLanguageKind((OCPsiFile)((OCPsiFile)this.getPsiElement().getContainingOCFile())).isCpp();
    }

    @NotNull
    public final NativeMethodId component1() {
        return this.nativeMethodId;
    }

    @NotNull
    public final OCFunctionDeclaration component2() {
        return this.getPsiElement();
    }

    @NotNull
    public final NativeMethodInfo copy(@NotNull NativeMethodId nativeMethodId, @NotNull OCFunctionDeclaration psiElement) {
        Intrinsics.checkNotNullParameter((Object)nativeMethodId, (String)"nativeMethodId");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return new NativeMethodInfo(nativeMethodId, psiElement);
    }

    public static /* synthetic */ NativeMethodInfo copy$default(NativeMethodInfo nativeMethodInfo, NativeMethodId nativeMethodId, OCFunctionDeclaration oCFunctionDeclaration, int n, Object object) {
        if ((n & 1) != 0) {
            nativeMethodId = nativeMethodInfo.nativeMethodId;
        }
        if ((n & 2) != 0) {
            oCFunctionDeclaration = nativeMethodInfo.getPsiElement();
        }
        return nativeMethodInfo.copy(nativeMethodId, oCFunctionDeclaration);
    }

    @NotNull
    public String toString() {
        return "NativeMethodInfo(nativeMethodId=" + this.nativeMethodId + ", psiElement=" + this.getPsiElement() + ")";
    }

    public int hashCode() {
        int result = this.nativeMethodId.hashCode();
        result = result * 31 + this.getPsiElement().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NativeMethodInfo)) {
            return false;
        }
        NativeMethodInfo nativeMethodInfo = (NativeMethodInfo)other;
        if (!Intrinsics.areEqual((Object)this.nativeMethodId, (Object)nativeMethodInfo.nativeMethodId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getPsiElement(), (Object)nativeMethodInfo.getPsiElement());
    }

    @JvmStatic
    @Nullable
    public static final NativeMethodInfo fromOcFunctionDeclaration(@NotNull OCFunctionDeclaration functionDeclaration) {
        return Companion.fromOcFunctionDeclaration(functionDeclaration);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/ndk/jni/model/NativeMethodInfo$Companion;", "", "()V", "fromOcFunctionDeclaration", "Lcom/android/tools/ndk/jni/model/NativeMethodInfo;", "functionDeclaration", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final NativeMethodInfo fromOcFunctionDeclaration(@NotNull OCFunctionDeclaration functionDeclaration) {
            Intrinsics.checkNotNullParameter((Object)functionDeclaration, (String)"functionDeclaration");
            String string = functionDeclaration.getName();
            if (string == null) {
                return null;
            }
            return new NativeMethodInfo(NativeMethodId.Companion.fromFunctionName(string), functionDeclaration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

