/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\t\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\t\u0010\u0014\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/ndk/jni/model/JvmArrayType;", "Lcom/android/tools/ndk/jni/model/JvmType;", "type", "(Lcom/android/tools/ndk/jni/model/JvmType;)V", "isDerivedFromGenericType", "", "()Z", "getType", "()Lcom/android/tools/ndk/jni/model/JvmType;", "component1", "copy", "equals", "other", "", "hashCode", "", "toJniType", "", "toJvmType", "toShortJavaType", "toString", "android-ndk"})
public final class JvmArrayType
extends JvmType {
    @NotNull
    private final JvmType type;

    public JvmArrayType(@NotNull JvmType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(null);
        this.type = type;
    }

    @NotNull
    public final JvmType getType() {
        return this.type;
    }

    @Override
    public boolean isDerivedFromGenericType() {
        return false;
    }

    @Override
    @NotNull
    public String toJniType() {
        return this.type instanceof JvmPrimitiveType ? this.type.toJniType() + "Array" : "jobjectArray";
    }

    @Override
    @NotNull
    public String toJvmType() {
        return "[" + this.type.toJvmType();
    }

    @Override
    @NotNull
    public String toShortJavaType() {
        return this.type.toShortJavaType() + "[]";
    }

    @NotNull
    public final JvmType component1() {
        return this.type;
    }

    @NotNull
    public final JvmArrayType copy(@NotNull JvmType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new JvmArrayType(type);
    }

    public static /* synthetic */ JvmArrayType copy$default(JvmArrayType jvmArrayType, JvmType jvmType, int n, Object object) {
        if ((n & 1) != 0) {
            jvmType = jvmArrayType.type;
        }
        return jvmArrayType.copy(jvmType);
    }

    @NotNull
    public String toString() {
        return "JvmArrayType(type=" + this.type + ")";
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmArrayType)) {
            return false;
        }
        JvmArrayType jvmArrayType = (JvmArrayType)other;
        return Intrinsics.areEqual((Object)this.type, (Object)jvmArrayType.type);
    }
}

