/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.completion.UnimplementedJniMethodStubProvider;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.KotlinJniMissingFunctionInspection;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "android-ndk"})
public final class KotlinJniMissingFunctionInspection
extends JniInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public KotlinJniMissingFunctionInspection() {
        super(JniInspectionEvent.JniInspectionType.MISSING_FUNCTION_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!NdkHelper.isNdkProject(holder.getProject()) || OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)holder.getProject()).isEmpty()) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"super.buildVisitor(holder, isOnTheFly, session)");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ KotlinJniMissingFunctionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtNamedFunction it) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!JniUtilsKt.isNative((KtFunction)it)) {
                    return;
                }
                JniInspectionTool jniInspectionTool = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                KotlinJniMissingFunctionInspection kotlinJniMissingFunctionInspection = this.this$0;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)it).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    boolean bl;
                    JvmMethodInfo jvmMethodInfo;
                    block14: {
                        JvmMethodInfo jvmMethodInfo2;
                        JniUsageEventReporter $this$reportPerf_u24lambda_u2d0$iv = reporter$iv$iv;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (it.isLocal()) {
                            KtModifierList ktModifierList = it.getModifierList();
                            Intrinsics.checkNotNull((Object)ktModifierList);
                            PsiElement psiElement = ktModifierList.getModifier(KtTokens.EXTERNAL_KEYWORD);
                            Intrinsics.checkNotNull((Object)psiElement);
                            problemsHolder.registerProblem(psiElement, "JNI cannot link to a local external function.", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                            return;
                        }
                        if (JvmMethodInfo.Companion.fromKotlinFunction((KtFunction)it) == null) {
                            return;
                        }
                        jvmMethodInfo = jvmMethodInfo2;
                        Project project3 = it.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"it.project");
                        Iterable $this$any$iv = JniMethodResolver.Companion.getInstance(project3).resolveJavaOrKotlinMethod(jvmMethodInfo);
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                NativeMethodInfo it2 = (NativeMethodInfo)element$iv;
                                boolean bl4 = false;
                                if (!it2.isDefinition()) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return;
                    }
                    KotlinJniMissingFunctionInspection.Companion.registerMissingJniDefinitionProblem(problemsHolder, kotlinJniMissingFunctionInspection, jvmMethodInfo);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant bl2 = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl2).toMillis())));
                    }
                }
            }
        }));
    }

    @JvmStatic
    public static final void registerMissingJniDefinitionProblem(@NotNull ProblemsHolder holder, @NotNull JniInspectionTool tool, @NotNull JvmMethodInfo jvmMethodInfo) {
        Companion.registerMissingJniDefinitionProblem(holder, tool, jvmMethodInfo);
    }

    @JvmStatic
    private static final boolean showPopupAndCreateJniStub(Project project, JvmMethodInfo methodInfo, int sizeLimit) {
        return KotlinJniMissingFunctionInspection.Companion.showPopupAndCreateJniStub(project, methodInfo, sizeLimit);
    }

    @JvmStatic
    private static final List<OCFile> findNativeSourceFilesWithExistingJniFunctions(Project project) {
        return KotlinJniMissingFunctionInspection.Companion.findNativeSourceFilesWithExistingJniFunctions(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0007J\"\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0003\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/ndk/jni/inspections/KotlinJniMissingFunctionInspection$Companion;", "", "()V", "createJniStub", "", "project", "Lcom/intellij/openapi/project/Project;", "ocFile", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "methodInfo", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "findNativeSourceFiles", "", "sizeLimit", "", "findNativeSourceFilesWithExistingJniFunctions", "hasNativeSourceFiles", "", "registerMissingJniDefinitionProblem", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "tool", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "jvmMethodInfo", "showPopupAndCreateJniStub", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void registerMissingJniDefinitionProblem(@NotNull ProblemsHolder holder, @NotNull JniInspectionTool tool, @NotNull JvmMethodInfo jvmMethodInfo) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)((Object)tool), (String)"tool");
            Intrinsics.checkNotNullParameter((Object)jvmMethodInfo, (String)"jvmMethodInfo");
            String jniMethodName = JvmMethodInfo.toJniNativeMethodId$default(jvmMethodInfo, false, 1, null).getFunctionName();
            String message = "Cannot resolve corresponding JNI function " + jniMethodName + ".";
            Project project = holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"holder.project");
            boolean hasNativeSourceFiles = this.hasNativeSourceFiles(project);
            if (!hasNativeSourceFiles) {
                message = message + " Could not find any C or C++ source files in the project. Please create one first.";
            }
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{hasNativeSourceFiles ? tool.quickFix("Create JNI function", "Create JNI function for " + jvmMethodInfo.getMethodName(), (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(jvmMethodInfo){
                final /* synthetic */ JvmMethodInfo $jvmMethodInfo;
                {
                    this.$jvmMethodInfo = $jvmMethodInfo;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    return com.android.tools.ndk.jni.inspections.KotlinJniMissingFunctionInspection$Companion.showPopupAndCreateJniStub$default(KotlinJniMissingFunctionInspection.Companion, project, this.$jvmMethodInfo, 0, 4, null);
                }
            })) : null};
            holder.registerProblem(jvmMethodInfo.getNameIdentifier(), message, ProblemHighlightType.ERROR, localQuickFixArray);
        }

        @JvmStatic
        private final boolean showPopupAndCreateJniStub(Project project, JvmMethodInfo methodInfo, int sizeLimit) {
            List<OCFile> files = this.findNativeSourceFiles(project, sizeLimit);
            if (files.size() == 1) {
                this.createJniStub(project, (OCFile)CollectionsKt.single(files), methodInfo);
            } else {
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor == null) {
                    return false;
                }
                Editor editor2 = editor;
                Object object = WindowManagerEx.getInstanceEx().getFrame(project);
                int maxWidth = object != null && (object = object.getSize()) != null ? object.width : 500;
                JBPopupFactory.getInstance().createPopupChooserBuilder(files).setRenderer((ListCellRenderer)new GotoFileCellRenderer(maxWidth)).setTitle("Select native file to place the JNI function" + (String)(files.size() == sizeLimit ? " (showing " + files.size() + " results)" : "")).setNamerForFiltering((Function)showPopupAndCreateJniStub.1.INSTANCE).setItemChosenCallback(new Consumer(project, methodInfo){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ JvmMethodInfo $methodInfo;
                    {
                        this.$project = $project;
                        this.$methodInfo = $methodInfo;
                    }

                    public final void consume(OCFile file) {
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                        com.android.tools.ndk.jni.inspections.KotlinJniMissingFunctionInspection$Companion.access$createJniStub(KotlinJniMissingFunctionInspection.Companion, this.$project, file, this.$methodInfo);
                    }
                }).createPopup().showInBestPositionFor(editor2);
            }
            return true;
        }

        static /* synthetic */ boolean showPopupAndCreateJniStub$default(Companion companion, Project project, JvmMethodInfo jvmMethodInfo, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1000;
            }
            return companion.showPopupAndCreateJniStub(project, jvmMethodInfo, n);
        }

        private final void createJniStub(Project project, OCFile ocFile, JvmMethodInfo methodInfo) {
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(ocFile, methodInfo, project){
                final /* synthetic */ OCFile $ocFile;
                final /* synthetic */ JvmMethodInfo $methodInfo;
                final /* synthetic */ Project $project;
                {
                    this.$ocFile = $ocFile;
                    this.$methodInfo = $methodInfo;
                    this.$project = $project;
                }

                public final void run() {
                    boolean cpp = this.$ocFile.getKind() == CLanguageKind.CPP;
                    String text = JvmMethodInfo.generateNativeMethod$default(this.$methodInfo, cpp, false, 2, null);
                    UnimplementedJniMethodStubProvider.Companion.insertJniHeaderIfNeeded(this.$ocFile);
                    OCChangeUtil.changeText((Project)this.$ocFile.getProject(), (PsiFile)((PsiFile)this.$ocFile), (int)PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)this.$ocFile)), (int)0, (String)"\n", (boolean)false);
                    UtilsKt.commitAndUnblockDocument((PsiFile)((PsiFile)this.$ocFile));
                    PsiElement psiElement = OCElementFactory.topLevelDeclarationFromText((String)text, (PsiElement)((PsiElement)this.$ocFile), (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"topLevelDeclarationFromText(text, ocFile, true)");
                    PsiElement declaration = psiElement;
                    PsiElement added = OCChangeUtil.add((PsiElement)((PsiElement)this.$ocFile), (PsiElement)declaration);
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.$project);
                    Document document = documentManager.getDocument((PsiFile)this.$ocFile);
                    Intrinsics.checkNotNull((Object)document);
                    documentManager.doPostponedOperationsAndUnblockDocument(document);
                    OCChangeUtil.reformatTextIfNotInjected((PsiFile)((PsiFile)this.$ocFile), (int)added.getTextOffset(), (int)(added.getTextOffset() + added.getTextLength()));
                    Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)added, PsiComment.class);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(added, PsiComment::class.java)");
                    Collection comments = collection;
                    if (!comments.isEmpty()) {
                        PsiComment firstComment = (PsiComment)comments.iterator().next();
                        PsiNavigateUtil.navigate((PsiElement)((PsiElement)firstComment));
                        TextRange textRange = firstComment.getTextRange();
                        Editor editor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                        Editor editor2 = editor;
                        if (editor2 != null && (editor2 = editor2.getSelectionModel()) != null) {
                            editor2.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                        }
                    } else {
                        Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)added, OCFunctionDeclaration.class);
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findChildrenOfType(\n    \u2026n::class.java\n          )");
                        Collection functions = collection2;
                        if (!functions.isEmpty()) {
                            OCFunctionDeclaration first = (OCFunctionDeclaration)functions.iterator().next();
                            PsiNavigateUtil.navigate((PsiElement)((PsiElement)first));
                        } else {
                            PsiNavigateUtil.navigate((PsiElement)added);
                        }
                    }
                }
            });
        }

        private final boolean hasNativeSourceFiles(Project project) {
            boolean bl;
            block3: {
                List list = OCWorkspace.getInstance((Project)project).getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstance(project).configurations");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        OCResolveConfiguration it = (OCResolveConfiguration)element$iv;
                        boolean bl2 = false;
                        if (!(!UtilKt.isEmpty((Stream)it.getAllCompilerSettings()))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<OCFile> findNativeSourceFiles(Project project, int sizeLimit) {
            List<OCFile> filesWithJniFunctions = this.findNativeSourceFilesWithExistingJniFunctions(project);
            Set excluded = CollectionsKt.toSet((Iterable)filesWithJniFunctions);
            PsiManager psiManager2 = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(project)");
            PsiManager psiManager3 = psiManager2;
            Collection collection = filesWithJniFunctions;
            List list = OCWorkspace.getInstance((Project)project).getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstance(project).configurations");
            return CollectionsKt.plus((Collection)collection, (Sequence)SequencesKt.take((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)findNativeSourceFiles.1.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, OCFile>(psiManager3){
                final /* synthetic */ PsiManager $psiManager;
                {
                    this.$psiManager = $psiManager;
                    super(1);
                }

                @Nullable
                public final OCFile invoke(VirtualFile it) {
                    PsiFile psiFile = this.$psiManager.findFile(it);
                    return psiFile instanceof OCFile ? (OCFile)psiFile : null;
                }
            })), (Function1)((Function1)new Function1<OCFile, Boolean>((Set<? extends OCFile>)excluded){
                final /* synthetic */ Set<OCFile> $excluded;
                {
                    this.$excluded = $excluded;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull OCFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !this.$excluded.contains(it);
                }
            }))), (int)(sizeLimit - filesWithJniFunctions.size())));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final List<OCFile> findNativeSourceFilesWithExistingJniFunctions(Project project) {
            void $this$mapNotNullTo$iv$iv;
            PsiFile[] psiFileArray = CacheManager.getInstance((Project)project).getFilesWithWord("JNIEXPORT", (short)1, GlobalSearchScope.projectScope((Project)project), true);
            Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getInstance(project)\n   \u2026jectScope(project), true)");
            Iterable $this$mapNotNull$iv = ArraysKt.distinct((Object[])psiFileArray);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                OCFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PsiFile it = (PsiFile)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof OCFile ? (OCFile)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public static final /* synthetic */ void access$createJniStub(Companion $this, Project project, OCFile ocFile, JvmMethodInfo methodInfo) {
            $this.createJniStub(project, ocFile, methodInfo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

