/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/ndk/jni/inspections/KotlinInternalExternalFunctionInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "android-ndk"})
public final class KotlinInternalExternalFunctionInspection
extends JniInspectionTool {
    public KotlinInternalExternalFunctionInspection() {
        super(JniInspectionEvent.JniInspectionType.KOTLIN_INTERNAL_EXTERNAL_FUNCTION_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)VisitorWrappersKt.namedFunctionVisitor((Function1)((Function1)new Function1<KtNamedFunction, Unit>(this, holder){
            final /* synthetic */ KotlinInternalExternalFunctionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtNamedFunction fn) {
                Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
                if (fn.hasModifier(KtTokens.EXTERNAL_KEYWORD) && fn.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
                    void inspectionType$iv$iv;
                    void $this$reportJniPerf$iv$iv;
                    void this_$iv;
                    JniInspectionTool jniInspectionTool = this.this$0;
                    ProblemsHolder problemsHolder = this.$holder;
                    KotlinInternalExternalFunctionInspection kotlinInternalExternalFunctionInspection = this.this$0;
                    boolean $i$f$reportPerf$android_ndk = false;
                    Project project = ((PsiElement)fn).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                    Project project2 = project;
                    JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                    int n = 100;
                    boolean $i$f$reportJniPerf = false;
                    JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                    Instant startTime$iv$iv = Instant.now();
                    try {
                        JniUsageEventReporter $this$reportPerf_u24lambda_u2d0$iv = reporter$iv$iv;
                        boolean bl = false;
                        boolean bl2 = false;
                        KtModifierList ktModifierList = fn.getModifierList();
                        Intrinsics.checkNotNull((Object)ktModifierList);
                        PsiElement psiElement = ktModifierList.getModifier(KtTokens.INTERNAL_KEYWORD);
                        Intrinsics.checkNotNull((Object)psiElement);
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{kotlinInternalExternalFunctionInspection.quickFix("Replace internal external function with private delegate", "Create private " + fn.getName() + "Impl() and delegate to it", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(fn){
                            final /* synthetic */ KtNamedFunction $fn;
                            {
                                this.$fn = $fn;
                                super(2);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                Collection<String> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                PsiElement psiElement;
                                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                                KtPsiFactory factory = new KtPsiFactory(project, false, 2, null);
                                String fnText = this.$fn.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)fnText, (String)"fnText");
                                KtNamedFunction privateFn = factory.createFunction(fnText);
                                privateFn.removeModifier(KtTokens.INTERNAL_KEYWORD);
                                privateFn.addModifier(KtTokens.PRIVATE_KEYWORD);
                                privateFn.setName(this.$fn.getName() + "Impl");
                                this.$fn.getParent().addAfter((PsiElement)privateFn, (PsiElement)this.$fn);
                                this.$fn.removeModifier(KtTokens.EXTERNAL_KEYWORD);
                                KtExpression ktExpression = this.$fn.getBodyExpression();
                                if (ktExpression != null) {
                                    ktExpression.delete();
                                }
                                if ((psiElement = this.$fn.getEqualsToken()) == null) {
                                    KtTypeReference ktTypeReference = this.$fn.getTypeReference();
                                    if (ktTypeReference != null) {
                                        psiElement = (PsiElement)ktTypeReference;
                                    } else {
                                        KtParameterList ktParameterList = this.$fn.getValueParameterList();
                                        if (ktParameterList != null) {
                                            psiElement = (PsiElement)ktParameterList;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                                PsiElement fnEnd = psiElement;
                                PsiElement eq = factory.createEQ();
                                this.$fn.addAfter(eq, fnEnd);
                                String string = this.$fn.getName();
                                List list = this.$fn.getValueParameters();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fn.valueParameters");
                                Iterable iterable = list;
                                String string2 = string;
                                KtPsiFactory ktPsiFactory = factory;
                                boolean $i$f$map = false;
                                void var11_12 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    KtParameter ktParameter = (KtParameter)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(it.getName());
                                }
                                collection = (List)destination$iv$iv;
                                KtExpression body = ktPsiFactory.createExpression(string2 + "Impl(" + CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")");
                                PsiElement psiElement2 = (PsiElement)body;
                                PsiElement psiElement3 = this.$fn.getEqualsToken();
                                Intrinsics.checkNotNull((Object)psiElement3);
                                this.$fn.addAfter(psiElement2, psiElement3);
                                return true;
                            }
                        }))};
                        problemsHolder.registerProblem(psiElement, "An external function should not be marked internal.\n\nKotlin compiler mangles the name of an internal function with the build variant, which could cause UnsatisfiedLinkError at runtime depending on the build variant. \n\nPlease use a private external function instead and delegate this internal function to it.", ProblemHighlightType.GENERIC_ERROR, localQuickFixArray);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        void inverseSampleRate$iv$iv;
                        if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                            Instant endTime$iv$iv = Instant.now();
                            JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                        }
                    }
                }
            }
        }));
    }
}

