/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.model.JvmMethodCall;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.NewObjectCall;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniNewObjectInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectMethodIsConstructor", "", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "call", "Lcom/android/tools/ndk/jni/model/NewObjectCall;", "android-ndk"})
public final class JniNewObjectInspection
extends JniInspectionTool {
    public JniNewObjectInspection() {
        super(JniInspectionEvent.JniInspectionType.CALL_METHOD_INSPECTION_EVENT);
    }

    @NotNull
    public OCVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        JniInspectionTool this_$iv = this;
        boolean $i$f$visitJniCall$android_ndk = false;
        return new OCVisitor(this_$iv, this, holder){
            final /* synthetic */ JniInspectionTool this$0$inline_fun;
            final /* synthetic */ JniNewObjectInspection this$0;
            final /* synthetic */ ProblemsHolder $holder$inlined;
            {
                this.this$0$inline_fun = $receiver;
                this.this$0 = jniNewObjectInspection;
                this.$holder$inlined = problemsHolder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                if (!(jniCall instanceof NewObjectCall)) {
                    jniCall = null;
                }
                JniCall jniCall2 = (NewObjectCall)jniCall;
                if (jniCall2 == null) {
                    return;
                }
                JniCall call2 = jniCall2;
                JniInspectionTool this_$iv = this.this$0$inline_fun;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p(this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    void call3;
                    JniUsageEventReporter $this$reportPerf_u24lambda_u2d0$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)inferencer, (String)"inferencer");
                    NewObjectCall newObjectCall = (NewObjectCall)call2;
                    JniInfoInferencer $this$buildVisitor_u24lambda_u2d0 = inferencer;
                    boolean bl3 = false;
                    JniNewObjectInspection.access$inspectMethodIsConstructor(this.this$0, $this$buildVisitor_u24lambda_u2d0, (NewObjectCall)call3, this.$holder$inlined);
                    InspectionUtilsKt.inspectCallArgs($this$buildVisitor_u24lambda_u2d0, (JvmMethodCall)call3, this.$holder$inlined);
                    InspectionUtilsKt.inspectMethodIdBelongsToClass($this$buildVisitor_u24lambda_u2d0, call3.getClassExpression(), this.$holder$inlined, call3.getMethodIdExpression());
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectMethodIsConstructor(JniInfoInferencer $this$inspectMethodIsConstructor, NewObjectCall call2, ProblemsHolder holder) {
        JvmMethodInfo jvmMethodInfo = $this$inspectMethodIsConstructor.inferMethodInfo(call2.getMethodIdExpression());
        if (jvmMethodInfo == null) {
            return;
        }
        JvmMethodInfo methodInfo = jvmMethodInfo;
        if (!methodInfo.isConstructor()) {
            holder.registerProblem((PsiElement)call2.getMethodIdExpression(), "Not a constructor.", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
        }
    }

    public static final /* synthetic */ void access$inspectMethodIsConstructor(JniNewObjectInspection $this, JniInfoInferencer $receiver, NewObjectCall call2, ProblemsHolder holder) {
        $this.inspectMethodIsConstructor($receiver, call2, holder);
    }
}

