/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JniCallKt;
import com.android.tools.ndk.jni.service.JniInfoInferencer;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a2\u0006\u0002\u0010\tJP\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000626\u0010\u000e\u001a2\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0011\u0012\b\b\r\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u000fJ/\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001bH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ>\u0010\u001e\u001a\u00020\u001f\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020 2\u001f\b\u0004\u0010\u001a\u001a\u0019\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\"0\u000f\u00a2\u0006\u0002\b#H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "inspectionType", "Lcom/google/wireless/android/sdk/stats/JniInspectionEvent$JniInspectionType;", "(Lcom/google/wireless/android/sdk/stats/JniInspectionEvent$JniInspectionType;)V", "getGroupDisplayName", "", "getGroupPath", "", "()[Ljava/lang/String;", "quickFix", "Lcom/android/tools/ndk/jni/inspections/JniLocalQuickFix;", "familyName", "name", "applyFixFn", "Lkotlin/Function2;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ParameterName;", "project", "Lcom/intellij/codeInspection/ProblemDescriptor;", "descriptor", "", "reportPerf", "T", "psiElement", "Lcom/intellij/psi/PsiElement;", "block", "Lkotlin/Function0;", "reportPerf$android_ndk", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "visitJniCall", "Lcom/jetbrains/cidr/lang/psi/visitors/OCVisitor;", "Lcom/android/tools/ndk/jni/model/JniCall;", "Lcom/android/tools/ndk/jni/service/JniInfoInferencer;", "", "Lkotlin/ExtensionFunctionType;", "visitJniCall$android_ndk", "android-ndk"})
public class JniInspectionTool
extends LocalInspectionTool {
    @NotNull
    private final JniInspectionEvent.JniInspectionType inspectionType;

    public JniInspectionTool(@NotNull JniInspectionEvent.JniInspectionType inspectionType) {
        Intrinsics.checkNotNullParameter((Object)inspectionType, (String)"inspectionType");
        this.inspectionType = inspectionType;
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Android", "JNI"};
        return stringArray;
    }

    @NotNull
    public String getGroupDisplayName() {
        return ArraysKt.joinToString$default((Object[])this.getGroupPath(), (CharSequence)" > ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final JniLocalQuickFix quickFix(@NotNull String familyName, @NotNull String name, @NotNull Function2<? super Project, ? super ProblemDescriptor, Boolean> applyFixFn) {
        Intrinsics.checkNotNullParameter((Object)familyName, (String)"familyName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(applyFixFn, (String)"applyFixFn");
        return new JniLocalQuickFix(this.inspectionType, name, familyName, applyFixFn);
    }

    public static /* synthetic */ JniLocalQuickFix quickFix$default(JniInspectionTool jniInspectionTool, String string, String string2, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: quickFix");
        }
        if ((n & 2) != 0) {
            string2 = string;
        }
        return jniInspectionTool.quickFix(string, string2, (Function2<? super Project, ? super ProblemDescriptor, Boolean>)function2);
    }

    public final /* synthetic */ <T extends JniCall> OCVisitor visitJniCall$android_ndk(Function2<? super JniInfoInferencer, ? super T, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$visitJniCall$android_ndk = false;
        Intrinsics.needClassReification();
        return new OCVisitor(this, block){
            final /* synthetic */ JniInspectionTool this$0;
            final /* synthetic */ Function2<JniInfoInferencer, T, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(@NotNull OCCallExpression expression) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                JniCall jniCall = JniCallKt.toJniCall(expression);
                Intrinsics.reifiedOperationMarker((int)2, (String)"T");
                if (jniCall == null) {
                    return;
                }
                JniCall call2 = jniCall;
                JniInspectionTool jniInspectionTool = this.this$0;
                Function2<JniInfoInferencer, T, Unit> function2 = this.$block;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = ((PsiElement)expression).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    JniUsageEventReporter $this$reportPerf_u24lambda_u2d0$iv = reporter$iv$iv;
                    boolean bl = false;
                    boolean bl2 = false;
                    JniInfoInferencer inferencer = (JniInfoInferencer)expression.getProject().getComponent(JniInfoInferencer.class);
                    Intrinsics.checkNotNullExpressionValue((Object)inferencer, (String)"inferencer");
                    function2.invoke((Object)inferencer, (Object)call2);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant endTime$iv$iv = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, endTime$iv$iv).toMillis())));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> T reportPerf$android_ndk(@NotNull PsiElement psiElement, @NotNull Function0<? extends T> block) {
        Object object;
        void inspectionType$iv;
        void $this$reportJniPerf$iv;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$reportPerf$android_ndk = false;
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
        Project project2 = project;
        JniInspectionEvent.JniInspectionType jniInspectionType = this.inspectionType;
        int n = 100;
        boolean $i$f$reportJniPerf = false;
        JniUsageEventReporter reporter$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv);
        Instant startTime$iv = Instant.now();
        try {
            JniUsageEventReporter $this$reportPerf_u24lambda_u2d0 = reporter$iv;
            boolean bl = false;
            object = block.invoke();
        }
        finally {
            void inverseSampleRate$iv;
            InlineMarker.finallyStart((int)1);
            if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv) == 0) {
                Instant endTime$iv = Instant.now();
                JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv, endTime$iv).toMillis())));
            }
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

