/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkConstants;
import com.android.tools.ndk.jni.model.JvmPrimitiveType;
import com.android.tools.ndk.jni.model.JvmPrimitiveTypeSymbol;
import com.android.tools.ndk.jni.model.SimpleParameterDeclaration;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a$\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\tH\u0002\u00a8\u0006\u000b"}, d2={"isCompatibleWithJniType", "", "Lcom/jetbrains/cidr/lang/types/OCType;", "containingFile", "Lcom/intellij/psi/PsiFile;", "jniType", "", "isCpp", "unify", "", "Lcom/android/tools/ndk/jni/model/SimpleParameterDeclaration;", "android-ndk"})
public final class JniFunctionSignatureInspectionKt {
    public static final boolean isCompatibleWithJniType(@NotNull OCType $this$isCompatibleWithJniType, @NotNull PsiFile containingFile, @NotNull String jniType, boolean isCpp) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCompatibleWithJniType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)jniType, (String)"jniType");
        if (Intrinsics.areEqual((Object)$this$isCompatibleWithJniType.getName(), (Object)jniType)) {
            return true;
        }
        if ($this$isCompatibleWithJniType instanceof OCNumericType) {
            boolean bl2;
            Object object = JniUtilsKt.resolvePrimitiveJniType((OCNumericType)$this$isCompatibleWithJniType, containingFile);
            if (object == null || (object = ((JvmPrimitiveType)object).getSymbol()) == null) {
                return false;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
                case 1: {
                    bl2 = false;
                    break;
                }
                case 2: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jboolean");
                    break;
                }
                case 3: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jbyte");
                    break;
                }
                case 4: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jchar");
                    break;
                }
                case 5: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jshort");
                    break;
                }
                case 6: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jint");
                    break;
                }
                case 7: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jlong");
                    break;
                }
                case 8: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jfloat");
                    break;
                }
                case 9: {
                    bl2 = Intrinsics.areEqual((Object)jniType, (Object)"jdouble");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl2;
        }
        if (!($this$isCompatibleWithJniType instanceof OCPointerType)) {
            return false;
        }
        OCType oCType = ((OCPointerType)$this$isCompatibleWithJniType).getRefType();
        Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"this.refType");
        String realTypeName = JniUtilsKt.resolveRealTypeName(oCType);
        if (Intrinsics.areEqual((Object)jniType, (Object)"JNIEnv *")) {
            bl = isCpp ? Intrinsics.areEqual((Object)realTypeName, (Object)"_JNIEnv") : Intrinsics.areEqual((Object)realTypeName, (Object)"*JNINativeInterface");
        } else if (isCpp) {
            bl = Intrinsics.areEqual((Object)realTypeName, (Object)("_" + jniType));
        } else {
            Object[] objectArray = new String[]{"jobject", "jthrowable", "jclass", "jobjectArray"};
            bl = SetsKt.setOf((Object[])objectArray).contains(jniType) ? Intrinsics.areEqual((Object)realTypeName, (Object)"void") : false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<SimpleParameterDeclaration>> unify(List<? extends List<SimpleParameterDeclaration>> $this$unify) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$unify;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$mapTo$iv$iv;
            List signature = (List)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = signature;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SimpleParameterDeclaration simpleParameterDeclaration = (SimpleParameterDeclaration)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(NdkConstants.JOBJECT_VARIATION.contains(it.getType()) ? "jobject" : it.getType());
            }
            List key$iv$iv = (List)destination$iv$iv2;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map indexedByNormalizedTypes = destination$iv$iv;
        List result = new ArrayList();
        indexedByNormalizedTypes.forEach(new BiConsumer(result){
            final /* synthetic */ List<List<SimpleParameterDeclaration>> $result;
            {
                this.$result = $result;
            }

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull List<String> unifiedTypes, @NotNull List<? extends List<SimpleParameterDeclaration>> compatibleSignatures) {
                Intrinsics.checkNotNullParameter(unifiedTypes, (String)"unifiedTypes");
                Intrinsics.checkNotNullParameter(compatibleSignatures, (String)"compatibleSignatures");
                if (compatibleSignatures.size() == 1) {
                    CollectionsKt.addAll((Collection)this.$result, (Iterable)compatibleSignatures);
                } else {
                    List unifiedSignature = new ArrayList<E>();
                    Iterable $this$forEachIndexed$iv = unifiedTypes;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void $this$mapTo$iv$iv;
                        void $this$mapTo$iv$iv2;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv;
                        int i = n;
                        boolean bl = false;
                        Iterable $this$map$iv = compatibleSignatures;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo22 = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            List list = (List)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(((SimpleParameterDeclaration)it.get(i)).getName());
                        }
                        String unifiedArgName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), (CharSequence)"_or_", null, null, (int)0, null, null, (int)62, null);
                        Collection collection = unifiedSignature;
                        Iterable $this$map$iv2 = compatibleSignatures;
                        boolean $i$f$map2 = false;
                        Iterable $i$f$mapTo22 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            List list = (List)item$iv$iv;
                            Collection collection2 = destination$iv$iv2;
                            boolean bl3 = false;
                            collection2.add(((SimpleParameterDeclaration)it.get(i)).getType());
                        }
                        String string2 = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
                        if (string2 == null) {
                            void unifiedType;
                            string2 = unifiedType;
                        }
                        String string3 = unifiedArgName;
                        String string4 = string2;
                        collection.add(new SimpleParameterDeclaration(string4, string3));
                    }
                    ((Collection)this.$result).add(unifiedSignature);
                }
            }
        });
        return result;
    }

    public static final /* synthetic */ List access$unify(List $receiver) {
        return JniFunctionSignatureInspectionKt.unify($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JvmPrimitiveTypeSymbol.values().length];
            nArray[JvmPrimitiveTypeSymbol.VOID.ordinal()] = 1;
            nArray[JvmPrimitiveTypeSymbol.BOOLEAN.ordinal()] = 2;
            nArray[JvmPrimitiveTypeSymbol.BYTE.ordinal()] = 3;
            nArray[JvmPrimitiveTypeSymbol.CHAR.ordinal()] = 4;
            nArray[JvmPrimitiveTypeSymbol.SHORT.ordinal()] = 5;
            nArray[JvmPrimitiveTypeSymbol.INT.ordinal()] = 6;
            nArray[JvmPrimitiveTypeSymbol.LONG.ordinal()] = 7;
            nArray[JvmPrimitiveTypeSymbol.FLOAT.ordinal()] = 8;
            nArray[JvmPrimitiveTypeSymbol.DOUBLE.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

