/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniFunctionSignatureInspection;
import com.android.tools.ndk.jni.inspections.JniFunctionSignatureInspectionKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.model.SimpleParameterDeclaration;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.OrdinalFormat;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniFunctionSignatureInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectMethodSignature", "", "element", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "expectedParameterDeclarations", "", "Lcom/android/tools/ndk/jni/model/SimpleParameterDeclaration;", "returnType", "", "android-ndk"})
public final class JniFunctionSignatureInspection
extends JniInspectionTool {
    public JniFunctionSignatureInspection() {
        super(JniInspectionEvent.JniInspectionType.PARAMETERS_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder, isOnTheFly){
            final /* synthetic */ JniFunctionSignatureInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Object object = MethodInfo.Companion.fromPsiElement(element, false);
                NativeMethodInfo nativeMethodInfo = object instanceof NativeMethodInfo ? (NativeMethodInfo)object : null;
                if (nativeMethodInfo == null) {
                    return;
                }
                NativeMethodInfo nativeMethodInfo2 = nativeMethodInfo;
                JniInspectionTool jniInspectionTool = this.this$0;
                object = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                boolean bl = this.$isOnTheFly;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    JniLocalQuickFix[] jniLocalQuickFixArray;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object object2;
                    List<JvmMethodInfo> manuallyRegistered;
                    OCFunctionDeclaration ocFunctionDeclaration;
                    block22: {
                        block21: {
                            JniUsageEventReporter $this$reportPerf_u24lambda_u2d0$iv = reporter$iv$iv;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ocFunctionDeclaration = nativeMethodInfo2.getPsiElement();
                            Project project3 = ocFunctionDeclaration.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"ocFunctionDeclaration.project");
                            manuallyRegistered = JniMethodResolver.Companion.getInstance(project3).resolveManuallyRegistered(nativeMethodInfo2);
                            NativeMethodId nativeMethodId = nativeMethodInfo2.getNativeMethodId();
                            object2 = nativeMethodId instanceof JniNativeMethodId ? (JniNativeMethodId)nativeMethodId : null;
                            if (object2 == null) break block21;
                            JniNativeMethodId it = object2;
                            boolean bl4 = false;
                            Project project4 = ocFunctionDeclaration.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"ocFunctionDeclaration.project");
                            List<JvmMethodInfo> list = JniMethodResolver.Companion.getInstance(project4).resolveImplicitlyLinkedNativeMethod(it);
                            object2 = list;
                            if (list != null) break block22;
                        }
                        object2 = CollectionsKt.emptyList();
                    }
                    List<JvmMethodInfo> implicitlyLinked = object2;
                    List matchedMethodInfos = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)manuallyRegistered, (Iterable)implicitlyLinked));
                    Iterable iterable = matchedMethodInfos;
                    boolean $i$f$map = false;
                    void bl4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        collection.add(CollectionsKt.plus((Collection)it.generateNativeParameterDeclarations(), (Object)new SimpleParameterDeclaration(it.getReturnType().toJniType(), "return_value")));
                    }
                    List expectedParameterDeclarations = JniFunctionSignatureInspectionKt.access$unify((List)destination$iv$iv);
                    PsiElement psiElement = ocFunctionDeclaration.getNameIdentifier();
                    if (psiElement == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"ocFunctionDeclaration.nameIdentifier ?: return");
                    PsiElement nameIdentifier = psiElement;
                    if (manuallyRegistered.isEmpty()) {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv2;
                        Iterable $this$map$iv2 = implicitlyLinked;
                        boolean $i$f$map2 = false;
                        Iterable $i$f$mapTo2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo3 = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv2) {
                            void jvmMethodInfo;
                            JvmMethodInfo jvmMethodInfo2 = (JvmMethodInfo)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl6 = false;
                            collection.add(((JniInspectionTool)((Object)object)).quickFix("Specialize JNI function", "Specialize to " + jvmMethodInfo.getDescription(), (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>((JvmMethodInfo)jvmMethodInfo){
                                final /* synthetic */ JvmMethodInfo $jvmMethodInfo;
                                {
                                    this.$jvmMethodInfo = $jvmMethodInfo;
                                    super(2);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                                    Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
                                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                                    String[] stringArray = new String[]{this.$jvmMethodInfo.toJniNativeMethodId(false).getFunctionName()};
                                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, stringArray);
                                }
                            })));
                        }
                        $this$map$iv2 = (List)destination$iv$iv2;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        JniLocalQuickFix[] jniLocalQuickFixArray2 = thisCollection$iv.toArray(new JniLocalQuickFix[0]);
                        if (jniLocalQuickFixArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        jniLocalQuickFixArray = jniLocalQuickFixArray2;
                    } else {
                        boolean $i$f$emptyArray = false;
                        jniLocalQuickFixArray = (JniLocalQuickFix[])((Object[])new JniLocalQuickFix[0]);
                    }
                    JniLocalQuickFix[] quickFixes2 = jniLocalQuickFixArray;
                    switch (expectedParameterDeclarations.size()) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            List expectedParameterDeclaration = (List)CollectionsKt.single((List)expectedParameterDeclarations);
                            JniFunctionSignatureInspection.access$inspectMethodSignature((JniFunctionSignatureInspection)((Object)object), ocFunctionDeclaration, problemsHolder, CollectionsKt.dropLast((List)expectedParameterDeclaration, (int)1), ((SimpleParameterDeclaration)CollectionsKt.last((List)expectedParameterDeclaration)).getType());
                            if (matchedMethodInfos.size() <= 1 || !bl) break;
                            InspectionUtilsKt.registerOcProblem(problemsHolder, nameIdentifier, "Multiple methods are linked to this JNI method.", ProblemHighlightType.INFORMATION, Arrays.copyOf(quickFixes2, quickFixes2.length));
                            break;
                        }
                        default: {
                            InspectionUtilsKt.registerOcProblem(problemsHolder, nameIdentifier, "Multiple incompatible methods are linked to this JNI method.", ProblemHighlightType.GENERIC_ERROR, Arrays.copyOf(quickFixes2, quickFixes2.length));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant bl2 = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl2).toMillis())));
                    }
                }
            }
        };
    }

    private final void inspectMethodSignature(OCFunctionDeclaration element, ProblemsHolder holder, List<SimpleParameterDeclaration> expectedParameterDeclarations, String returnType) {
        JniLocalQuickFix[] jniLocalQuickFixArray;
        OCParameterList parameterList;
        Object object;
        boolean isCpp = OCLanguageKindCalculator.calculateLanguageKindFast((PsiFile)element.getContainingFile()).isCpp();
        OCTypeElement oCTypeElement = element.getReturnTypeElement();
        PsiElement returnTypeElement = oCTypeElement != null ? oCTypeElement.getOriginalElement() : null;
        OCType oCType = element.getResolvedType();
        Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"element.resolvedType");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"element.containingFile");
        if (!JniFunctionSignatureInspectionKt.isCompatibleWithJniType(oCType, psiFile, returnType, isCpp) && returnTypeElement != null) {
            JniLocalQuickFix[] jniLocalQuickFixArray2 = new JniLocalQuickFix[]{this.quickFix("Fix return type of JNI function", "Fix return type of " + element.getName() + ".", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(returnType){
                final /* synthetic */ String $returnType;
                {
                    this.$returnType = $returnType;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    String[] stringArray = new String[]{this.$returnType};
                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, stringArray);
                }
            }))};
            InspectionUtilsKt.registerOcProblem(holder, returnTypeElement, "Incorrect return type " + element.getReturnType().getName() + ", which should have been " + returnType + ".", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray2);
        }
        if ((object = (parameterList = element.getParameterList())) == null || (object = object.getParameterDeclarations()) == null) {
            return;
        }
        Object actualParameterDeclarations = object;
        int minLength = Math.min(expectedParameterDeclarations.size(), actualParameterDeclarations.size());
        for (int i = 0; i < minLength; ++i) {
            Object object2;
            boolean bl;
            OCParameterDeclaration actual = (OCParameterDeclaration)actualParameterDeclarations.get(i);
            SimpleParameterDeclaration expected = expectedParameterDeclarations.get(i);
            OCDeclarator oCDeclarator = actual.getDeclarator();
            if (oCDeclarator != null && (oCDeclarator = oCDeclarator.getResolvedType()) != null) {
                PsiFile psiFile2 = element.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
                bl = JniFunctionSignatureInspectionKt.isCompatibleWithJniType((OCType)oCDeclarator, psiFile2, expected.getType(), isCpp);
            } else {
                bl = false;
            }
            if (bl) continue;
            Object object3 = actual.getDeclarator();
            if (object3 != null && (object3 = object3.getName()) != null) {
                Object object4;
                Object it = object4 = object3;
                boolean bl2 = false;
                object2 = !Intrinsics.areEqual((Object)it, (Object)"<unnamed>") ? object4 : null;
            } else {
                object2 = null;
            }
            Object parameterName = object2;
            String parameterDescription = parameterName == null ? "the " + OrdinalFormat.formatEnglish((long)((long)i + 1L)) + " parameter" : "parameter '" + parameterName + "'";
            Intrinsics.checkNotNullExpressionValue((Object)actual, (String)"actual");
            JniLocalQuickFix[] jniLocalQuickFixArray3 = new JniLocalQuickFix[]{this.quickFix("Fix parameter type of JNI function", "Fix type of " + parameterDescription, (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(expected, (String)parameterName){
                final /* synthetic */ SimpleParameterDeclaration $expected;
                final /* synthetic */ String $parameterName;
                {
                    this.$expected = $expected;
                    this.$parameterName = $parameterName;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    String[] stringArray = new String[1];
                    String string = this.$parameterName;
                    if (string == null) {
                        string = this.$expected.getName();
                    }
                    stringArray[0] = SimpleParameterDeclaration.copy$default(this.$expected, null, string, 1, null).toString();
                    return InspectionUtilsKt.replaceAtHighlighted(descriptor, stringArray);
                }
            }))};
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)actual, "Incorrect type for " + parameterDescription + ", which should have type '" + expected.getType() + "'.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray3);
        }
        if (actualParameterDeclarations.size() < expectedParameterDeclarations.size()) {
            List<SimpleParameterDeclaration> missingParameterDeclarations = expectedParameterDeclarations.subList(minLength, expectedParameterDeclarations.size());
            PsiElement rightParenthsis = parameterList.getLastChild();
            String missingParameters2 = CollectionsKt.joinToString$default((Iterable)missingParameterDeclarations, null, null, null, (int)0, null, (Function1)inspectMethodSignature.missingParameters.1.INSTANCE, (int)31, null);
            Intrinsics.checkNotNullExpressionValue((Object)rightParenthsis, (String)"rightParenthsis");
            jniLocalQuickFixArray = new JniLocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Insert missing parameters", null, (Function2)new Function2<Project, ProblemDescriptor, Boolean>((List<OCParameterDeclaration>)actualParameterDeclarations, missingParameterDeclarations){
                final /* synthetic */ List<OCParameterDeclaration> $actualParameterDeclarations;
                final /* synthetic */ List<SimpleParameterDeclaration> $missingParameterDeclarations;
                {
                    this.$actualParameterDeclarations = $actualParameterDeclarations;
                    this.$missingParameterDeclarations = $missingParameterDeclarations;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                    String[] stringArray = new String[]{(this.$actualParameterDeclarations.isEmpty() ? "" : ", ") + CollectionsKt.joinToString$default((Iterable)this.$missingParameterDeclarations, null, null, null, (int)0, null, null, (int)63, null)};
                    return InspectionUtilsKt.insertAtHighlighted(descriptor, stringArray);
                }
            }, 2, null)};
            InspectionUtilsKt.registerOcProblem(holder, rightParenthsis, "Missing parameter" + (missingParameterDeclarations.size() == 1 ? "" : "s") + ": " + missingParameters2 + ".", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        } else if (actualParameterDeclarations.size() > expectedParameterDeclarations.size()) {
            List<OCParameterDeclaration> unexpectedParameterDeclarations = actualParameterDeclarations.subList(minLength, actualParameterDeclarations.size());
            for (OCParameterDeclaration unexpectedParameterDeclaration : unexpectedParameterDeclarations) {
                Intrinsics.checkNotNullExpressionValue((Object)unexpectedParameterDeclaration, (String)"unexpectedParameterDeclaration");
                jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Remove extra parameters", "Remove extra parameter" + (unexpectedParameterDeclarations.size() == 1 ? "" : "s"), (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)new Function2<Project, ProblemDescriptor, Boolean>(unexpectedParameterDeclarations){
                    final /* synthetic */ List<OCParameterDeclaration> $unexpectedParameterDeclarations;
                    {
                        this.$unexpectedParameterDeclarations = $unexpectedParameterDeclarations;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this.$unexpectedParameterDeclarations){
                            final /* synthetic */ List<OCParameterDeclaration> $unexpectedParameterDeclarations;
                            {
                                this.$unexpectedParameterDeclarations = $unexpectedParameterDeclarations;
                            }

                            public final void run() {
                                Iterable $this$forEach$iv = this.$unexpectedParameterDeclarations;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    OCParameterDeclaration it = (OCParameterDeclaration)element$iv;
                                    boolean bl = false;
                                    OCChangeUtil.delete((PsiElement)((PsiElement)it));
                                }
                            }
                        });
                        return true;
                    }
                }))};
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)unexpectedParameterDeclaration, "Unexpected parameter declaration.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
            }
        }
    }

    public static final /* synthetic */ void access$inspectMethodSignature(JniFunctionSignatureInspection $this, OCFunctionDeclaration element, ProblemsHolder holder, List expectedParameterDeclarations, String returnType) {
        $this.inspectMethodSignature(element, holder, expectedParameterDeclarations, returnType);
    }
}

