/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.jni.inspections.JavaJniMissingFunctionInspection;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.KotlinJniMissingFunctionInspection;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/ndk/jni/inspections/JavaJniMissingFunctionInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "android-ndk"})
public final class JavaJniMissingFunctionInspection
extends JniInspectionTool {
    public JavaJniMissingFunctionInspection() {
        super(JniInspectionEvent.JniInspectionType.MISSING_FUNCTION_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!NdkHelper.isNdkProject(holder.getProject())) {
            PsiElementVisitor psiElementVisitor2 = super.buildVisitor(holder, isOnTheFly, session);
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"{\n      super.buildVisit\u2026sOnTheFly, session)\n    }");
        } else {
            psiElementVisitor = (PsiElementVisitor)new JavaElementVisitor(this, holder){
                final /* synthetic */ JavaJniMissingFunctionInspection this$0;
                final /* synthetic */ ProblemsHolder $holder;
                {
                    this.this$0 = $receiver;
                    this.$holder = $holder;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void visitMethod(@NotNull PsiMethod method) {
                    void inspectionType$iv$iv;
                    void $this$reportJniPerf$iv$iv;
                    void this_$iv;
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    if (!JniUtilsKt.isNative((JvmMethod)method) || OCGlobalProjectSymbolsCache.getAllSymbolNames((Project)method.getProject()).isEmpty()) {
                        return;
                    }
                    JniInspectionTool jniInspectionTool = this.this$0;
                    ProblemsHolder problemsHolder = this.$holder;
                    JavaJniMissingFunctionInspection javaJniMissingFunctionInspection = this.this$0;
                    boolean $i$f$reportPerf$android_ndk = false;
                    Project project = ((PsiElement)method).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
                    Project project2 = project;
                    JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                    int n = 100;
                    boolean $i$f$reportJniPerf = false;
                    JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                    Instant startTime$iv$iv = Instant.now();
                    try {
                        JvmMethodInfo jvmMethodInfo;
                        JniUsageEventReporter $this$reportPerf_u24lambda_u2d0$iv = reporter$iv$iv;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (JvmMethodInfo.Companion.fromJavaMethod(method) == null) {
                            return;
                        }
                        JvmMethodInfo jvmMethodInfo2 = jvmMethodInfo;
                        Project project3 = method.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"method.project");
                        if (JniMethodResolver.Companion.getInstance(project3).resolveJavaOrKotlinMethod(jvmMethodInfo2).stream().anyMatch((Predicate)buildVisitor.visitMethod.1.1.INSTANCE)) {
                            return;
                        }
                        KotlinJniMissingFunctionInspection.Companion.registerMissingJniDefinitionProblem(problemsHolder, javaJniMissingFunctionInspection, jvmMethodInfo2);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        void inverseSampleRate$iv$iv;
                        if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                            Instant bl = Instant.now();
                            JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl).toMillis())));
                        }
                    }
                }
            };
        }
        return psiElementVisitor;
    }
}

