/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.completion;

import com.android.tools.ndk.jni.completion.CompletionUtilsKt;
import com.android.tools.ndk.jni.model.JniCall;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PlatformIcons;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a<\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0010\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0012\u00a8\u0006\u0013"}, d2={"insertLiteralStringForCompletion", "", "stringLiteral", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "toLookupItem", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "Lcom/android/tools/ndk/jni/model/JvmMethodInfo;", "classForCompletion", "Lcom/intellij/psi/PsiClass;", "methodTypeExpression", "Lcom/jetbrains/cidr/lang/psi/OCExpression;", "extraModification", "Lkotlin/Function1;", "updateFunctionIdentifier", "Lcom/android/tools/ndk/jni/model/JniCall;", "android-ndk"})
public final class CompletionUtilsKt {
    public static final void insertLiteralStringForCompletion(@NotNull String stringLiteral, @NotNull CompletionParameters parameters, @NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)stringLiteral, (String)"stringLiteral");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCFile");
        OCFile ocFile = (OCFile)psiFile;
        PsiElement originalPosition = parameters.getOriginalPosition();
        String replacement = JniUtilsKt.quoted(stringLiteral);
        if (originalPosition != null) {
            int replaceStartOffset = originalPosition.getTextOffset();
            OCChangeUtil.changeText((Project)context.getProject(), (PsiFile)((PsiFile)ocFile), (int)replaceStartOffset, (int)originalPosition.getTextLength(), (String)replacement, (boolean)false);
            context.getEditor().getCaretModel().moveToOffset(replaceStartOffset + replacement.length());
        } else {
            OCChangeUtil.changeText((Project)context.getProject(), (PsiFile)((PsiFile)ocFile), (int)context.getStartOffset(), (int)(context.getStartOffset() - context.getTailOffset()), (String)replacement, (boolean)false);
        }
    }

    public static final void updateFunctionIdentifier(@NotNull JniCall $this$updateFunctionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$updateFunctionIdentifier, (String)"<this>");
        PsiElement functionIdentifier = $this$updateFunctionIdentifier.getFunctionIdentifier();
        OCChangeUtil.changeText((Project)$this$updateFunctionIdentifier.getCallExpression().getProject(), (PsiFile)$this$updateFunctionIdentifier.getCallExpression().getContainingFile(), (int)functionIdentifier.getTextOffset(), (int)functionIdentifier.getTextLength(), (String)$this$updateFunctionIdentifier.getFunctionName(), (boolean)false);
    }

    @Nullable
    public static final LookupElementBuilder toLookupItem(@NotNull JvmMethodInfo $this$toLookupItem, @NotNull CompletionParameters parameters, @NotNull PsiClass classForCompletion, @Nullable OCExpression methodTypeExpression, @NotNull Function1<? super JvmMethodInfo, Unit> extraModification) {
        Intrinsics.checkNotNullParameter((Object)$this$toLookupItem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)classForCompletion, (String)"classForCompletion");
        Intrinsics.checkNotNullParameter(extraModification, (String)"extraModification");
        PsiElement psiElement = $this$toLookupItem.getPsiElement();
        PsiMethod psiMethod = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        PsiMethod psiMethod2 = psiMethod;
        if (psiMethod2 == null || (psiMethod2 = psiMethod2.getContainingClass()) == null) {
            psiMethod2 = classForCompletion;
        }
        PsiMethod containingClass = psiMethod2;
        PsiMethod psiMethod3 = psiMethod;
        return LookupElementBuilder.create((String)$this$toLookupItem.getDescription()).withIcon(PlatformIcons.METHOD_ICON).withTailText(" (" + $this$toLookupItem.getClassName().getShortName() + ")").withTypeText($this$toLookupItem.getReturnType().toShortJavaType()).withBoldness(Intrinsics.areEqual((Object)containingClass, (Object)classForCompletion)).withStrikeoutness(psiMethod3 != null ? psiMethod3.isDeprecated() : false).withInsertHandler(new InsertHandler(parameters, methodTypeExpression, $this$toLookupItem, extraModification){
            final /* synthetic */ CompletionParameters $parameters;
            final /* synthetic */ OCExpression $methodTypeExpression;
            final /* synthetic */ JvmMethodInfo $this_toLookupItem;
            final /* synthetic */ Function1<JvmMethodInfo, Unit> $extraModification;
            {
                this.$parameters = $parameters;
                this.$methodTypeExpression = $methodTypeExpression;
                this.$this_toLookupItem = $receiver;
                this.$extraModification = $extraModification;
            }

            public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<anonymous parameter 1>");
                PsiFile psiFile = this.$parameters.getOriginalFile();
                Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.psi.OCFile");
                OCFile ocFile = (OCFile)psiFile;
                if (this.$methodTypeExpression == null) {
                    CompletionUtilsKt.insertLiteralStringForCompletion(this.$this_toLookupItem.getMethodName() + "\", \"" + this.$this_toLookupItem.getMethodType(), this.$parameters, context);
                } else {
                    OCChangeUtil.changeText((Project)this.$this_toLookupItem.getPsiElement().getProject(), (PsiFile)((PsiFile)ocFile), (int)this.$methodTypeExpression.getTextOffset(), (int)this.$methodTypeExpression.getTextLength(), (String)JniUtilsKt.quoted(this.$this_toLookupItem.getMethodType()), (boolean)false);
                    CompletionUtilsKt.insertLiteralStringForCompletion(this.$this_toLookupItem.getMethodName(), this.$parameters, context);
                }
                this.$extraModification.invoke((Object)this.$this_toLookupItem);
            }
        });
    }

    public static /* synthetic */ LookupElementBuilder toLookupItem$default(JvmMethodInfo jvmMethodInfo, CompletionParameters completionParameters, PsiClass psiClass, OCExpression oCExpression, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = toLookupItem.1.INSTANCE;
        }
        return CompletionUtilsKt.toLookupItem(jvmMethodInfo, completionParameters, psiClass, oCExpression, (Function1<? super JvmMethodInfo, Unit>)function1);
    }
}

