/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.configuration;

import com.android.tools.ndk.configuration.NdkConfigurationValidatorKt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a^\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b2\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\u000b"}, d2={"isValidNdkConfiguration", "", "compilerSwitches", "", "", "workingDir", "Ljava/nio/file/Path;", "isValidAndroidSysroot", "Lkotlin/Function1;", "isValidAndroidSysrootUsrInclude", "isPotentialNonAndroidSysrootUsrInclude", "android-ndk"})
public final class NdkConfigurationValidatorKt {
    public static final boolean isValidNdkConfiguration(@NotNull List<String> compilerSwitches, @NotNull Path workingDir, @NotNull Function1<? super Path, Boolean> isValidAndroidSysroot, @NotNull Function1<? super Path, Boolean> isValidAndroidSysrootUsrInclude, @NotNull Function1<? super Path, Boolean> isPotentialNonAndroidSysrootUsrInclude) {
        Intrinsics.checkNotNullParameter(compilerSwitches, (String)"compilerSwitches");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter(isValidAndroidSysroot, (String)"isValidAndroidSysroot");
        Intrinsics.checkNotNullParameter(isValidAndroidSysrootUsrInclude, (String)"isValidAndroidSysrootUsrInclude");
        Intrinsics.checkNotNullParameter(isPotentialNonAndroidSysrootUsrInclude, (String)"isPotentialNonAndroidSysrootUsrInclude");
        boolean isValidConfiguration = false;
        boolean isystemFound = false;
        boolean sysrootFound = false;
        for (String quotedArgument : compilerSwitches) {
            Path systemIncludePath;
            block9: {
                block8: {
                    Path sysroot;
                    String sysrootPath;
                    String argument;
                    Intrinsics.checkNotNullExpressionValue((Object)StringUtilRt.unquoteString((String)((Object)StringsKt.trim((CharSequence)quotedArgument)).toString()), (String)"unquoteString(quotedArgument.trim())");
                    Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimStart((String)argument, (String)"--sysroot="), (String)"trimStart(argument, \"--sysroot=\")");
                    if (sysrootPath.length() < argument.length()) {
                        sysroot = workingDir.resolve(sysrootPath);
                        Intrinsics.checkNotNullExpressionValue((Object)sysroot, (String)"sysroot");
                        isValidConfiguration = (Boolean)isValidAndroidSysroot.invoke((Object)sysroot);
                        if (isValidConfiguration) continue;
                        return false;
                    }
                    if (Intrinsics.areEqual((Object)argument, (Object)"--sysroot")) {
                        sysrootFound = true;
                        continue;
                    }
                    if (sysrootFound) {
                        sysrootFound = false;
                        sysroot = workingDir.resolve(FileUtilRt.toSystemIndependentName((String)argument));
                        Intrinsics.checkNotNullExpressionValue((Object)sysroot, (String)"sysroot");
                        isValidConfiguration = (Boolean)isValidAndroidSysroot.invoke((Object)sysroot);
                        if (isValidConfiguration) continue;
                        return false;
                    }
                    if (Intrinsics.areEqual((Object)argument, (Object)"-isystem")) {
                        isystemFound = true;
                        continue;
                    }
                    if (!isystemFound) continue;
                    isystemFound = false;
                    systemIncludePath = workingDir.resolve(FileUtilRt.toSystemIndependentName((String)argument));
                    Intrinsics.checkNotNullExpressionValue((Object)systemIncludePath, (String)"systemIncludePath");
                    if (((Boolean)isValidAndroidSysrootUsrInclude.invoke((Object)systemIncludePath)).booleanValue()) break block8;
                    Path path = systemIncludePath.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"systemIncludePath.parent");
                    if (!((Boolean)isValidAndroidSysrootUsrInclude.invoke((Object)path)).booleanValue()) break block9;
                }
                isValidConfiguration = true;
                continue;
            }
            if (!((Boolean)isPotentialNonAndroidSysrootUsrInclude.invoke((Object)systemIncludePath)).booleanValue()) continue;
            return false;
        }
        return isValidConfiguration;
    }

    public static /* synthetic */ boolean isValidNdkConfiguration$default(List list, Path path, Function1 function1, Function1 function12, Function1 function13, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = isValidNdkConfiguration.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function12 = isValidNdkConfiguration.2.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function13 = isValidNdkConfiguration.3.INSTANCE;
        }
        return NdkConfigurationValidatorKt.isValidNdkConfiguration(list, path, (Function1<? super Path, Boolean>)function1, (Function1<? super Path, Boolean>)function12, (Function1<? super Path, Boolean>)function13);
    }
}

