/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.configuration;

import com.android.repository.Revision;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeFile;
import com.android.tools.idea.gradle.model.ndk.v1.IdeNativeToolchain;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.model.VariantAbi;
import com.android.tools.idea.ndk.ModuleVariantAbi;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.configuration.CxxSyncUtilsKt;
import com.android.tools.ndk.sync.NativeDataService;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\n\u001a\u0004\u0018\u00010\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u001a8\u0010\n\u001a\u0004\u0018\u00010\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u000e2\u001e\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00140\u00130\u0012H\u0007\u001a\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b\u001a\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0016\u001a\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u000b\u001a\u001e\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020%\u0018\u00010\u00132\b\u0010&\u001a\u0004\u0018\u00010\u0016\u001a8\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u00110\u0010\u001a\u0016\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202\u001a\f\u00103\u001a\u0004\u0018\u000104*\u000205\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u00066"}, d2={"CXX_CONFIGURATION_NOTIFICATION", "Lcom/intellij/notification/NotificationGroup;", "REMOVE_CONSOLE_COLORS_REGEX", "Lkotlin/text/Regex;", "abiRegex", "moduleVariantAbi", "Lcom/android/tools/idea/ndk/ModuleVariantAbi;", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getModuleVariantAbi", "(Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)Lcom/android/tools/idea/ndk/ModuleVariantAbi;", "buildConsoleMessagesBalloonText", "", "K", "messageType", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message$Type;", "messages", "Lcom/intellij/util/containers/MultiMap;", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message;", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "compilerExecutable", "Ljava/io/File;", "lang", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "toolchain", "Lcom/android/tools/idea/gradle/model/ndk/v1/IdeNativeToolchain;", "cxxCompilerKindFromExeFilename", "Lcom/jetbrains/cidr/lang/workspace/compiler/OCCompilerKind;", "cxxLanguageKindFromExtension", "Lcom/jetbrains/cidr/lang/CLanguageKind;", "extension", "cxxLanguageKindFromFile", "file", "cxxLanguageKindFromFilename", "filename", "findNdkFolderFromFileInNdk", "Lcom/android/repository/Revision;", "fileInNdk", "showMessagesBalloon", "", "project", "Lcom/intellij/openapi/project/Project;", "type", "level", "Lcom/intellij/notification/NotificationType;", "workingDirectory", "model", "Lcom/android/tools/idea/gradle/project/model/NdkModuleModel;", "nativeFile", "Lcom/android/tools/idea/gradle/model/ndk/v1/IdeNativeFile;", "toVariantAbi", "Lcom/android/tools/idea/gradle/project/model/VariantAbi;", "Lcom/jetbrains/cidr/lang/workspace/OCVariant;", "android-ndk"})
public final class CxxSyncUtilsKt {
    @NotNull
    private static final NotificationGroup CXX_CONFIGURATION_NOTIFICATION;
    @NotNull
    private static final Regex REMOVE_CONSOLE_COLORS_REGEX;
    @NotNull
    private static final Regex abiRegex;

    public static final <K> void showMessagesBalloon(@NotNull Project project, @NotNull CompilerInfoCache.Message.Type type, @NotNull NotificationType level, @NotNull MultiMap<K, CompilerInfoCache.Message> messages) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        String message = CxxSyncUtilsKt.buildConsoleMessagesBalloonText(type, messages);
        if (message != null) {
            CXX_CONFIGURATION_NOTIFICATION.createNotification("C/C++ Configuration Problem", message, level).notify(project);
        }
    }

    private static final <K> String buildConsoleMessagesBalloonText(CompilerInfoCache.Message.Type messageType, MultiMap<K, CompilerInfoCache.Message> messages) {
        Set set = messages.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"messages.entrySet()");
        return CxxSyncUtilsKt.buildConsoleMessagesBalloonText(messageType, SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)buildConsoleMessagesBalloonText.1.INSTANCE));
    }

    @VisibleForTesting
    @Nullable
    public static final <K> String buildConsoleMessagesBalloonText(@NotNull CompilerInfoCache.Message.Type messageType, @NotNull Sequence<? extends Pair<? extends K, ? extends Collection<? extends CompilerInfoCache.Message>>> messages) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)messageType, (String)"messageType");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Sequence<? extends Pair<? extends K, ? extends Collection<? extends CompilerInfoCache.Message>>> $this$sortedBy$iv = messages;
        boolean $i$f$sortedBy = false;
        Sequence sortedByKey = SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)String.valueOf(it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)String.valueOf(it.getFirst()))));
            }
        });
        Sequence filteredByType2 = SequencesKt.map((Sequence)sortedByKey, (Function1)new Function1<Pair<? extends K, ? extends Collection<? extends CompilerInfoCache.Message>>, Pair<? extends K, ? extends List<? extends CompilerInfoCache.Message>>>(messageType){
            final /* synthetic */ CompilerInfoCache.Message.Type $messageType;
            {
                this.$messageType = $messageType;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<K, List<CompilerInfoCache.Message>> invoke(@NotNull Pair<? extends K, ? extends Collection<? extends CompilerInfoCache.Message>> it) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Iterable iterable = (Iterable)it.getSecond();
                CompilerInfoCache.Message.Type type = this.$messageType;
                Object object = it.getFirst();
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    CompilerInfoCache.Message message = (CompilerInfoCache.Message)element$iv$iv;
                    boolean bl = false;
                    if (!(message.type == type)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                Object object2 = object;
                return new Pair(object2, (Object)list);
            }
        });
        Sequence emptyGroupsRemoved2 = SequencesKt.filter((Sequence)filteredByType2, (Function1)buildConsoleMessagesBalloonText.emptyGroupsRemoved.1.INSTANCE);
        Sequence textMessages2 = SequencesKt.map((Sequence)emptyGroupsRemoved2, (Function1)buildConsoleMessagesBalloonText.textMessages.1.INSTANCE);
        Sequence distinctMessages2 = SequencesKt.map((Sequence)textMessages2, (Function1)buildConsoleMessagesBalloonText.distinctMessages.1.INSTANCE);
        Sequence consoleColorsRemoved2 = SequencesKt.map((Sequence)distinctMessages2, (Function1)buildConsoleMessagesBalloonText.consoleColorsRemoved.1.INSTANCE);
        List finalMessages = SequencesKt.toList((Sequence)consoleColorsRemoved2);
        if (finalMessages.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$onEach$iv = finalMessages;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            Iterable iterable2;
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            Object key = pair.component1();
            List lines = (List)pair.component2();
            sb.append("<b>" + key + "</b><br/>");
            Iterable $this$onEach$iv2 = lines;
            boolean $i$f$onEach2 = false;
            Iterable $this$onEach_u24lambda_u2d16$iv2 = iterable2 = $this$onEach$iv2;
            $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
            for (Object element$iv2 : $this$onEach_u24lambda_u2d16$iv2) {
                String line = (String)element$iv2;
                boolean bl3 = false;
                sb.append(line + "<br/>");
            }
        }
        return sb.toString();
    }

    @Nullable
    public static final Pair<File, Revision> findNdkFolderFromFileInNdk(@Nullable File fileInNdk) {
        for (File current = fileInNdk; current != null; current = current.getParentFile()) {
            if (!new File(current, "source.properties").isFile() && !new File(current, "RELEASE.TXT").isFile()) continue;
            try {
                Revision version = Revision.parseRevision((String)NdkHelper.getNdkVersion(current));
                return new Pair((Object)current, (Object)version);
            }
            catch (Exception e) {
                Logger.getInstance(NativeDataService.class).warn("Failed to detect NDK root and version from file " + fileInNdk + ".", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static final File compilerExecutable(@NotNull OCLanguageKind lang, @NotNull IdeNativeToolchain toolchain) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)toolchain, (String)"toolchain");
        return lang == CLanguageKind.C ? toolchain.getCCompilerExecutable() : toolchain.getCppCompilerExecutable();
    }

    @NotNull
    public static final File workingDirectory(@NotNull NdkModuleModel model, @NotNull IdeNativeFile nativeFile) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)nativeFile, (String)"nativeFile");
        if (model.getFeatures().isWorkingDirectorySupported()) {
            File file = nativeFile.getWorkingDirectory();
            if (file == null) {
                file = model.getRootDirPath();
            }
            return file;
        }
        return model.getRootDirPath();
    }

    @NotNull
    public static final CLanguageKind cxxLanguageKindFromExtension(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = extension;
        return (Intrinsics.areEqual((Object)string, (Object)"c") ? true : Intrinsics.areEqual((Object)string, (Object)"C")) ? CLanguageKind.C : CLanguageKind.CPP;
    }

    @NotNull
    public static final CLanguageKind cxxLanguageKindFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CxxSyncUtilsKt.cxxLanguageKindFromExtension(FilesKt.getExtension((File)file));
    }

    @NotNull
    public static final CLanguageKind cxxLanguageKindFromFilename(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return CxxSyncUtilsKt.cxxLanguageKindFromExtension(FilesKt.getExtension((File)new File(filename)));
    }

    @NotNull
    public static final OCCompilerKind cxxCompilerKindFromExeFilename(@Nullable File compilerExecutable) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        if (compilerExecutable == null) break block4;
                        String string = compilerExecutable.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compilerExecutable.name");
                        if (StringsKt.endsWith$default((String)string, (String)"clang++", (boolean)false, (int)2, null)) break block5;
                        String string2 = compilerExecutable.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"compilerExecutable.name");
                        if (StringsKt.endsWith$default((String)string2, (String)"clang", (boolean)false, (int)2, null)) break block5;
                        String string3 = compilerExecutable.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"compilerExecutable.name");
                        if (!StringsKt.endsWith$default((String)string3, (String)"clang.exe", (boolean)false, (int)2, null)) break block6;
                    }
                    OCCompilerKind oCCompilerKind = OCCompilerKind.CLANG;
                    Intrinsics.checkNotNullExpressionValue((Object)oCCompilerKind, (String)"CLANG");
                    return oCCompilerKind;
                }
                String string = compilerExecutable.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compilerExecutable.name");
                if (StringsKt.endsWith$default((String)string, (String)"gcc", (boolean)false, (int)2, null)) break block7;
                String string4 = compilerExecutable.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"compilerExecutable.name");
                if (!StringsKt.endsWith$default((String)string4, (String)"gcc.exe", (boolean)false, (int)2, null)) break block4;
            }
            OCCompilerKind oCCompilerKind = OCCompilerKind.GCC;
            Intrinsics.checkNotNullExpressionValue((Object)oCCompilerKind, (String)"GCC");
            return oCCompilerKind;
        }
        OCCompilerKind oCCompilerKind = OCCompilerKind.UNKNOWN;
        Intrinsics.checkNotNullExpressionValue((Object)oCCompilerKind, (String)"UNKNOWN");
        return oCCompilerKind;
    }

    @Nullable
    public static final ModuleVariantAbi getModuleVariantAbi(@NotNull OCResolveConfiguration $this$moduleVariantAbi) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleVariantAbi, (String)"<this>");
        OCVariant oCVariant = $this$moduleVariantAbi.getVariant();
        if (oCVariant == null || (oCVariant = CxxSyncUtilsKt.toVariantAbi(oCVariant)) == null) {
            return null;
        }
        OCVariant oCVariant2 = oCVariant;
        String variant = oCVariant2.component1();
        String abi = oCVariant2.component2();
        String string = $this$moduleVariantAbi.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return new ModuleVariantAbi(string, variant, abi);
    }

    @Nullable
    public static final VariantAbi toVariantAbi(@NotNull OCVariant $this$toVariantAbi) {
        Intrinsics.checkNotNullParameter((Object)$this$toVariantAbi, (String)"<this>");
        if ($this$toVariantAbi.getParts().size() != 2) {
            return null;
        }
        List list = $this$toVariantAbi.getParts();
        String variant = (String)list.get(0);
        String abiWithDifferentiator = (String)list.get(1);
        MatchResult matchResult = abiRegex.matchEntire((CharSequence)abiWithDifferentiator);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        return new VariantAbi(variant, (String)match.getGroupValues().get(1));
    }

    public static final /* synthetic */ Regex access$getREMOVE_CONSOLE_COLORS_REGEX$p() {
        return REMOVE_CONSOLE_COLORS_REGEX;
    }

    static {
        PluginId pluginId = PluginId.getId((String)"com.android.tools.ndk");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(\"com.android.tools.ndk\")");
        CXX_CONFIGURATION_NOTIFICATION = NotificationGroup.Companion.balloonGroup("Resolve C/C++ Configurations", pluginId);
        REMOVE_CONSOLE_COLORS_REGEX = new Regex("\u001b?\\[\\d[;\\d]*[ -/]*[@-~]");
        abiRegex = new Regex("([-a-z_0-9]+)( \\(\\d+\\))?");
    }
}

