/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.cmake;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.cmake.CMakePreHighlightingVisitor;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CMakeEditingEvent;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cmake.CMakeListsFileType;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/ndk/cmake/CMakePostHighlightingVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "analyze", "", "file", "Lcom/intellij/psi/PsiFile;", "updateWholeFile", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "action", "Ljava/lang/Runnable;", "clone", "getStartTime", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Long;", "order", "", "suitableForFile", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "android-ndk"})
public final class CMakePostHighlightingVisitor
implements HighlightVisitor {
    @NotNull
    private final Logger LOG;

    public CMakePostHighlightingVisitor() {
        Logger logger = Logger.getInstance(CMakePostHighlightingVisitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(CMakePostHig\u2026htingVisitor::class.java)");
        this.LOG = logger;
    }

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!NdkHelper.isNdkProject(file.getProject())) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null ? Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(file.getName()), (Object)CMakeListsFileType.INSTANCE) : FileTypeManager.getInstance().isFileOfType(virtualFile, CMakeListsFileType.INSTANCE);
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (this.suitableForFile(file)) {
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            Long startTime = this.getStartTime(project);
            if (startTime != null) {
                long duration = System.currentTimeMillis() - startTime;
                AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CMAKE_EDITING_EVENT).setCmakeEditingEvent(CMakeEditingEvent.newBuilder().setEventDurationMs(duration).setKind(CMakeEditingEvent.CMakeEditingEventKind.SYNTAX_HIGHLIGHTING));
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n           \u2026ind.SYNTAX_HIGHLIGHTING))");
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder, (Project)file.getProject()));
                this.LOG.info("CMake syntax highlighting completed in " + duration + "ms");
            }
        }
        action.run();
        return true;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new CMakePostHighlightingVisitor();
    }

    @Deprecated(message="Deprecated in interface")
    public int order() {
        return 1;
    }

    private final Long getStartTime(Project project) {
        Object[] objectArray = Extensions.getExtensions((ExtensionPointName)HighlightVisitor.EP_HIGHLIGHT_VISITOR, (AreaInstance)((AreaInstance)project));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(HighlightV\u2026GHLIGHT_VISITOR, project)");
        for (HighlightVisitor visitor : (HighlightVisitor[])objectArray) {
            if (!(visitor instanceof CMakePreHighlightingVisitor)) continue;
            return (Long)((CMakePreHighlightingVisitor)visitor).getMyStartTime().get();
        }
        return null;
    }
}

