/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.ndk.NdkProjectInfo;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.graph.Graph;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NdkHelper {
    @NotNull
    public static String getArchitectureId(@NotNull Abi abi) {
        switch (abi) {
            case ARMEABI_V7A: 
            case ARMEABI: 
            case ARM64_V8A: {
                return ArchitectureType.ARM.getId();
            }
            case X86_64: {
                return ArchitectureType.X86_64.getId();
            }
            case X86: {
                return ArchitectureType.I386.getId();
            }
        }
        return ArchitectureType.UNKNOWN.getId();
    }

    @NotNull
    public static Abi getAbi(@NotNull IDevice targetDevice) {
        List abis = targetDevice.getAbis();
        for (String a : abis) {
            Abi abi = Abi.getEnum((String)a);
            if (abi == null) continue;
            return abi;
        }
        return Abi.ARMEABI_V7A;
    }

    @NotNull
    private static String getHostPlatformString() {
        Object platformString;
        if (SystemInfo.isLinux) {
            platformString = "linux";
        } else if (SystemInfo.isWindows) {
            platformString = "windows";
        } else if (SystemInfo.isMac) {
            platformString = "darwin";
        } else {
            return "UNKNOWN";
        }
        platformString = (String)platformString + "-";
        if (SystemInfo.is64Bit) {
            platformString = (String)platformString + "x86_64";
        } else if (SystemInfo.is32Bit) {
            platformString = (String)platformString + "x86";
        } else {
            return "UNKNOWN";
        }
        return platformString;
    }

    @NotNull
    public static File getLibStdCxxPrintersPath(@NotNull File ndkRoot, @NotNull String gccVersion) {
        File prebuilt = new File(ndkRoot, "prebuilt");
        File hostPlatform = new File(prebuilt, NdkHelper.getHostPlatformString());
        File share = new File(hostPlatform, "share");
        File prettyPrinters = new File(share, "pretty-printers");
        File libStdCxx = new File(prettyPrinters, "libstdcxx");
        return new File(libStdCxx, "gcc-" + gccVersion);
    }

    @NotNull
    public static File getClangTidyPath(@NotNull File ndkRoot) {
        File toolchains = new File(ndkRoot, "toolchains");
        File llvm = new File(toolchains, "llvm");
        File prebuilt = new File(llvm, "prebuilt");
        File hostPlatform = new File(prebuilt, NdkHelper.getHostPlatformString());
        File bin = new File(hostPlatform, "bin");
        return new File(bin, "clang-tidy" + (SystemInfo.isWindows ? ".exe" : ""));
    }

    public static boolean isNdkProject(@NotNull Project project) {
        return NdkProjectInfo.get(project).hasNdkModules() || AndroidProjectInfo.getInstance((Project)project).isApkProject();
    }

    public static boolean isNdkDeployment(@NotNull Project project, @NotNull Module debuggeeModule) {
        if (AndroidProjectInfo.getInstance((Project)project).isApkProject()) {
            return true;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            Graph dependencyGraph = moduleManager.moduleGraph();
            LinkedList<Module> workQueue = new LinkedList<Module>();
            HashSet<Module> seenModules = new HashSet<Module>();
            workQueue.add(debuggeeModule);
            while (!workQueue.isEmpty()) {
                Module module = (Module)workQueue.remove();
                if (module == null || !seenModules.add(module)) continue;
                if (NdkHelper.isNativeModule(module)) {
                    return true;
                }
                Iterator dependencies = dependencyGraph.getIn((Object)module);
                while (dependencies.hasNext()) {
                    workQueue.add((Module)dependencies.next());
                }
            }
            return false;
        });
    }

    private static boolean isNativeModule(Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get((Module)module);
        NdkModuleModel ndkModel = NdkModuleModel.get((Module)module);
        return ndkModel != null && androidModel != null;
    }

    public static void disableCppLanguageSupport(@NotNull Project project, boolean disable) {
        OCLanguage.LANGUAGE_SUPPORT_DISABLED.set((UserDataHolder)project, (Object)disable);
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            OCLanguage langToReset = disable ? OCLanguage.getInstance() : PlainTextLanguage.INSTANCE;
            FileManager fileManager = ((PsiManagerEx)PsiManager.getInstance((Project)project)).getFileManager();
            for (PsiFile file : fileManager.getAllCachedFiles()) {
                VirtualFile vf;
                if (file.getLanguage() != langToReset || (vf = OCFileUtil.getVirtualFile((PsiFile)file)) == null) continue;
                fileManager.setViewProvider(vf, null);
            }
        }));
    }

    @NotNull
    public static String getNdkVersion(@NotNull File ndkRoot) throws ExecutionException {
        File sourcePropertiesFile = new File(ndkRoot, "source.properties");
        if (sourcePropertiesFile.exists()) {
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(sourcePropertiesFile);
                Properties props = new Properties();
                props.load(fileInput);
                String string = props.getProperty("Pkg.Revision");
                return string;
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
            finally {
                if (fileInput != null) {
                    try {
                        ((InputStream)fileInput).close();
                    }
                    catch (IOException e) {
                        Logger.getInstance(NdkHelper.class).warn("Failed to close '" + sourcePropertiesFile.getPath() + "'", (Throwable)e);
                    }
                }
            }
        }
        File releaseTxtFile = new File(ndkRoot, "RELEASE.TXT");
        if (releaseTxtFile.exists()) {
            try {
                byte[] content = Files.readAllBytes(releaseTxtFile.toPath());
                return new String(content).trim();
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return "UNKNOWN";
    }

    @NotNull
    public static List<Module> getNativeModules(@NotNull Project project) {
        return Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).filter(m -> NdkModuleModel.get((Module)m) != null).collect(Collectors.toList());
    }
}

