/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageManagerKt;
import git4idea.util.GitFileUtils;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class GitVFSListener
extends VcsVFSListener {
    private GitVFSListener(@NotNull GitVcs vcs) {
        super((AbstractVcs)vcs);
    }

    @NotNull
    public static GitVFSListener createInstance(@NotNull GitVcs vcs) {
        GitVFSListener listener = new GitVFSListener(vcs);
        listener.installListeners();
        return listener;
    }

    @NotNull
    protected String getAddTitle() {
        return GitBundle.message("vfs.listener.add.title", new Object[0]);
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        return GitBundle.message("vfs.listener.add.single.title", new Object[0]);
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        return GitBundle.message("vfs.listener.add.single.prompt", new Object[0]);
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copiedFiles) {
        this.executeAddWithoutIgnores(addedFiles, copiedFiles, (notIgnoredAddedFiles, copiedFilesMap) -> this.originalExecuteAdd(notIgnoredAddedFiles, copiedFilesMap));
    }

    protected void executeAddWithoutIgnores(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copyFromMap, final @NotNull VcsVFSListener.ExecuteAddCallback executeAddCallback) {
        this.saveUnsavedVcsIgnoreFiles();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.message("vfs.listener.checking.ignored", new Object[0]), true){

            public void run(@NotNull ProgressIndicator pi) {
                Map<VirtualFile, List<VirtualFile>> sortedFiles = GitUtil.sortFilesByGitRootIgnoringMissing(this.myProject, addedFiles);
                HashSet<VirtualFile> retainedFiles = new HashSet<VirtualFile>();
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(Git.getInstance().untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                }
                addedFiles.retainAll(retainedFiles);
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> executeAddCallback.executeAdd(addedFiles, copyFromMap));
            }
        });
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(@NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        this.performAdding(ContainerUtil.map(addedFiles, VcsUtil::getFilePath));
    }

    private void performAdding(Collection<? extends FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.message("add.adding", new Object[0]), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (GitVFSListener.this.isStageEnabled()) {
                    GitVFSListener.this.executeAddingToIndex(root, files);
                } else {
                    GitVFSListener.this.executeAdding(root, files);
                }
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }
        });
    }

    @NotNull
    protected String getDeleteTitle() {
        return GitBundle.message("vfs.listener.delete.title", new Object[0]);
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.message("vfs.listener.delete.single.title", new Object[0]);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.message("vfs.listener.delete.single.prompt", new Object[0]);
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        this.performBackgroundOperation(filesToDelete, GitBundle.message("remove.removing", new Object[0]), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                GitVFSListener.this.executeDeletion(root, files);
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }
        });
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        Collection<FilePath> selectedToRemove;
        Collection<Object> selectedToAdd;
        ArrayList<FilePath> toAdd = new ArrayList<FilePath>();
        ArrayList<FilePath> toRemove = new ArrayList<FilePath>();
        final ArrayList<VcsVFSListener.MovedFileInfo> toForceMove = new ArrayList<VcsVFSListener.MovedFileInfo>();
        for (VcsVFSListener.MovedFileInfo movedInfo : movedFiles) {
            String oldPath = movedInfo.myOldPath;
            String newPath = movedInfo.myNewPath;
            if (!movedInfo.isCaseSensitive() && GitUtil.isCaseOnlyChange(oldPath, newPath)) {
                toForceMove.add(movedInfo);
                continue;
            }
            toRemove.add(VcsUtil.getFilePath((String)oldPath));
            toAdd.add(VcsUtil.getFilePath((String)newPath));
        }
        if (this.isStageEnabled()) {
            selectedToAdd = this.selectFilePathsToAdd(toAdd);
            selectedToRemove = this.selectFilePathsToDelete(toRemove);
        } else {
            selectedToAdd = toAdd;
            selectedToRemove = toRemove;
        }
        LOG.debug("performMoveRename. \ntoAdd: " + toAdd + "\ntoRemove: " + toRemove + "\ntoForceMove: " + toForceMove);
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, GitBundle.message("progress.title.moving.files", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    ArrayList<FilePath> dirtyPaths = new ArrayList<FilePath>();
                    ArrayList<File> toRefresh = new ArrayList<File>();
                    for (Map.Entry<VirtualFile, List<FilePath>> toAddEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, selectedToAdd).entrySet()) {
                        List<FilePath> files = toAddEntry.getValue();
                        GitVFSListener.this.executeAdding(toAddEntry.getKey(), files);
                        dirtyPaths.addAll(files);
                    }
                    for (Map.Entry<VirtualFile, List<FilePath>> toRemoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, selectedToRemove).entrySet()) {
                        List<FilePath> paths = toRemoveEntry.getValue();
                        GitVFSListener.this.executeDeletion(toRemoveEntry.getKey(), paths);
                        dirtyPaths.addAll(paths);
                    }
                    Map filesToForceMove = ContainerUtil.map2Map((Collection)toForceMove, info -> Pair.create((Object)VcsUtil.getFilePath((String)info.myNewPath), (Object)info));
                    dirtyPaths.addAll(ContainerUtil.map((Collection)toForceMove, fileInfo -> VcsUtil.getFilePath((String)fileInfo.myOldPath)));
                    for (Map.Entry<VirtualFile, List<FilePath>> toForceMoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, filesToForceMove.keySet()).entrySet()) {
                        List<FilePath> paths = toForceMoveEntry.getValue();
                        toRefresh.addAll(GitVFSListener.this.executeForceMove(toForceMoveEntry.getKey(), paths, filesToForceMove));
                        dirtyPaths.addAll(paths);
                    }
                    VcsFileUtil.markFilesDirty((Project)this.myProject, dirtyPaths);
                    RefreshVFsSynchronously.refreshFiles(toRefresh);
                }
                catch (VcsException ex) {
                    GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                }
            }
        });
    }

    private void executeAdding(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        LOG.debug("Git: adding files: " + files);
        GitFileUtils.addPaths(this.myProject, root, files, false, false);
    }

    private void executeAddingToIndex(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        LOG.debug("Git: adding files to index: " + files);
        GitFileUtils.addPathsToIndex(this.myProject, root, files);
    }

    private void executeDeletion(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        GitFileUtils.deletePaths(this.myProject, root, files, "--ignore-unmatch", "--cached", "-r");
    }

    private Set<File> executeForceMove(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, @NotNull Map<FilePath, VcsVFSListener.MovedFileInfo> filesToMove) {
        HashSet<File> toRefresh = new HashSet<File>();
        for (FilePath filePath : files) {
            VcsVFSListener.MovedFileInfo info = filesToMove.get(filePath);
            GitLineHandler h2 = new GitLineHandler(this.myProject, root, GitCommand.MV);
            h2.addParameters("-f");
            h2.addRelativePaths(VcsUtil.getFilePath((String)info.myOldPath), VcsUtil.getFilePath((String)info.myNewPath));
            Git.getInstance().runCommand(h2);
            toRefresh.add(new File(info.myOldPath));
            toRefresh.add(new File(info.myNewPath));
        }
        return toRefresh;
    }

    private boolean isStageEnabled() {
        return GitStageManagerKt.isStagingAreaAvailable(this.myProject);
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected boolean isRecursiveDeleteSupported() {
        return true;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return false;
    }

    @NotNull
    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (this.isStageEnabled()) {
            return super.selectFilePathsToDelete(deletedFiles);
        }
        return deletedFiles;
    }

    private void performBackgroundOperation(final @NotNull Collection<? extends FilePath> files, @NotNull @NlsContexts.ProgressTitle String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, files).forEach((root, filePaths) -> {
                    try {
                        executor.execute((VirtualFile)root, (List<? extends FilePath>)filePaths);
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                });
            }
        });
    }

    @TestOnly
    public void waitForExternalFilesEventsProcessedInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myExternalFilesProcessor.waitForEventsProcessedInTestMode();
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<? extends FilePath> var2) throws VcsException;
    }
}

