/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import git4idea.repo.GitRepository;
import git4idea.validators.GitBranchValidatorKt;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GitNewBranchNameValidator
implements InputValidatorEx {
    private final Collection<? extends GitRepository> myRepositories;
    @Nls
    private String myErrorText;

    private GitNewBranchNameValidator(@NotNull Collection<? extends GitRepository> repositories) {
        this.myRepositories = repositories;
    }

    public static GitNewBranchNameValidator newInstance(@NotNull Collection<? extends GitRepository> repositories) {
        return new GitNewBranchNameValidator(repositories);
    }

    public boolean checkInput(@NotNull String inputString) {
        ValidationInfo info = GitBranchValidatorKt.validateName(this.myRepositories, inputString);
        this.myErrorText = info != null ? info.message : null;
        return info == null;
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    public String getErrorText(String inputString) {
        return this.myErrorText;
    }
}

