/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.ui.ChangesBrowserWithRollback;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalChangesWouldBeOverwrittenHelper {
    @Nls
    @NotNull
    public static String getErrorNotificationDescription() {
        return LocalChangesWouldBeOverwrittenHelper.getErrorDescription(true);
    }

    @Nls
    @NotNull
    private static String getErrorDialogDescription() {
        return LocalChangesWouldBeOverwrittenHelper.getErrorDescription(false);
    }

    @Nls
    @NotNull
    private static String getErrorDescription(boolean forNotification) {
        String message = GitBundle.message("warning.your.local.changes.would.be.overwritten.by.merge", new Object[0]);
        if (forNotification) {
            return new HtmlBuilder().appendRaw(StringUtil.replace((String)message, (String)"\n", (String)"<br/>")).appendLink("view", GitBundle.message("link.label.local.changes.would.be.overwritten.by.merge.view.them", new Object[0])).toString();
        }
        return message;
    }

    @Deprecated(forRemoval=true)
    public static void showErrorNotification(@NotNull Project project, @NotNull VirtualFile root, @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, null, root, operationName, relativeFilePaths);
    }

    public static void showErrorNotification(final @NotNull Project project, @NonNls @Nullable String displayId, @NotNull VirtualFile root, final @NotNull String operationName, @NotNull Collection<String> relativeFilePaths) {
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativeFilePaths);
        final List<Change> changes = GitUtil.findLocalChangesForPaths(project, root, absolutePaths, false);
        String notificationTitle = GitBundle.message("notification.title.git.operation.failed", StringUtil.capitalize((String)operationName));
        VcsNotifier.getInstance((Project)project).notifyError(displayId, notificationTitle, LocalChangesWouldBeOverwrittenHelper.getErrorNotificationDescription(), (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
                LocalChangesWouldBeOverwrittenHelper.showErrorDialog(project, operationName, changes, absolutePaths);
            }
        });
    }

    private static void showErrorDialog(@NotNull Project project, @NotNull String operationName, @NotNull List<? extends Change> changes, @NotNull Collection<String> absolutePaths) {
        String title = GitBundle.message("dialog.title.local.changes.prevent.from.operation", StringUtil.capitalize((String)operationName));
        String description2 = LocalChangesWouldBeOverwrittenHelper.getErrorDialogDescription();
        if (changes.isEmpty()) {
            GitUtil.showPathsInDialog(project, absolutePaths, title, description2);
        } else {
            ChangesBrowserWithRollback changesViewer = new ChangesBrowserWithRollback(project, changes);
            DialogBuilder builder = new DialogBuilder(project);
            builder.setNorthPanel((JComponent)new MultiLineLabel(description2));
            builder.setCenterPanel((JComponent)((Object)changesViewer));
            builder.addDisposable((Disposable)changesViewer);
            builder.addOkAction();
            builder.setTitle(title);
            builder.show();
        }
    }
}

