/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GitSimplePathsBrowser
extends JPanel {
    public GitSimplePathsBrowser(@NotNull Project project, @NotNull Collection<String> absolutePaths) {
        super(new BorderLayout());
        ChangesTree browser = GitSimplePathsBrowser.createBrowser(project, absolutePaths);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("GitPathBrowser", (ActionGroup)group, true);
        TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(toolbar, browser);
        this.add((Component)toolbarPanel, "North");
        this.add(ScrollPaneFactory.createScrollPane((Component)browser));
    }

    @NotNull
    private static ChangesTree createBrowser(@NotNull Project project, @NotNull Collection<String> absolutePaths) {
        List<FilePath> filePaths = GitSimplePathsBrowser.toFilePaths(absolutePaths);
        return new ChangesTreeImpl.FilePaths(project, false, false, filePaths);
    }

    @NotNull
    private static List<FilePath> toFilePaths(@NotNull Collection<String> absolutePaths) {
        return ContainerUtil.map(absolutePaths, path -> VcsUtil.getFilePath((String)path, (boolean)false));
    }
}

