/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class GitRebaseOverMergeProblem {
    private static final Logger LOG = Logger.getInstance(GitRebaseOverMergeProblem.class);

    public static boolean hasProblem(@NotNull Project project, @NotNull VirtualFile root, @NotNull String baseRef, @NotNull String currentRef) {
        String range = baseRef + ".." + currentRef;
        try {
            List<GitCommit> commits2 = GitHistoryUtils.history(project, root, range, "--merges");
            return StreamEx.of(commits2).anyMatch(commit -> !commit.getChanges().isEmpty());
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get git log --merges " + range, (Throwable)e);
            return false;
        }
    }

    @NotNull
    public static Decision showDialog() {
        Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> decision.set((Object)GitRebaseOverMergeProblem.doShowDialog()));
        return (Decision)((Object)decision.get());
    }

    @NotNull
    private static Decision doShowDialog() {
        int decision = DialogManager.showMessage(GitBundle.message("dialog.message.rebasing.merge.commits", new Object[0]), GitBundle.message("dialog.title.rebasing.merge.commits", new Object[0]), Decision.getButtonTitles(), Decision.getDefaultButtonIndex(), Decision.getFocusedButtonIndex(), Messages.getWarningIcon(), null);
        return Decision.getOption(decision);
    }

    public static enum Decision {
        MERGE_INSTEAD("rebasing.merge.commits.button.merge"),
        REBASE_ANYWAY("rebasing.merge.commits.button.rebase"),
        CANCEL_OPERATION("rebasing.merge.commits.button.cancel");

        private final String myButtonTextKey;

        private Decision(String buttonTextKey) {
            this.myButtonTextKey = buttonTextKey;
        }

        private static @NlsContexts.Button String @NotNull [] getButtonTitles() {
            return (String[])ContainerUtil.map2Array((Object[])Decision.values(), String.class, decision -> GitBundle.message(decision.myButtonTextKey, new Object[0]));
        }

        @NotNull
        public static Decision getOption(int index) {
            return Objects.requireNonNull((Decision)((Object)ContainerUtil.find((Object[])Decision.values(), decision -> decision.ordinal() == index)));
        }

        private static int getDefaultButtonIndex() {
            return MERGE_INSTEAD.ordinal();
        }

        private static int getFocusedButtonIndex() {
            return REBASE_ANYWAY.ordinal();
        }
    }
}

