/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.project.Project;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchType;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import git4idea.ui.branch.dashboard.NodeDescriptorsModel;
import git4idea.ui.branch.dashboard.NodeType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00102\u001c\b\u0002\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000bJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\f\u001a\u00020\u0003J$\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J(\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bJ\u0014\u0010 \u001a\u00020\u001d*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u001d*\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R6\u0010\u0006\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/ui/branch/dashboard/NodeDescriptorsModel;", "", "localRootNodeDescriptor", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "remoteRootNodeDescriptor", "(Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;)V", "branchNodeDescriptors", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "addChild", "", "parent", "child", "applyGroupingByDirectory", "branch", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "applyGroupingByRepository", "curParent", "br", "additionalGrouping", "Lkotlin/Function2;", "clear", "getChildrenForParent", "", "populateFrom", "groupingConfig", "", "Lcom/intellij/dvcs/branch/GroupingKey;", "", "branches", "Lkotlin/sequences/Sequence;", "isCurrentBranch", "Lgit4idea/repo/GitRepository;", "branchName", "", "isFavorite", "intellij.vcs.git"})
public final class NodeDescriptorsModel {
    private final HashMap<BranchNodeDescriptor, Set<BranchNodeDescriptor>> branchNodeDescriptors;
    private final BranchNodeDescriptor localRootNodeDescriptor;
    private final BranchNodeDescriptor remoteRootNodeDescriptor;

    public final void clear() {
        this.branchNodeDescriptors.clear();
    }

    @NotNull
    public final Set<BranchNodeDescriptor> getChildrenForParent(@NotNull BranchNodeDescriptor parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Map map2 = this.branchNodeDescriptors;
        Set set = SetsKt.emptySet();
        return map2.getOrDefault(parent, set);
    }

    public final void populateFrom(@NotNull Sequence<BranchInfo> branches2, @NotNull Map<GroupingKey, Boolean> groupingConfig) {
        Intrinsics.checkNotNullParameter(branches2, (String)"branches");
        Intrinsics.checkNotNullParameter(groupingConfig, (String)"groupingConfig");
        Sequence<BranchInfo> $this$forEach$iv = branches2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BranchInfo branch = (BranchInfo)element$iv;
            boolean bl = false;
            this.populateFrom(branch, groupingConfig);
        }
    }

    private final void populateFrom(BranchInfo br, Map<GroupingKey, Boolean> groupingConfig) {
        BranchNodeDescriptor curParent = br.isLocal() ? this.localRootNodeDescriptor : this.remoteRootNodeDescriptor;
        Boolean bl = groupingConfig.get(GroupingKey.GROUPING_BY_DIRECTORY);
        Intrinsics.checkNotNull((Object)bl);
        boolean groupByDirectory = bl;
        Boolean bl2 = groupingConfig.get(GroupingKey.GROUPING_BY_REPOSITORY);
        Intrinsics.checkNotNull((Object)bl2);
        boolean groupByRepository = bl2;
        if (groupByRepository && groupByDirectory) {
            this.applyGroupingByRepository(curParent, br, (Function2<? super BranchInfo, ? super BranchNodeDescriptor, Unit>)((Function2)new Function2<BranchInfo, BranchNodeDescriptor, Unit>(this){
                final /* synthetic */ NodeDescriptorsModel this$0;

                public final void invoke(@NotNull BranchInfo branch, @NotNull BranchNodeDescriptor parent) {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    NodeDescriptorsModel.access$applyGroupingByDirectory(this.this$0, parent, branch);
                }
                {
                    this.this$0 = nodeDescriptorsModel;
                    super(2);
                }
            }));
        } else if (groupByRepository) {
            NodeDescriptorsModel.applyGroupingByRepository$default(this, curParent, br, null, 4, null);
        } else if (groupByDirectory) {
            this.applyGroupingByDirectory(curParent, BranchInfo.copy$default(br, null, false, false, false, null, null, 63, null));
        } else {
            this.addChild(curParent, new BranchNodeDescriptor(NodeType.BRANCH, BranchInfo.copy$default(br, null, false, false, false, null, null, 63, null), null, null, curParent, 12, null));
        }
    }

    private final void applyGroupingByRepository(BranchNodeDescriptor curParent, BranchInfo br, Function2<? super BranchInfo, ? super BranchNodeDescriptor, Unit> additionalGrouping) {
        HashMap repositoryNodeDescriptors = new HashMap();
        Iterable $this$forEach$iv = br.getRepositories();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GitRepository repository = (GitRepository)element$iv;
            boolean bl = false;
            BranchInfo branch = BranchInfo.copy$default(br, null, false, this.isCurrentBranch(repository, br.getBranchName()), this.isFavorite(repository, br), BranchesDashboardUtil.INSTANCE.getIncomingOutgoingState(repository, br.getBranchName()), null, 35, null);
            Object v = repositoryNodeDescriptors.computeIfAbsent(repository, new Function(repository, this, br, repositoryNodeDescriptors, curParent, additionalGrouping){
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ NodeDescriptorsModel this$0;
                final /* synthetic */ BranchInfo $br$inlined;
                final /* synthetic */ HashMap $repositoryNodeDescriptors$inlined;
                final /* synthetic */ BranchNodeDescriptor $curParent$inlined;
                final /* synthetic */ Function2 $additionalGrouping$inlined;
                {
                    this.$repository = gitRepository;
                    this.this$0 = nodeDescriptorsModel;
                    this.$br$inlined = branchInfo;
                    this.$repositoryNodeDescriptors$inlined = hashMap;
                    this.$curParent$inlined = branchNodeDescriptor;
                    this.$additionalGrouping$inlined = function2;
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final BranchNodeDescriptor apply(@NotNull GitRepository it) {
                    void var2_2;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BranchNodeDescriptor repositoryNodeDescriptor = new BranchNodeDescriptor(NodeType.GROUP_REPOSITORY_NODE, null, this.$repository, null, this.$curParent$inlined, 10, null);
                    NodeDescriptorsModel.access$addChild(this.this$0, this.$curParent$inlined, repositoryNodeDescriptor);
                    return var2_2;
                }
            });
            Intrinsics.checkNotNullExpressionValue(v, (String)"repositoryNodeDescriptor\u2026oryNodeDescriptor\n      }");
            BranchNodeDescriptor repositoryNodeDescriptor = (BranchNodeDescriptor)v;
            if (additionalGrouping != null) {
                additionalGrouping.invoke((Object)branch, (Object)repositoryNodeDescriptor);
                continue;
            }
            BranchNodeDescriptor branchNodeDescriptor = new BranchNodeDescriptor(NodeType.BRANCH, branch, null, null, repositoryNodeDescriptor, 12, null);
            this.addChild(repositoryNodeDescriptor, branchNodeDescriptor);
        }
    }

    static /* synthetic */ void applyGroupingByRepository$default(NodeDescriptorsModel nodeDescriptorsModel, BranchNodeDescriptor branchNodeDescriptor, BranchInfo branchInfo, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        nodeDescriptorsModel.applyGroupingByRepository(branchNodeDescriptor, branchInfo, (Function2<? super BranchInfo, ? super BranchNodeDescriptor, Unit>)function2);
    }

    private final void applyGroupingByDirectory(BranchNodeDescriptor parent, BranchInfo branch) {
        Iterator iter = StringsKt.split$default((CharSequence)branch.getBranchName(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null).iterator();
        BranchNodeDescriptor curParent = parent;
        while (iter.hasNext()) {
            String branchNamePart = (String)iter.next();
            boolean groupNode = iter.hasNext();
            NodeType nodeType = groupNode ? NodeType.GROUP_NODE : NodeType.BRANCH;
            BranchInfo branchInfo = nodeType == NodeType.BRANCH ? branch : null;
            BranchNodeDescriptor branchNodeDescriptor = new BranchNodeDescriptor(nodeType, branchInfo, null, branchNamePart, curParent, 4, null);
            this.addChild(curParent, branchNodeDescriptor);
            curParent = branchNodeDescriptor;
        }
    }

    private final void addChild(BranchNodeDescriptor parent, BranchNodeDescriptor child) {
        Set<BranchNodeDescriptor> set = this.branchNodeDescriptors.computeIfAbsent(parent, addChild.directChildren.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(set, (String)"branchNodeDescriptors.co\u2026H_TREE_NODE_COMPARATOR) }");
        Set<BranchNodeDescriptor> directChildren2 = set;
        directChildren2.add(child);
        ((Map)this.branchNodeDescriptors).put(parent, directChildren2);
    }

    private final boolean isCurrentBranch(GitRepository $this$isCurrentBranch, String branchName) {
        GitLocalBranch gitLocalBranch = $this$isCurrentBranch.getCurrentBranch();
        return Intrinsics.areEqual((Object)(gitLocalBranch != null ? gitLocalBranch.getName() : null), (Object)branchName);
    }

    private final boolean isFavorite(GitRepository $this$isFavorite, BranchInfo branch) {
        Project project = $this$isFavorite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        return ((GitBranchManager)((Object)$this$service$iv.getService(GitBranchManager.class))).isFavorite(branch.isLocal() ? GitBranchType.LOCAL : GitBranchType.REMOTE, $this$isFavorite, branch.getBranchName());
    }

    public NodeDescriptorsModel(@NotNull BranchNodeDescriptor localRootNodeDescriptor, @NotNull BranchNodeDescriptor remoteRootNodeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)localRootNodeDescriptor, (String)"localRootNodeDescriptor");
        Intrinsics.checkNotNullParameter((Object)remoteRootNodeDescriptor, (String)"remoteRootNodeDescriptor");
        this.localRootNodeDescriptor = localRootNodeDescriptor;
        this.remoteRootNodeDescriptor = remoteRootNodeDescriptor;
        this.branchNodeDescriptors = new HashMap();
    }

    public static final /* synthetic */ void access$applyGroupingByDirectory(NodeDescriptorsModel $this, BranchNodeDescriptor parent, BranchInfo branch) {
        $this.applyGroupingByDirectory(parent, branch);
    }

    public static final /* synthetic */ void access$addChild(NodeDescriptorsModel $this, BranchNodeDescriptor parent, BranchNodeDescriptor child) {
        $this.addChild(parent, child);
    }
}

