/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.UI;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.actions.TwoStepCompletionProvider;
import com.intellij.vcs.log.ui.actions.VcsRefCompletionProvider;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.GitTag;
import git4idea.branch.GitBranchUtil;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import it.unimi.dsi.fastutil.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRefDialog
extends DialogWrapper {
    private final TextFieldWithCompletion myTextField;
    private final JComponent myCenterPanel;

    public GitRefDialog(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Label String message) {
        super(project);
        this.setTitle(title);
        TextCompletionProvider completionProvider2 = GitRefDialog.getCompletionProvider(project, repositories, this.getDisposable());
        this.myTextField = new TextFieldWithCompletion(project, completionProvider2, "", true, true, false);
        this.myCenterPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JBLabel(message))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myTextField)).createPanel();
        this.init();
    }

    @NotNull
    private static TextCompletionProvider getCompletionProvider(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull Disposable disposable) {
        VcsLogManager logManager = VcsProjectLog.getInstance((Project)project).getLogManager();
        if (logManager != null) {
            List roots = ContainerUtil.map(repositories, Repository::getRoot);
            DataPack dataPack = logManager.getDataManager().getDataPack();
            if (dataPack != DataPack.EMPTY) {
                VcsGoToRefComparator comparator = new VcsGoToRefComparator(dataPack.getLogProviders());
                return new MyVcsRefCompletionProvider((VcsLogRefs)dataPack.getRefsModel(), roots, (Comparator<? super VcsRef>)comparator);
            }
        }
        List branches2 = ContainerUtil.concat(GitBranchUtil.getCommonLocalBranches(repositories), GitBranchUtil.getCommonRemoteBranches(repositories));
        FutureResult<Collection<GitTag>> tagsFuture = GitRefDialog.scheduleCollectCommonTags(repositories, disposable);
        return new MySimpleCompletionListProvider(branches2, tagsFuture);
    }

    private static FutureResult<Collection<GitTag>> scheduleCollectCommonTags(@NotNull List<GitRepository> repositories, @NotNull Disposable disposable) {
        FutureResult futureResult = new FutureResult();
        ApplicationManager.getApplication().executeOnPooledThread(() -> futureResult.set((Object)((Collection)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)disposable, () -> GitBranchUtil.collectCommon(repositories.stream().map(repository -> {
            try {
                List<String> tags = GitBranchUtil.getAllTags(repository.getProject(), repository.getRoot());
                return ContainerUtil.map(tags, GitTag::new);
            }
            catch (VcsException e) {
                return Collections.emptyList();
            }
        }))))));
        return futureResult;
    }

    @NotNull
    public String getReference() {
        return StringUtil.trim((String)this.myTextField.getText(), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextField;
    }

    @NotNull
    private static Collection<VcsRef> collectCommonVcsRefs(@NotNull Stream<? extends VcsRef> stream) {
        MultiMap map2 = MultiMap.create();
        stream.forEach(ref -> map2.putValue((Object)ref.getRoot(), ref));
        Stream<Collection> groups = map2.entrySet().stream().map(Map.Entry::getValue);
        return GitBranchUtil.collectCommon(groups, new NameAndTypeHashingStrategy());
    }

    private static final class GitReferenceDescriptor
    extends DefaultTextCompletionValueDescriptor<GitReference> {
        private GitReferenceDescriptor() {
        }

        @NotNull
        public String getLookupString(@NotNull GitReference item) {
            return item.getName();
        }

        public int compare(GitReference item1, GitReference item2) {
            return item1.compareTo(item2);
        }
    }

    private static final class NameAndTypeHashingStrategy
    implements Hash.Strategy<VcsRef> {
        private NameAndTypeHashingStrategy() {
        }

        public int hashCode(VcsRef object) {
            return object == null ? 0 : Comparing.hashcode((Object)object.getName(), (Object)object.getType());
        }

        public boolean equals(VcsRef o1, VcsRef o2) {
            return o1 == o2 || o1 != null && o2 != null && Objects.equals(o1.getName(), o2.getName()) && Objects.equals(o1.getType(), o2.getType());
        }
    }

    private static final class VcsRefDescriptor
    extends DefaultTextCompletionValueDescriptor<VcsRef> {
        @NotNull
        private final Comparator<? super VcsRef> myReferenceComparator;

        private VcsRefDescriptor(@NotNull Comparator<? super VcsRef> comparator) {
            this.myReferenceComparator = comparator;
        }

        @NotNull
        public String getLookupString(@NotNull VcsRef item) {
            return item.getName();
        }

        public int compare(VcsRef item1, VcsRef item2) {
            return this.myReferenceComparator.compare((VcsRef)item1, (VcsRef)item2);
        }
    }

    private static final class MySimpleCompletionListProvider
    extends TwoStepCompletionProvider<GitReference> {
        @NotNull
        private final List<? extends GitBranch> myBranches;
        @NotNull
        private final FutureResult<? extends Collection<GitTag>> myTagsFuture;

        MySimpleCompletionListProvider(@NotNull List<? extends GitBranch> branches2, @NotNull FutureResult<? extends Collection<GitTag>> tagsFuture) {
            super((TextCompletionValueDescriptor)new GitReferenceDescriptor());
            this.myBranches = branches2;
            this.myTagsFuture = tagsFuture;
        }

        @NotNull
        protected Stream<? extends GitReference> collectSync(@NotNull CompletionResultSet result2) {
            return this.myBranches.stream().filter(branch -> result2.getPrefixMatcher().prefixMatches(branch.getName()));
        }

        @NotNull
        protected Stream<? extends GitReference> collectAsync(@NotNull CompletionResultSet result2) {
            try {
                return ((Collection)this.myTagsFuture.get()).stream().filter(tag -> result2.getPrefixMatcher().prefixMatches(tag.getName()));
            }
            catch (InterruptedException | ExecutionException e) {
                return Stream.empty();
            }
        }
    }

    private static final class MyVcsRefCompletionProvider
    extends VcsRefCompletionProvider {
        MyVcsRefCompletionProvider(@NotNull VcsLogRefs refs, @NotNull Collection<? extends VirtualFile> roots, @NotNull Comparator<? super VcsRef> comparator) {
            super(refs, roots, (TextCompletionValueDescriptor)new VcsRefDescriptor(comparator));
        }

        @NotNull
        protected Stream<VcsRef> filterRefs(@NotNull Stream<VcsRef> vcsRefs) {
            Stream<VcsRef> branches2 = vcsRefs.filter(ref -> {
                VcsRefType type = ref.getType();
                return type == GitRefManager.LOCAL_BRANCH || type == GitRefManager.REMOTE_BRANCH || type == GitRefManager.TAG;
            });
            return GitRefDialog.collectCommonVcsRefs(branches2).stream();
        }
    }
}

