/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsCompareSettings;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import org.jetbrains.annotations.NotNull;

public class GitCompareBranchesHelper
implements CompareBranchesHelper {
    private final Project myProject;

    public GitCompareBranchesHelper(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public RepositoryManager getRepositoryManager() {
        return GitUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public DvcsCompareSettings getDvcsCompareSettings() {
        return GitVcsSettings.getInstance(this.myProject);
    }

    @NotNull
    public String formatLogCommand(@NotNull String firstBranch, @NotNull String secondBranch) {
        return String.format("git log %s..%s", firstBranch, secondBranch);
    }
}

