/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.ide.DataManager;
import com.intellij.ide.navigationToolbar.experimental.ExperimentalToolbarStateListener;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.GitBranchesUsageCollector;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.BranchIconUtil;
import git4idea.ui.branch.GitBranchPopup;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    @NonNls
    private static final String ID = "git";
    private final GitVcsSettings mySettings;

    public GitBranchWidget(@NotNull Project project) {
        super(project, GitVcs.DISPLAY_NAME.get());
        this.mySettings = GitVcsSettings.getInstance(project);
        project.getMessageBus().connect((Disposable)this).subscribe(GitRepository.GIT_REPO_CHANGE, r -> this.updateLater());
        project.getMessageBus().connect((Disposable)this).subscribe(GitBranchIncomingOutgoingManager.GIT_INCOMING_OUTGOING_CHANGED, () -> ((GitBranchWidget)this).updateLater());
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget(this.getProject());
    }

    @Nullable
    @RequiresEdt
    protected GitRepository guessCurrentRepository(@NotNull Project project) {
        return (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (String)this.mySettings.getRecentRootPath());
    }

    @Nullable
    protected Icon getIcon(@NotNull GitRepository repository) {
        return BranchIconUtil.Companion.getBranchIcon(repository);
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository) {
        return GitBranchUtil.getDisplayableBranchText(repository);
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull GitRepository repository) {
        GitBranchesUsageCollector.branchWidgetClicked();
        return GitBranchPopup.getInstance(project, repository, DataManager.getInstance().getDataContext((Component)this.myStatusBar.getComponent())).asListPopup();
    }

    protected void rememberRecentRoot(@NotNull String path) {
        this.mySettings.setRecentRoot(path);
    }

    @NlsContexts.Tooltip
    @Nullable
    protected String getToolTip(@Nullable GitRepository repository) {
        if (repository != null && repository.getState() == Repository.State.DETACHED) {
            return GitBundle.message("git.status.bar.widget.tooltip.detached", new Object[0]);
        }
        return super.getToolTip((Repository)repository);
    }

    public static class MyExperimentalToolbarStateListener
    implements ExperimentalToolbarStateListener {
        private final Project myProject;

        public MyExperimentalToolbarStateListener(Project project) {
            this.myProject = project;
        }

        public void refreshVisibility() {
            ((StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }
    }

    public static class Factory
    implements StatusBarWidgetFactory {
        @NotNull
        public String getId() {
            return GitBranchWidget.ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            return GitBundle.message("git.status.bar.widget.name", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project) {
            return (this.isEnabledByDefault() || ExperimentalUI.isNewUI()) && !GitRepositoryManager.getInstance(project).getRepositories().isEmpty();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            return new GitBranchWidget(project);
        }

        public boolean isEnabledByDefault() {
            return !ExperimentalUI.isNewUI() && (!ToolbarSettings.getInstance().isVisible() || !ToolbarSettings.getInstance().isEnabled());
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            return true;
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            this.myProject = project;
        }

        public void mappingChanged() {
            ((StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }
    }
}

