/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.CustomIconProvider;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.ui.EmptyIcon;
import git4idea.GitLocalBranch;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.GitOngoingOperationAction;
import git4idea.actions.branch.GitBranchActionsUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchOperationType;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitCheckoutAndRebaseRemoteBranchWorkflow;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.ui.branch.GitRefDialog;
import git4idea.update.GitUpdateExecutionProcess;
import icons.DvcsImplIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchPopupActions {
    private static final int MAX_BRANCH_NAME_LENGTH = 40;
    private static final int BRANCH_NAME_LENGHT_DELTA = 4;
    private static final int BRANCH_NAME_SUFFIX_LENGTH = 5;
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, null, false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @Nullable GitRepository specificRepository, boolean firstLevelGroup) {
        LightActionGroup topActions = new LightActionGroup(false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        GitRebaseSpec rebaseSpec = GitRepositoryManager.getInstance(this.myProject).getOngoingRebaseSpec();
        if (rebaseSpec != null && GitBranchPopupActions.isSpecForRepo(rebaseSpec, this.myRepository)) {
            topActions.addAll(GitBranchPopupActions.getRebaseActions());
        } else {
            topActions.addAll(GitBranchPopupActions.createPerRepoRebaseActions(this.myRepository));
        }
        if (ExperimentalUI.isNewUI()) {
            ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Git.Experimental.Branch.Popup.Actions");
            topActions.addAll(actionGroup);
            topActions.addSeparator();
        }
        topActions.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        if (!ExperimentalUI.isNewUI()) {
            topActions.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        }
        if (toInsert != null) {
            topActions.addAll((ActionGroup)toInsert);
        }
        LightActionGroup popupGroup = new LightActionGroup(true);
        for (AnAction action : topActions.getChildren(null)) {
            boolean isSeparatorOrGroup = action instanceof Separator || action instanceof ActionGroup;
            popupGroup.addAction((AnAction)(isSeparatorOrGroup ? action : new MyDelegateWithShortcutText(action)));
        }
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.local.branches", new Object[0]) : GitBundle.message("branches.local.branches.in.repo", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        GitBranchesCollection branchesCollection = this.myRepository.getBranches();
        List localBranchActions = ((StreamEx)((StreamEx)StreamEx.of(branchesCollection.getLocalBranches()).filter(branch -> !branch.equals(currentBranch))).map(branch -> new LocalBranchActions(this.myProject, repositoryList, branch.getName(), this.myRepository)).sorted((b1, b2) -> {
            int delta = BranchActionUtil.FAVORITE_BRANCH_COMPARATOR.compare(b1, b2);
            if (delta != 0) {
                return delta;
            }
            return StringUtil.naturalCompare((String)b1.myBranchName, (String)b2.myBranchName);
        })).toList();
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches((List)localBranchActions);
        if (currentBranch != null) {
            localBranchActions.add(0, new CurrentBranchActions(this.myProject, repositoryList, currentBranch.getName(), this.myRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)localBranchActions, (int)topShownBranches, (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.remote.branches", new Object[0]) : GitBundle.message("branches.remote.branches.in.repo", specificRepository));
        List remoteBranchActions = ((StreamEx)StreamEx.of(branchesCollection.getRemoteBranches()).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(remoteName -> new RemoteBranchActions(this.myProject, (List<? extends GitRepository>)repositoryList, (String)remoteName, this.myRepository)).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static boolean isSpecForRepo(@NotNull GitRebaseSpec spec, @NotNull GitRepository repository) {
        Collection<GitRepository> repositoriesFromSpec = spec.getAllRepositories();
        return repositoriesFromSpec.size() == 1 && repository.equals(ContainerUtil.getFirstItem(repositoriesFromSpec));
    }

    @NotNull
    private static List<AnAction> createPerRepoRebaseActions(@NotNull GitRepository repository) {
        return ContainerUtil.mapNotNull(GitBranchPopupActions.getRebaseActions(), action -> GitBranchPopupActions.createRepositoryRebaseAction(action, repository));
    }

    @NotNull
    static List<AnAction> getRebaseActions() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Git.Ongoing.Rebase.Actions");
        return Arrays.asList(group.getChildren(null));
    }

    @Nullable
    private static AnAction createRepositoryRebaseAction(@NotNull AnAction rebaseAction, final @NotNull GitRepository repository) {
        if (!(rebaseAction instanceof GitOngoingOperationAction)) {
            return null;
        }
        final GitOngoingOperationAction ongoingAction = (GitOngoingOperationAction)rebaseAction;
        DumbAwareAction repositoryAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(ongoingAction.isEnabled(repository));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ongoingAction.performInBackground(repository);
            }
        };
        repositoryAction.getTemplatePresentation().copyFrom(rebaseAction.getTemplatePresentation());
        return repositoryAction;
    }

    @NlsSafe
    @NotNull
    public static String getCurrentBranchFullPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        return GitBranchPopupActions.getCurrentBranchPresentation(project, repositories, false);
    }

    @NlsSafe
    @NotNull
    public static String getCurrentBranchTruncatedPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        return GitBranchPopupActions.getCurrentBranchPresentation(project, repositories, true);
    }

    @Nls
    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, boolean truncateBranchName) {
        Set currentBranches = ContainerUtil.map2SetNotNull(repositories, repo -> repo.isFresh() ? repo.getCurrentBranchName() : (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)Objects.requireNonNull(repo.getCurrentRevision()))));
        if (currentBranches.size() == 1) {
            String fullBranchName = (String)currentBranches.iterator().next();
            return truncateBranchName ? GitBranchPopupActions.getCurrentBranchTruncatedName(fullBranchName, project) : GitBranchPopupActions.wrapWithQuotes(fullBranchName);
        }
        return GitBundle.message("branches.current.branch", new Object[0]);
    }

    @NlsSafe
    @NotNull
    public static String getSelectedBranchFullPresentation(@NlsSafe @NotNull String branchName) {
        return GitBranchPopupActions.wrapWithQuotes(branchName);
    }

    @NlsSafe
    @NotNull
    private static String getCurrentBranchTruncatedName(@NlsSafe @NotNull String branchName, @NotNull Project project) {
        return GitBranchPopupActions.showFullBranchNamesInsteadOfCurrentSelected() ? GitBranchPopupActions.wrapWithQuotes(StringUtil.escapeMnemonics((String)GitBranchPopupActions.truncateBranchName(branchName, project))) : GitBundle.message("branches.current.branch.name", new Object[0]);
    }

    @NlsSafe
    @NotNull
    public static String getSelectedBranchTruncatedPresentation(@NotNull Project project, @NlsSafe @NotNull String branchName) {
        return GitBranchPopupActions.showFullBranchNamesInsteadOfCurrentSelected() ? GitBranchPopupActions.wrapWithQuotes(StringUtil.escapeMnemonics((String)GitBranchPopupActions.truncateBranchName(branchName, project))) : GitBundle.message("branches.selected.branch.name", new Object[0]);
    }

    private static boolean showFullBranchNamesInsteadOfCurrentSelected() {
        return Registry.is((String)"git.show.full.branch.name.instead.current.selected");
    }

    @NlsSafe
    @NotNull
    static String truncateBranchName(@NotNull @NlsSafe String branchName, @NotNull Project project) {
        int branchNameLength = branchName.length();
        if (branchNameLength <= 44) {
            return branchName;
        }
        IssueNavigationConfiguration issueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
        List issueMatches = issueNavigationConfiguration.findIssueLinks((CharSequence)branchName);
        if (issueMatches.size() != 0) {
            IssueNavigationConfiguration.LinkMatch firstMatch = (IssueNavigationConfiguration.LinkMatch)issueMatches.get(0);
            TextRange firstMatchRange = firstMatch.getRange();
            return GitBranchPopupActions.truncateAndSaveIssueId(firstMatchRange, branchName, 40, 5, 4);
        }
        return StringUtil.shortenTextWithEllipsis((String)branchName, (int)40, (int)5, (boolean)true);
    }

    @NlsSafe
    @NotNull
    static String truncateAndSaveIssueId(@NotNull TextRange issueIdRange, @NotNull String branchName, int maxBranchNameLength, int suffixLength, int delta) {
        String issueId;
        String truncatedByDefault = StringUtil.shortenTextWithEllipsis((String)branchName, (int)maxBranchNameLength, (int)suffixLength, (boolean)true);
        if (truncatedByDefault.contains(issueId = issueIdRange.substring(branchName))) {
            return truncatedByDefault;
        }
        try {
            Object prefixAndIssue;
            int branchNameLength = branchName.length();
            int endOffset = issueIdRange.getEndOffset();
            int startOffset = issueIdRange.getStartOffset();
            if (endOffset >= branchNameLength - suffixLength - delta) {
                return StringUtil.shortenTextWithEllipsis((String)branchName, (int)maxBranchNameLength, (int)(branchNameLength - startOffset), (boolean)true);
            }
            String suffix = branchName.substring(branchNameLength - suffixLength);
            int prefixLength = maxBranchNameLength - suffixLength - issueId.length();
            if (Math.abs(startOffset - prefixLength) <= delta) {
                prefixAndIssue = branchName.substring(0, endOffset);
            } else {
                String prefix = branchName.substring(0, prefixLength);
                prefixAndIssue = prefix + "\u2026" + issueId;
            }
            return (String)prefixAndIssue + "\u2026" + suffix;
        }
        catch (Throwable e) {
            return truncatedByDefault;
        }
    }

    @NlsSafe
    @NotNull
    private static String wrapWithQuotes(@NlsSafe @NotNull String branchName) {
        return "'" + branchName + "'";
    }

    public static void addTooltipText(Presentation presentation, @NlsContexts.Tooltip String tooltipText) {
        presentation.putClientProperty("ToolTipText", (Object)tooltipText);
    }

    private static class MyDelegateWithShortcutText
    extends AnActionWrapper
    implements PopupElementWithAdditionalInfo {
        private MyDelegateWithShortcutText(@NotNull AnAction action) {
            super(action);
        }

        @Nls
        @Nullable
        public String getInfoText() {
            return KeymapUtil.getPreferredShortcutText((Shortcut[])this.getDelegate().getShortcutSet().getShortcuts());
        }
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myTagName;

        TagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String tagName) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myTagName = tagName;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new MergeAction(this.myProject, this.myRepositories, this.myTagName, false), new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<? extends GitRepository> repositories, String tagName) {
                super(IdeBundle.messagePointer((String)"button.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myTagName = tagName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
            }
        }
    }

    private static class UpdateSelectedBranchAction
    extends DumbAwareAction
    implements CustomIconProvider {
        protected final Project myProject;
        protected final List<? extends GitRepository> myRepositories;
        protected final String myBranchName;
        protected final List<String> myBranchNameList;
        protected final boolean myHasIncoming;

        UpdateSelectedBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean hasIncoming) {
            super(GitBundle.messagePointer("branches.update", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myBranchNameList = Collections.singletonList(branchName);
            this.myHasIncoming = hasIncoming;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            if (!GitBranchActionsUtilKt.hasRemotes(this.myProject)) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            String branchPresentation = GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName);
            String description2 = GitBundle.message("action.Git.Update.Selected.description", this.myBranchNameList.size(), GitVcsSettings.getInstance(this.myProject).getUpdateMethod().getMethodName().toLowerCase(Locale.ROOT));
            presentation.setDescription(description2);
            if (GitFetchSupport.fetchSupport(this.myProject).isFetchRunning()) {
                presentation.setEnabled(false);
                presentation.setDescription(GitBundle.message("branches.update.is.already.running", new Object[0]));
                return;
            }
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(this.myBranchNameList, this.myRepositories);
            presentation.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                presentation.setDescription(GitBundle.message("branches.tracking.branch.doesn.t.configured.for.s", branchPresentation));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBranchActionsUtilKt.updateBranches(this.myProject, this.myRepositories, this.myBranchNameList);
        }

        @Nullable
        public Icon getRightIcon() {
            return this.myHasIncoming ? DvcsImplIcons.Incoming : null;
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        RebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.rebase.current.onto.selected", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isOnBranch = ContainerUtil.and(this.myRepositories, GitRepository::isOnBranch);
            String description2 = isOnBranch ? GitBundle.message("branches.rebase.onto", GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories), GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName)) : GitBundle.message("branches.rebase.is.not.possible.in.the.detached.head.state", new Object[0]);
            Presentation presentation = e.getPresentation();
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            presentation.setEnabled(isOnBranch);
            String actionText = GitBundle.message("branches.rebase.onto", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories), GitBranchPopupActions.getSelectedBranchTruncatedPresentation(this.myProject, this.myBranchName));
            presentation.setText(actionText);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        MergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            super(GitBundle.messagePointer("branches.merge.into.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            String description2 = GitBundle.message("branches.merge.into", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories));
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            String name = GitBundle.message("branches.merge.into", GitBranchPopupActions.getSelectedBranchTruncatedPresentation(this.myProject, this.myBranchName), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(name);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }
    }

    private static class ShowDiffWithBranchAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        ShowDiffWithBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.show.diff.with.working.tree", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher.getInstance(this.myProject).showDiffWithLocal(this.myBranchName, this.myRepositories);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(!new GitMultiRootBranchConfig(this.myRepositories).diverged());
            String description2 = GitBundle.message("branches.compare.the.current.working.tree.with", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName));
            e.getPresentation().setDescription(description2);
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.show.diff", new Object[0]));
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CompareAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.compare.with.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories);
        }

        public void update(@NotNull AnActionEvent e) {
            String description2 = GitBundle.message("branches.show.commits.in", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories));
            Presentation presentation = e.getPresentation();
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            String text = GitBundle.message("branches.compare.with.branch", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(text);
        }
    }

    private static abstract class CheckoutWithRebaseActionBase
    extends DumbAwareAction {
        protected final Project myProject;
        protected final List<? extends GitRepository> myRepositories;
        protected final String myBranchName;

        CheckoutWithRebaseActionBase(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.checkout.and.rebase.onto.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            String description2 = GitBundle.message("branches.checkout.and.rebase.onto.in.one.step", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories), this.myBranchName);
            Presentation presentation = e.getPresentation();
            presentation.setDescription(description2);
            GitBranchPopupActions.addTooltipText(presentation, description2);
            String text = GitBundle.message("branches.checkout.and.rebase.onto.branch", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(text);
        }
    }

    private static class CheckoutAsNewBranch
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myIsRemote;

        CheckoutAsNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean isRemote) {
            super(GitBundle.messagePointer("branches.new.branch.from.branch", GitBranchPopupActions.getSelectedBranchTruncatedPresentation(project, branchName)));
            Supplier<@Nls String> description2 = GitBundle.messagePointer("branches.new.branch.from.branch.description", GitBranchPopupActions.getSelectedBranchFullPresentation(branchName));
            this.getTemplatePresentation().setDescription(description2);
            GitBranchPopupActions.addTooltipText(this.getTemplatePresentation(), description2.get());
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myIsRemote = isRemote;
        }

        public void update(@NotNull AnActionEvent e) {
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)DvcsBundle.message((String)"action.not.possible.in.fresh.repo.new.branch", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, this.myBranchName + "^0", GitBundle.message("action.Git.New.Branch.dialog.title", this.myBranchName), GitBranchActionsUtil.calculateNewBranchInitialName(this.myBranchName, this.myIsRemote));
        }
    }

    public static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        @NlsSafe
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)project.getService(GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName, true), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new PullWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new PullWithMergeAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(!GitProtectedBranchesKt.isRemoteBranchProtected(this.myRepositories, this.myBranchName));
            }
        }

        private static class PullWithRebaseAction
        extends PullBranchBaseAction {
            PullWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(project, repositories, branchName, UpdateMethod.REBASE);
                Presentation presentation = this.getTemplatePresentation();
                Supplier<@Nls String> text = GitBundle.messagePointer("branches.action.pull.into.branch.using.rebase", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, repositories));
                presentation.setText(text);
                Supplier<@Nls String> description2 = GitBundle.messagePointer("branches.action.pull.into.branch.using.rebase.description", GitBranchPopupActions.getCurrentBranchFullPresentation(project, repositories));
                presentation.setDescription(description2);
                GitBranchPopupActions.addTooltipText(presentation, description2.get());
            }
        }

        private static class PullWithMergeAction
        extends PullBranchBaseAction {
            PullWithMergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(project, repositories, branchName, UpdateMethod.MERGE);
                Presentation presentation = this.getTemplatePresentation();
                Supplier<@Nls String> text = GitBundle.messagePointer("branches.action.pull.into.branch.using.merge", GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, repositories));
                presentation.setText(text);
                Supplier<@Nls String> description2 = GitBundle.messagePointer("branches.action.pull.into.branch.using.merge.description", GitBranchPopupActions.getCurrentBranchFullPresentation(project, repositories));
                presentation.setDescription(description2);
                GitBranchPopupActions.addTooltipText(presentation, description2.get());
            }
        }

        private static class PullBranchBaseAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;
            private final UpdateMethod myUpdateMethod;

            PullBranchBaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName, UpdateMethod updateMethod) {
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
                this.myUpdateMethod = updateMethod;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                new GitUpdateExecutionProcess(this.myProject, this.myRepositories, PullBranchBaseAction.configureTarget(this.myRepositories, this.myRemoteBranchName), this.myUpdateMethod, false).execute();
            }

            private static Map<GitRepository, GitBranchPair> configureTarget(List<? extends GitRepository> repositories, String branchName) {
                LinkedHashMap map2 = new LinkedHashMap();
                for (GitRepository gitRepository : repositories) {
                    GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
                    GitRemoteBranch remoteBranch = gitRepository.getBranches().findRemoteBranch(branchName);
                    if (currentBranch == null || remoteBranch == null) continue;
                    map2.put(gitRepository, new GitBranchPair(currentBranch, remoteBranch));
                }
                return map2;
            }
        }

        private static class CheckoutWithRebaseAction
        extends CheckoutWithRebaseActionBase {
            CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(project, repositories, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitRepository repository = (GitRepository)this.myRepositories.get(0);
                GitRemoteBranch remoteBranch = Objects.requireNonNull(repository.getBranches().findRemoteBranch(this.myBranchName));
                String suggestedLocalName = remoteBranch.getNameForRemoteOperations();
                GitNewBranchOptions newBranchOptions = new GitNewBranchOptions(suggestedLocalName, false, true);
                if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)this.myBranchName, (Object)suggestedLocalName) && (newBranchOptions = this.askBranchName(suggestedLocalName)) == null) {
                    return;
                }
                String localName = newBranchOptions.getName();
                Map conflictingLocalBranches2 = ContainerUtil.map2MapNotNull((Collection)this.myRepositories, r -> {
                    GitLocalBranch local = r.getBranches().findLocalBranch(localName);
                    return local != null ? Pair.create((Object)r, (Object)local) : null;
                });
                if (GitBranchActionsUtilKt.hasTrackingConflicts(conflictingLocalBranches2, this.myBranchName) && (newBranchOptions = this.askBranchName(localName)) == null) {
                    return;
                }
                GitCheckoutAndRebaseRemoteBranchWorkflow workflow = new GitCheckoutAndRebaseRemoteBranchWorkflow(this.myProject, this.myRepositories);
                workflow.execute(remoteBranch.getNameForLocalOperations(), newBranchOptions);
            }

            @Nullable
            private GitNewBranchOptions askBranchName(@NotNull String suggestedLocalName) {
                return new GitNewBranchDialog(this.myProject, this.myRepositories, GitBundle.message("branches.checkout.s", this.myBranchName), suggestedLocalName, false, true).showAndGetOptions();
            }
        }

        public static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;

            CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CheckoutRemoteBranchAction.checkoutRemoteBranch(this.myProject, this.myRepositories, this.myRemoteBranchName);
            }

            public static void checkoutRemoteBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                GitRepository repository = repositories.get(0);
                GitRemoteBranch remoteBranch = Objects.requireNonNull(repository.getBranches().findRemoteBranch(remoteBranchName));
                String suggestedLocalName = remoteBranch.getNameForRemoteOperations();
                if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)suggestedLocalName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories, remoteBranchName, suggestedLocalName);
                    return;
                }
                Map conflictingLocalBranches2 = ContainerUtil.map2MapNotNull(repositories, r -> {
                    GitLocalBranch local = r.getBranches().findLocalBranch(suggestedLocalName);
                    return local != null ? Pair.create((Object)r, (Object)local) : null;
                });
                if (GitBranchActionsUtilKt.hasTrackingConflicts(conflictingLocalBranches2, remoteBranchName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories, remoteBranchName, suggestedLocalName);
                    return;
                }
                new GitBranchCheckoutOperation(project, repositories).perform(remoteBranchName, new GitNewBranchOptions(suggestedLocalName, true, true));
            }

            private static void askNewBranchNameAndCheckout(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName, @NotNull String suggestedLocalName) {
                GitNewBranchOptions options = new GitNewBranchDialog(project, repositories, GitBundle.message("branches.checkout.s", remoteBranchName), suggestedLocalName, false, true).showAndGetOptions();
                if (options == null) {
                    return;
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkoutNewBranchStartingFrom(options.getName(), remoteBranchName, options.shouldReset(), repositories, null);
            }
        }
    }

    public static class CurrentBranchActions
    extends LocalBranchActions {
        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            super(project, repositories, branchName, selectedRepository);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new LocalBranchActions.PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new LocalBranchActions.RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName)};
        }
    }

    public static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        @NlsSafe
        protected final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = ContainerUtil.immutableList(repositories);
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)project.getService(GitBranchManager.class));
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.myBranchName, false);
            GitBranchPopupActions.addTooltipText(this.getTemplatePresentation(), LocalBranchActions.constructIncomingOutgoingTooltip(this.hasIncomingCommits(), this.hasOutgoingCommits()));
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        List<GitRepository> getRepositories() {
            return this.myRepositories;
        }

        @NotNull
        public String getBranchName() {
            return this.myBranchName;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName, false), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public static String constructIncomingOutgoingTooltip(boolean incoming, boolean outgoing) {
            if (!incoming && !outgoing) {
                return null;
            }
            if (incoming && outgoing) {
                return GitBundle.message("branches.there.are.incoming.and.outgoing.commits", new Object[0]);
            }
            if (incoming) {
                return GitBundle.message("branches.there.are.incoming.commits", new Object[0]);
            }
            return GitBundle.message("branches.there.are.outgoing.commits", new Object[0]);
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<? extends GitRepository> repositories, String branchName) {
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher.getInstance(this.myProject).deleteBranch(this.myBranchName, ContainerUtil.filter(this.myRepositories, repository -> !this.myBranchName.equals(repository.getCurrentBranchName())));
            }
        }

        public static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<? extends GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            RenameBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
                super(ActionsBundle.messagePointer((String)"action.RenameAction.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                RenameBranchAction.rename(this.myProject, this.myRepositories, this.myCurrentBranchName);
            }

            public void update(@NotNull AnActionEvent e) {
                DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.rename.branch", new Object[0]));
            }

            public static void rename(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
                GitNewBranchOptions options = new GitNewBranchDialog(project, repositories, GitBundle.message("branches.rename.branch", currentBranchName), currentBranchName, false, false, false, false, GitBranchOperationType.RENAME).showAndGetOptions();
                if (options != null) {
                    GitBrancher brancher = GitBrancher.getInstance(project);
                    brancher.renameBranch(currentBranchName, options.getName(), repositories);
                }
            }
        }

        private static class PushBranchAction
        extends DumbAwareAction
        implements CustomIconProvider {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;
            private final boolean myHasCommitsToPush;

            PushBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean hasCommitsToPush) {
                super(ActionsBundle.messagePointer((String)"action.Vcs.Push.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
                this.myHasCommitsToPush = hasCommitsToPush;
            }

            public void update(@NotNull AnActionEvent e) {
                DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.push", new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitLocalBranch localBranch = this.myRepositories.get(0).getBranches().findLocalBranch(this.myBranchName);
                assert (localBranch != null);
                new VcsPushDialog(this.myProject, this.myRepositories, this.myRepositories, null, (PushSource)GitPushSource.create(localBranch)).show();
            }

            @Nullable
            public Icon getRightIcon() {
                return this.myHasCommitsToPush ? DvcsImplIcons.Outgoing : null;
            }
        }

        private static class CheckoutWithRebaseAction
        extends CheckoutWithRebaseActionBase {
            CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(project, repositories, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
            }
        }

        public static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            public CheckoutAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CheckoutAction.checkoutBranch(this.myProject, this.myRepositories, this.myBranchName);
            }

            public static void checkoutBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkout(branchName, false, repositories, null);
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super(GitBundle.messagePointer("branches.checkout.tag.or.revision", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitRefDialog dialog2 = new GitRefDialog(this.myProject, this.myRepositories, GitBundle.message("branches.checkout", new Object[0]), GitBundle.message("branches.enter.reference.branch.tag.name.or.commit.hash", new Object[0]));
            if (dialog2.showAndGet()) {
                String reference = dialog2.getReference();
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)GitBundle.message("action.not.possible.in.fresh.repo.checkout", new Object[0]));
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            super(project, repositories);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, "HEAD", GitBundle.message("branches.create.new.branch.dialog.title", new Object[0]), MultiRootBranches.getCommonCurrentBranch((Collection)this.myRepositories));
        }
    }
}

