/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsShelveChangesSaver;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVersionSpecialty;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GitShelveChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitShelveChangesSaver.class);
    private final VcsShelveChangesSaver myVcsShelveChangesSaver;

    public GitShelveChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull @Nls String stashMessage) {
        super(project, git, indicator, GitSaveChangesPolicy.SHELVE, stashMessage);
        this.myVcsShelveChangesSaver = new VcsShelveChangesSaver(project, indicator, stashMessage){

            protected void doRollback(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<Change> shelvedChanges) {
                GitShelveChangesSaver.this.rollbackChanges(rootsToSave, shelvedChanges);
            }
        };
    }

    @Override
    protected void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        this.myVcsShelveChangesSaver.save(rootsToSave);
    }

    @Override
    public void load() {
        this.myVcsShelveChangesSaver.load();
    }

    @Override
    public boolean wereChangesSaved() {
        List shelvedLists = this.myVcsShelveChangesSaver.getShelvedLists();
        return !shelvedLists.isEmpty();
    }

    @Override
    public void showSavedChanges() {
        List shelvedLists = this.myVcsShelveChangesSaver.getShelvedLists();
        if (!shelvedLists.isEmpty()) {
            Comparator<ShelvedChangeList> nameComparator = Comparator.comparing(it -> it.getDisplayName(), String.CASE_INSENSITIVE_ORDER);
            List sorted = ContainerUtil.sorted((Collection)shelvedLists, nameComparator);
            ShelvedChangesViewManager.getInstance((Project)this.myProject).activateView((ShelvedChangeList)sorted.get(0));
        }
    }

    private void rollbackChanges(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<Change> shelvedChanges) {
        if (GitVersionSpecialty.RESTORE_SUPPORTED.existsIn(this.myProject)) {
            HashSet filePaths = new HashSet();
            for (Change change : shelvedChanges) {
                ContainerUtil.addAllNotNull(filePaths, (Object[])new FilePath[]{ChangesUtil.getBeforePath((Change)change)});
                ContainerUtil.addAllNotNull(filePaths, (Object[])new FilePath[]{ChangesUtil.getAfterPath((Change)change)});
            }
            GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, filePaths).forEach((root, paths) -> {
                boolean isFreshRepository;
                if (!rootsToSave.contains(root)) {
                    LOG.warn(String.format("Paths not under shelved root: root - %s, paths - %s, shelved roots - %s", root, paths, rootsToSave));
                    return;
                }
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRoot((VirtualFile)root);
                boolean bl = isFreshRepository = repository != null && repository.getCurrentRevision() == null;
                if (isFreshRepository) {
                    GitShelveChangesSaver.resetHardLocal(this.myProject, root);
                } else {
                    GitShelveChangesSaver.restoreStagedWorktree(this.myProject, root, paths);
                }
            });
        } else {
            for (VirtualFile virtualFile : rootsToSave) {
                GitShelveChangesSaver.resetHardLocal(this.myProject, virtualFile);
            }
        }
        for (VirtualFile virtualFile : rootsToSave) {
            VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(virtualFile);
        }
    }

    private static void resetHardLocal(@NotNull Project project, @NotNull VirtualFile root) {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
        handler.addParameters("--hard");
        handler.endOptions();
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        if (!result2.success()) {
            LOG.warn("Can't reset changes:" + result2.getErrorOutputAsJoinedString());
        }
    }

    private static void restoreStagedWorktree(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<FilePath> filePaths) {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, filePaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESTORE);
            handler.addParameters("--staged", "--worktree", "--source=HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            GitCommandResult result2 = Git.getInstance().runCommand(handler);
            if (result2.success()) continue;
            LOG.warn("Can't restore changes:" + result2.getErrorOutputAsJoinedString());
        }
    }

    @NonNls
    public String toString() {
        return "ShelveChangesSaver. Lists: " + this.myVcsShelveChangesSaver.getShelvedLists();
    }
}

