/*
 * Decompiled with CFR 0.152.
 */
package git4idea.roots;

import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class GitRootChecker
extends VcsRootChecker {
    GitRootChecker() {
    }

    public boolean isRoot(@NotNull String path) {
        return GitUtil.isGitRoot(path);
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        return GitVcs.getKey();
    }

    public boolean isVcsDir(@NotNull String dirName) {
        return dirName.equalsIgnoreCase(".git");
    }

    public boolean isIgnored(@NotNull VirtualFile root, @NotNull VirtualFile checkForIgnore) {
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), GitCommand.CHECK_IGNORE);
        handler.addParameters("--quiet");
        handler.addRelativeFiles(Collections.singletonList(checkForIgnore));
        return Git.getInstance().runCommand(handler).success();
    }
}

