/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitResetOperation {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<GitRepository, Hash> myCommits;
    @NotNull
    private final GitResetMode myMode;
    @NotNull
    private final ProgressIndicator myIndicator;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitBranchUiHandlerImpl myUiHandler;

    public GitResetOperation(@NotNull Project project, @NotNull Map<GitRepository, Hash> targetCommits, @NotNull GitResetMode mode, @NotNull ProgressIndicator indicator) {
        this.myProject = project;
        this.myCommits = targetCommits;
        this.myMode = mode;
        this.myIndicator = indicator;
        this.myGit = Git.getInstance();
        this.myNotifier = VcsNotifier.getInstance((Project)project);
        this.myUiHandler = new GitBranchUiHandlerImpl(this.myProject, indicator);
    }

    public void execute() {
        GitResetOperation.saveAllDocuments();
        HashMap<GitRepository, GitCommandResult> results = new HashMap<GitRepository, GitCommandResult>();
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("git.reset.process", new Object[0]));){
            for (Map.Entry<GitRepository, Hash> entry : this.myCommits.entrySet()) {
                GitCommandResult smartResult;
                GitRepository repository = entry.getKey();
                VirtualFile root = repository.getRoot();
                String target = entry.getValue().asString();
                GitLocalChangesWouldBeOverwrittenDetector detector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.RESET);
                Hash startHash = GitUtil.getHead(repository);
                GitCommandResult result2 = this.myGit.reset(repository, this.myMode, target, detector);
                if (!result2.success() && detector.wasMessageDetected() && (smartResult = this.proposeSmartReset(detector, repository, target)) != null) {
                    result2 = smartResult;
                }
                results.put(repository, result2);
                GitUtil.updateAndRefreshChangedVfs(repository, startHash);
                VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(root);
            }
        }
        this.notifyResult(results);
    }

    private GitCommandResult proposeSmartReset(@NotNull GitLocalChangesWouldBeOverwrittenDetector detector, @NotNull GitRepository repository, @NotNull @NlsSafe String target) {
        Collection<String> absolutePaths = GitUtil.toAbsolute(repository.getRoot(), detector.getRelativeFilePaths());
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), absolutePaths, false);
        GitSmartOperationDialog.Choice choice = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths, GitBundle.message("git.reset.operation", new Object[0]), GitBundle.message("git.reset.hard.button", new Object[0]));
        if (choice == GitSmartOperationDialog.Choice.SMART) {
            Ref result2 = Ref.create();
            GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
            new GitPreservingProcess(this.myProject, this.myGit, Collections.singleton(repository.getRoot()), GitBundle.message("git.reset.operation", new Object[0]), target, saveMethod, this.myIndicator, () -> result2.set((Object)this.myGit.reset(repository, this.myMode, target, new GitLineHandlerListener[0]))).execute();
            return (GitCommandResult)result2.get();
        }
        if (choice == GitSmartOperationDialog.Choice.FORCE) {
            return this.myGit.reset(repository, GitResetMode.HARD, target, new GitLineHandlerListener[0]);
        }
        return null;
    }

    private void notifyResult(@NotNull Map<GitRepository, GitCommandResult> results) {
        HashMap<GitRepository, GitCommandResult> successes = new HashMap<GitRepository, GitCommandResult>();
        HashMap<GitRepository, GitCommandResult> errors = new HashMap<GitRepository, GitCommandResult>();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            GitCommandResult result2 = entry.getValue();
            GitRepository repository = entry.getKey();
            if (result2.success()) {
                successes.put(repository, result2);
                continue;
            }
            errors.put(repository, result2);
        }
        if (errors.isEmpty()) {
            this.myNotifier.notifySuccess("git.reset.successful", "", GitBundle.message("git.reset.successful.notification.message", new Object[0]));
        } else if (!successes.isEmpty()) {
            this.myNotifier.notifyImportantWarning("git.reset.partially.failed", GitBundle.message("git.reset.partially.failed.notification.title", new Object[0]), GitBundle.message("git.reset.partially.failed.notification.msg", GitResetOperation.joinRepos(successes.keySet()), GitResetOperation.joinRepos(errors.keySet()), GitResetOperation.formErrorReport(errors)));
        } else {
            this.myNotifier.notifyError("git.reset.failed", GitBundle.message("git.reset.failed.notification.title", new Object[0]), GitResetOperation.formErrorReport(errors), true);
        }
    }

    @NlsSafe
    @NotNull
    private static String formErrorReport(@NotNull Map<GitRepository, GitCommandResult> errorResults) {
        MultiMap<String, GitRepository> grouped = GitResetOperation.groupByResult(errorResults);
        if (grouped.size() == 1) {
            return "<code>" + (String)grouped.keySet().iterator().next() + "</code>";
        }
        return StringUtil.join((Collection)grouped.entrySet(), entry -> GitResetOperation.joinRepos((Collection)entry.getValue()) + ":<br/><code>" + (String)entry.getKey() + "</code>", (String)"<br/>");
    }

    @NotNull
    private static MultiMap<String, GitRepository> groupByResult(@NotNull Map<GitRepository, GitCommandResult> results) {
        MultiMap grouped = MultiMap.create();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            grouped.putValue((Object)entry.getValue().getErrorOutputAsHtmlString(), (Object)entry.getKey());
        }
        return grouped;
    }

    @NlsSafe
    @NotNull
    private static String joinRepos(@NotNull Collection<? extends GitRepository> repositories) {
        return StringUtil.join((Iterable)DvcsUtil.sortRepositories(repositories), (String)", ");
    }

    private static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }
}

