/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.openapi.util.NlsContexts;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum GitResetMode {
    SOFT("git.reset.mode.soft", "--soft", "git.reset.mode.soft.description"),
    MIXED("git.reset.mode.mixed", "--mixed", "git.reset.mode.mixed.description"),
    HARD("git.reset.mode.hard", "--hard", "git.reset.mode.hard.description"),
    KEEP("git.reset.mode.keep", "--keep", "git.reset.mode.keep.description");

    @NotNull
    private final String myName;
    @NotNull
    private final String myArgument;
    @NotNull
    private final String myDescription;

    private GitResetMode(@NotNull @PropertyKey(resourceBundle="messages.GitBundle") @NotNull @PropertyKey(resourceBundle="messages.GitBundle") String name, String argument, String description2) {
        this.myName = name;
        this.myArgument = argument;
        this.myDescription = description2;
    }

    @NotNull
    public static GitResetMode getDefault() {
        return MIXED;
    }

    @NotNull
    @NlsContexts.RadioButton
    public String getName() {
        return GitBundle.message(this.myName, new Object[0]);
    }

    @NotNull
    public String getArgument() {
        return this.myArgument;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getDescription() {
        return GitBundle.message(this.myDescription, new Object[0]);
    }
}

