/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ui.VirtualFileHierarchicalComparator;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitVcs;
import git4idea.config.GitVcsSettings;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitUntrackedDirtyScopeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    private static final Logger LOG = Logger.getInstance(GitRepositoryManager.class);
    public static final Comparator<GitRepository> DEPENDENCY_COMPARATOR = (repo1, repo2) -> -VirtualFileHierarchicalComparator.getInstance().compare(repo1.getRoot(), repo2.getRoot());
    private final ExecutorService myUpdateExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"GitRepositoryManager");
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    public GitRepositoryManager(@NotNull Project project) {
        super((AbstractVcs)GitVcs.getInstance(project), ".git");
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)new GitUntrackedDirtyScopeListener(this), (Disposable)this);
    }

    @NotNull
    public static GitRepositoryManager getInstance(@NotNull Project project) {
        return (GitRepositoryManager)((Object)project.getService(GitRepositoryManager.class));
    }

    public boolean isSyncEnabled() {
        return GitVcsSettings.getInstance(this.getVcs().getProject()).getSyncSetting() == DvcsSyncSettings.Value.SYNC && !MultiRootBranches.diverged(this.getRepositories());
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        return this.getRepositories(GitRepository.class);
    }

    public boolean shouldProposeSyncControl() {
        return !this.thereAreSubmodulesInProject() && super.shouldProposeSyncControl();
    }

    private boolean thereAreSubmodulesInProject() {
        return this.getRepositories().stream().anyMatch(repo -> !repo.getSubmodules().isEmpty());
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }

    void notifyListenersAsync(@NotNull GitRepository repository) {
        this.myUpdateExecutor.execute(() -> {
            if (!Disposer.isDisposed((Disposable)repository)) {
                ((GitRepositoryChangeListener)BackgroundTaskUtil.syncPublisher((Project)repository.getProject(), GitRepository.GIT_REPO_CHANGE)).repositoryChanged(repository);
            }
        });
    }

    @NotNull
    public List<GitRepository> sortByDependency(@NotNull Collection<? extends GitRepository> repositories) {
        return ContainerUtil.sorted(repositories, DEPENDENCY_COMPARATOR);
    }
}

