/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import git4idea.repo.GitConfig;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRepositoryFiles {
    private static final Logger LOG = Logger.getInstance(GitRepositoryFiles.class);
    public static final String GITIGNORE = ".gitignore";
    @NonNls
    private static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    @NonNls
    public static final String COMMIT_EDITMSG = "COMMIT_EDITMSG";
    @NonNls
    private static final String CONFIG = "config";
    @NonNls
    private static final String HEAD = "HEAD";
    @NonNls
    private static final String INDEX = "index";
    @NonNls
    private static final String INFO = "info";
    @NonNls
    private static final String INFO_EXCLUDE = "info/exclude";
    @NonNls
    private static final String MERGE_HEAD = "MERGE_HEAD";
    @NonNls
    private static final String MERGE_MSG = "MERGE_MSG";
    @NonNls
    private static final String ORIG_HEAD = "ORIG_HEAD";
    @NonNls
    private static final String REBASE_APPLY = "rebase-apply";
    @NonNls
    private static final String REBASE_MERGE = "rebase-merge";
    @NonNls
    private static final String PACKED_REFS = "packed-refs";
    @NonNls
    private static final String REFS = "refs";
    @NonNls
    private static final String REVERT_HEAD = "REVERT_HEAD";
    @NonNls
    private static final String HEADS = "heads";
    @NonNls
    private static final String TAGS = "tags";
    @NonNls
    private static final String REMOTES = "remotes";
    @NonNls
    private static final String SQUASH_MSG = "SQUASH_MSG";
    @NonNls
    private static final String HOOKS = "hooks";
    @NonNls
    private static final String PRE_COMMIT_HOOK = "pre-commit";
    @NonNls
    private static final String PRE_PUSH_HOOK = "pre-push";
    @NonNls
    private static final String COMMIT_MSG_HOOK = "commit-msg";
    @NonNls
    private static final String SHALLOW = "shallow";
    @NonNls
    private static final String LOGS = "logs";
    @NonNls
    private static final String STASH = "stash";
    @NonNls
    private static final String WORKTREES_DIR = "worktrees";
    private final VirtualFile myRootDir;
    private final VirtualFile myMainDir;
    private final VirtualFile myWorktreeDir;
    @NonNls
    private final String myConfigFilePath;
    @NonNls
    private final String myHeadFilePath;
    @NonNls
    private final String myIndexFilePath;
    @NonNls
    private final String myMergeHeadPath;
    @NonNls
    private final String myCherryPickHeadPath;
    @NonNls
    private final String myRevertHeadPath;
    @NonNls
    private final String myOrigHeadPath;
    @NonNls
    private final String myRebaseApplyPath;
    @NonNls
    private final String myRebaseMergePath;
    @NonNls
    private final String myPackedRefsPath;
    @NonNls
    private final String myRefsHeadsDirPath;
    @NonNls
    private final String myRefsRemotesDirPath;
    @NonNls
    private final String myRefsTagsPath;
    @NonNls
    private final String myCommitMessagePath;
    @NonNls
    private final String myMergeMessagePath;
    @NonNls
    private final String myMergeSquashPath;
    @NonNls
    private final String myInfoDirPath;
    @NonNls
    private final String myExcludePath;
    @NonNls
    private final String myHooksDirPath;
    @NonNls
    private final String myShallow;
    @NonNls
    private final String myStashReflogPath;
    @NonNls
    private final String myWorktreesDirPath;
    @Nullable
    @NonNls
    private String myCustomHooksDirPath;

    private GitRepositoryFiles(@NotNull VirtualFile rootDir, @NotNull VirtualFile mainDir, @NotNull VirtualFile worktreeDir) {
        this.myRootDir = rootDir;
        this.myMainDir = mainDir;
        this.myWorktreeDir = worktreeDir;
        String mainPath = this.myMainDir.getPath();
        this.myConfigFilePath = mainPath + GitRepositoryFiles.slash(CONFIG);
        this.myPackedRefsPath = mainPath + GitRepositoryFiles.slash(PACKED_REFS);
        String refsPath = mainPath + GitRepositoryFiles.slash(REFS);
        this.myRefsHeadsDirPath = refsPath + GitRepositoryFiles.slash(HEADS);
        this.myRefsTagsPath = refsPath + GitRepositoryFiles.slash(TAGS);
        this.myRefsRemotesDirPath = refsPath + GitRepositoryFiles.slash(REMOTES);
        this.myInfoDirPath = mainPath + GitRepositoryFiles.slash(INFO);
        this.myExcludePath = mainPath + GitRepositoryFiles.slash(INFO_EXCLUDE);
        this.myHooksDirPath = mainPath + GitRepositoryFiles.slash(HOOKS);
        this.myShallow = mainPath + GitRepositoryFiles.slash(SHALLOW);
        this.myStashReflogPath = mainPath + GitRepositoryFiles.slash(LOGS) + GitRepositoryFiles.slash(REFS) + GitRepositoryFiles.slash(STASH);
        this.myWorktreesDirPath = mainPath + GitRepositoryFiles.slash(WORKTREES_DIR);
        String worktreePath = this.myWorktreeDir.getPath();
        this.myHeadFilePath = worktreePath + GitRepositoryFiles.slash(HEAD);
        this.myIndexFilePath = worktreePath + GitRepositoryFiles.slash(INDEX);
        this.myMergeHeadPath = worktreePath + GitRepositoryFiles.slash(MERGE_HEAD);
        this.myCherryPickHeadPath = worktreePath + GitRepositoryFiles.slash(CHERRY_PICK_HEAD);
        this.myRevertHeadPath = worktreePath + GitRepositoryFiles.slash(REVERT_HEAD);
        this.myOrigHeadPath = worktreePath + GitRepositoryFiles.slash(ORIG_HEAD);
        this.myCommitMessagePath = worktreePath + GitRepositoryFiles.slash(COMMIT_EDITMSG);
        this.myMergeMessagePath = worktreePath + GitRepositoryFiles.slash(MERGE_MSG);
        this.myMergeSquashPath = worktreePath + GitRepositoryFiles.slash(SQUASH_MSG);
        this.myRebaseApplyPath = worktreePath + GitRepositoryFiles.slash(REBASE_APPLY);
        this.myRebaseMergePath = worktreePath + GitRepositoryFiles.slash(REBASE_MERGE);
    }

    @NotNull
    public static GitRepositoryFiles createInstance(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir) {
        VirtualFile gitDirForWorktree = GitRepositoryFiles.getMainGitDirForWorktree(gitDir);
        VirtualFile mainDir = gitDirForWorktree == null ? gitDir : gitDirForWorktree;
        return new GitRepositoryFiles(rootDir, mainDir, gitDir);
    }

    @Nullable
    private static VirtualFile getMainGitDirForWorktree(@NotNull VirtualFile gitDir) {
        String pathToMain;
        File gitDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)gitDir);
        File commonDir = new File(gitDirFile, "commondir");
        if (!commonDir.exists()) {
            return null;
        }
        try {
            pathToMain = FileUtil.loadFile((File)commonDir).trim();
        }
        catch (IOException e) {
            LOG.error("Couldn't load " + commonDir, (Throwable)e);
            return null;
        }
        String mainDir = FileUtil.toCanonicalPath((String)(gitDirFile.getPath() + File.separator + pathToMain), (boolean)true);
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile mainDirVF = lfs.refreshAndFindFileByPath(mainDir);
        if (mainDirVF != null) {
            return mainDirVF;
        }
        return lfs.refreshAndFindFileByPath(pathToMain);
    }

    @NotNull
    private static String slash(@NotNull String s) {
        return "/" + s;
    }

    @NotNull
    Collection<String> getPathsToWatch() {
        return Arrays.asList(this.myRefsHeadsDirPath, this.myRefsRemotesDirPath, this.myRefsTagsPath, this.myInfoDirPath, this.myHooksDirPath, this.myStashReflogPath);
    }

    @NotNull
    File getRefsHeadsFile() {
        return GitRepositoryFiles.file(this.myRefsHeadsDirPath);
    }

    @NotNull
    File getRefsRemotesFile() {
        return GitRepositoryFiles.file(this.myRefsRemotesDirPath);
    }

    @NotNull
    File getRefsTagsFile() {
        return GitRepositoryFiles.file(this.myRefsTagsPath);
    }

    @NotNull
    File getPackedRefsPath() {
        return GitRepositoryFiles.file(this.myPackedRefsPath);
    }

    @NotNull
    public File getHeadFile() {
        return GitRepositoryFiles.file(this.myHeadFilePath);
    }

    @NotNull
    public File getConfigFile() {
        return GitRepositoryFiles.file(this.myConfigFilePath);
    }

    @NotNull
    public File getRebaseMergeDir() {
        return GitRepositoryFiles.file(this.myRebaseMergePath);
    }

    @NotNull
    public File getRebaseApplyDir() {
        return GitRepositoryFiles.file(this.myRebaseApplyPath);
    }

    @NotNull
    public File getMergeHeadFile() {
        return GitRepositoryFiles.file(this.myMergeHeadPath);
    }

    @NotNull
    public File getCherryPickHead() {
        return GitRepositoryFiles.file(this.myCherryPickHeadPath);
    }

    @NotNull
    public File getRevertHead() {
        return GitRepositoryFiles.file(this.myRevertHeadPath);
    }

    @NotNull
    public File getMergeMessageFile() {
        return GitRepositoryFiles.file(this.myMergeMessagePath);
    }

    @NotNull
    public File getSquashMessageFile() {
        return GitRepositoryFiles.file(this.myMergeSquashPath);
    }

    public void updateCustomPaths(@NotNull GitConfig.Core core) {
        String hooksPath = core.getHooksPath();
        this.myCustomHooksDirPath = hooksPath != null ? this.myRootDir.toNioPath().resolve(hooksPath).toString() : null;
    }

    @NotNull
    public File getPreCommitHookFile() {
        return this.hook(PRE_COMMIT_HOOK);
    }

    @NotNull
    public File getPrePushHookFile() {
        return this.hook(PRE_PUSH_HOOK);
    }

    @NotNull
    public File getCommitMsgHookFile() {
        return this.hook(COMMIT_MSG_HOOK);
    }

    @NotNull
    public File getShallowFile() {
        return GitRepositoryFiles.file(this.myShallow);
    }

    @NotNull
    public File getExcludeFile() {
        return GitRepositoryFiles.file(this.myExcludePath);
    }

    @NotNull
    public File getStashReflogFile() {
        return GitRepositoryFiles.file(this.myStashReflogPath);
    }

    @NotNull
    public File getWorktreesDirFile() {
        return GitRepositoryFiles.file(this.myWorktreesDirPath);
    }

    @NotNull
    private File hook(@NotNull String filePath) {
        return GitRepositoryFiles.file((String)ObjectUtils.chooseNotNull((Object)this.myCustomHooksDirPath, (Object)this.myHooksDirPath) + GitRepositoryFiles.slash(filePath));
    }

    @NotNull
    private static File file(@NotNull String filePath) {
        return new File(FileUtil.toSystemDependentName((String)filePath));
    }

    public boolean isConfigFile(String filePath) {
        return filePath.equals(this.myConfigFilePath);
    }

    public boolean isIndexFile(String filePath) {
        return filePath.equals(this.myIndexFilePath);
    }

    public boolean isHeadFile(String file) {
        return file.equals(this.myHeadFilePath);
    }

    public boolean isOrigHeadFile(@NotNull String file) {
        return file.equals(this.myOrigHeadPath);
    }

    public boolean isBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsHeadsDirPath);
    }

    public boolean isBranchFile(@NotNull String filePath, @NotNull String fullBranchName) {
        return FileUtil.pathsEqual((String)filePath, (String)(this.myMainDir.getPath() + GitRepositoryFiles.slash(fullBranchName)));
    }

    public boolean isRemoteBranchFile(String filePath) {
        return filePath.startsWith(this.myRefsRemotesDirPath);
    }

    public boolean isTagFile(@NotNull String path) {
        return path.startsWith(this.myRefsTagsPath);
    }

    public boolean isRebaseFile(String path) {
        return path.equals(this.myRebaseApplyPath) || path.equals(this.myRebaseMergePath);
    }

    public boolean isMergeFile(String file) {
        return file.equals(this.myMergeHeadPath);
    }

    public boolean isPackedRefs(String file) {
        return file.equals(this.myPackedRefsPath);
    }

    public boolean isCommitMessageFile(@NotNull String file) {
        return file.equals(this.myCommitMessagePath);
    }

    public boolean isExclude(@NotNull String path) {
        return path.equals(this.myExcludePath);
    }

    public boolean isStashReflogFile(@NotNull String path) {
        return path.equals(this.myStashReflogPath);
    }

    public void refresh() {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
    }

    public void refreshIndexFile() {
        VirtualFile indexFilePath = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myIndexFilePath);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{indexFilePath});
    }

    public void refreshTagsFiles() {
        VirtualFile tagsDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myRefsTagsPath);
        VirtualFile packedRefsFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPackedRefsPath);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{tagsDir, packedRefsFile});
    }

    @NotNull
    Collection<VirtualFile> getRootDirs() {
        return ContainerUtil.newHashSet((Object[])new VirtualFile[]{this.myMainDir, this.myWorktreeDir});
    }
}

