/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUnstructuredEditor
extends DialogWrapper {
    @Nullable
    private final JBLabel myRootLabel;
    @NotNull
    private final CommitMessage myTextEditor;

    public GitUnstructuredEditor(@NotNull Project project, @Nullable VirtualFile root, @NotNull @NonNls String initialText, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull @NlsContexts.Button String okButtonText) {
        super(project, true);
        this.setTitle(dialogTitle);
        this.setOKButtonText(okButtonText);
        this.myRootLabel = root == null ? null : new JBLabel(GitBundle.message("rebase.interactive.unstructured.editor.dialog.root.label", root.getPresentableUrl()));
        this.myTextEditor = new CommitMessage(project, false, false, false);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myTextEditor);
        this.myTextEditor.setText(initialText);
        this.myTextEditor.getEditorField().setCaretPosition(0);
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        BorderLayoutPanel rootPanel = JBUI.Panels.simplePanel((int)10, (int)4);
        if (this.myRootLabel != null) {
            rootPanel.addToTop((Component)this.myRootLabel);
        }
        rootPanel.addToCenter((Component)this.myTextEditor);
        return rootPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTextEditor.getEditorField().getFocusTarget();
    }

    @NotNull
    public String getText() {
        return this.myTextEditor.getComment();
    }
}

