/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import git4idea.GitUtil;
import git4idea.commands.GitHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitHandlerRebaseEditorManager
implements AutoCloseable {
    @NotNull
    private final GitHandler myHandler;
    @NotNull
    private final GitRebaseEditorHandler myEditorHandler;
    @NotNull
    private final GitRebaseEditorService myService;
    @Nullable
    private UUID myHandlerId;

    @NotNull
    public static GitHandlerRebaseEditorManager prepareEditor(GitHandler h2, @NotNull GitRebaseEditorHandler editorHandler) {
        GitHandlerRebaseEditorManager manager = new GitHandlerRebaseEditorManager(h2, editorHandler);
        GitUtil.tryRunOrClose(manager, () -> manager.prepareEditor());
        return manager;
    }

    private GitHandlerRebaseEditorManager(@NotNull GitHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        this.myHandler = handler;
        this.myEditorHandler = editorHandler;
        this.myService = GitRebaseEditorService.getInstance();
    }

    private void prepareEditor() {
        if (this.myHandler.containsCustomEnvironmentVariable("GIT_EDITOR")) {
            return;
        }
        this.myHandlerId = this.myService.registerHandler(this.myHandler, this.myEditorHandler);
        this.myHandler.addCustomEnvironmentVariable("GIT_EDITOR", this.myService.getEditorCommand(this.myHandler.getExecutable()));
        this.myHandler.addCustomEnvironmentVariable("IDEA_REBASE_HANDER_NO", this.myHandlerId.toString());
    }

    @Override
    public void close() {
        if (this.myHandlerId != null) {
            this.myService.unregisterHandler(this.myHandlerId);
            this.myHandlerId = null;
        }
    }
}

