/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.openapi.util.NlsSafe;
import git4idea.GitLocalBranch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitPushSource
implements PushSource {
    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch) {
        return new OnBranch(branch, null);
    }

    @NotNull
    public static GitPushSource create(@NotNull GitLocalBranch branch, @Nullable String revision) {
        return new OnBranch(branch, revision);
    }

    @NotNull
    public static GitPushSource create(@NotNull String revision) {
        return new DetachedHead(revision);
    }

    @NotNull
    public abstract GitLocalBranch getBranch();

    @NotNull
    public abstract String getRevision();

    public String toString() {
        return this.getPresentation();
    }

    static class DetachedHead
    extends GitPushSource {
        @NotNull
        private final String myRevision;

        DetachedHead(@NotNull String revision) {
            this.myRevision = revision;
        }

        @NotNull
        public String getPresentation() {
            return DvcsUtil.getShortHash((String)this.myRevision);
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            throw new IllegalStateException("Push is not allowed from detached HEAD");
        }

        @Override
        @NotNull
        public String getRevision() {
            return this.myRevision;
        }
    }

    static final class OnBranch
    extends GitPushSource {
        @NotNull
        private final GitLocalBranch myBranch;
        @NlsSafe
        private final String myRevision;
        private final boolean myIsHead;

        private OnBranch(@NotNull GitLocalBranch branch, @Nullable String revision) {
            this.myBranch = branch;
            this.myIsHead = revision == null;
            this.myRevision = this.myIsHead ? branch.getFullName() : revision;
        }

        @NotNull
        public String getPresentation() {
            return this.myIsHead ? this.myBranch.getName() : DvcsUtil.getShortHash((String)this.myRevision);
        }

        @Override
        @NotNull
        public GitLocalBranch getBranch() {
            return this.myBranch;
        }

        @Override
        @NotNull
        public String getRevision() {
            return this.myRevision;
        }
    }
}

