/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPusher;
import git4idea.push.GroupedPushResult;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GitPushResultNotification
extends Notification {
    private static final Logger LOG = Logger.getInstance(GitPushResultNotification.class);

    private GitPushResultNotification(@NotNull String groupDisplayId, @NotNull @Nls String title, @NotNull @Nls String content2, @NotNull NotificationType type) {
        super(groupDisplayId, "", GitPushResultNotification.emulateTitle(title, content2), type);
        this.setDisplayId("git.push.result");
    }

    @NotNull
    @RequiresEdt
    static GitPushResultNotification create(@NotNull Project project, @NotNull GitPushResult pushResult, @Nullable GitPushOperation pushOperation, boolean multiRepoProject, @Nullable GitUpdateInfoAsLog.NotificationData notificationData) {
        List staleInfoRejected;
        String description2;
        NotificationType type;
        String title;
        GroupedPushResult grouped = GroupedPushResult.group(pushResult.getResults());
        boolean singleRepoSuccess = false;
        if (!grouped.errors.isEmpty()) {
            title = !grouped.successful.isEmpty() ? GitBundle.message("push.notification.partially.failed.title", new Object[0]) : GitBundle.message("push.notification.push.failed.title", new Object[0]);
            type = NotificationType.ERROR;
        } else if (!grouped.rejected.isEmpty() || !grouped.customRejected.isEmpty()) {
            title = !grouped.successful.isEmpty() ? GitBundle.message("push.notification.partially.rejected.title", new Object[0]) : GitBundle.message("push.notification.rejected.title", new Object[0]);
            type = NotificationType.WARNING;
        } else {
            type = NotificationType.INFORMATION;
            if (!multiRepoProject) {
                singleRepoSuccess = true;
                GitPushRepoResult result3 = (GitPushRepoResult)ContainerUtil.getFirstItem(grouped.successful.values());
                title = GitPushResultNotification.formRepoDescription(result3);
            } else {
                title = GitBundle.message("push.notification.successful.title", new Object[0]);
            }
        }
        if (singleRepoSuccess) {
            if (notificationData != null) {
                int receivedCommitsCount = notificationData.getReceivedCommitsCount();
                description2 = GitBundle.message("push.notification.single.repo.success.description", receivedCommitsCount);
            } else {
                description2 = "";
            }
        } else {
            description2 = GitPushResultNotification.formDescription(pushResult.getResults(), multiRepoProject);
        }
        NotificationGroup group = type == NotificationType.INFORMATION ? VcsNotifier.STANDARD_NOTIFICATION : VcsNotifier.IMPORTANT_ERROR_NOTIFICATION;
        GitPushResultNotification notification2 = new GitPushResultNotification(group.getDisplayId(), title, description2, type);
        if (AbstractCommonUpdateAction.showsCustomNotification(Collections.singletonList(GitVcs.getInstance(project)))) {
            if (notificationData != null && notificationData.getReceivedCommitsCount() > 0) {
                Integer filteredCommitsCount = notificationData.getFilteredCommitsCount();
                String actionText = filteredCommitsCount == null || filteredCommitsCount == 0 ? GitBundle.message("push.notification.view.received.commits.action", notificationData.getReceivedCommitsCount()) : GitBundle.message("push.notification.view.filtered.commits.actions", filteredCommitsCount);
                notification2.addAction((AnAction)NotificationAction.createSimple((String)actionText, (Runnable)notificationData.getViewCommitAction()));
            }
        } else {
            UpdateInfoTree tree2;
            UpdatedFiles updatedFiles = pushResult.getUpdatedFiles();
            if (!updatedFiles.isEmpty() && (tree2 = ProjectLevelVcsManagerEx.getInstanceEx((Project)project).showUpdateProjectInfo(updatedFiles, GitBundle.message("push.notification.update.action", new Object[0]), ActionInfo.UPDATE, false)) != null) {
                tree2.setBefore(pushResult.getBeforeUpdateLabel());
                tree2.setAfter(pushResult.getAfterUpdateLabel());
                notification2.addAction((AnAction)new ViewUpdateInfoNotification(project, tree2, GitBundle.message("push.notification.view.files.action", new Object[0]), (Notification)notification2));
            }
        }
        if (!(staleInfoRejected = EntryStream.of(pushResult.getResults()).filterValues(result2 -> result2.getType() == GitPushRepoResult.Type.REJECTED_STALE_INFO).keys().toList()).isEmpty()) {
            notification2.setContextHelpAction(new AnAction(GitBundle.message("push.notification.force.with.lease.help", new Object[0]), new HtmlBuilder().append(GitBundle.message("push.notification.force.with.lease.help.description.first", new Object[0])).br().append(GitBundle.message("push.notification.force.with.lease.help.description.second", new Object[0])).toString(), null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                }
            });
            if (pushOperation != null) {
                notification2.addAction((AnAction)new ForcePushNotificationAction(project, pushOperation, staleInfoRejected));
            }
        }
        if (!(grouped.errors.isEmpty() && grouped.rejected.isEmpty() && grouped.customRejected.isEmpty())) {
            VcsNotifier.addShowDetailsAction((Project)project, (Notification)notification2);
        }
        return notification2;
    }

    @NlsContexts.NotificationContent
    @NotNull
    static String emulateTitle(@NotNull @Nls String title, @NotNull @Nls String content2) {
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.raw((String)title).bold()).br().appendRaw(content2).toString();
    }

    @Nls
    private static String formDescription(@NotNull Map<GitRepository, GitPushRepoResult> results, boolean multiRepoProject) {
        List entries = ContainerUtil.sorted(results.entrySet(), (o1, o2) -> {
            int compareResultTypes = GitPushRepoResult.TYPE_COMPARATOR.compare(((GitPushRepoResult)o1.getValue()).getType(), ((GitPushRepoResult)o2.getValue()).getType());
            if (compareResultTypes != 0) {
                return compareResultTypes;
            }
            return DvcsUtil.REPOSITORY_COMPARATOR.compare((Repository)o1.getKey(), (Repository)o2.getKey());
        });
        return new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map((Collection)entries, entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitPushRepoResult result2 = (GitPushRepoResult)entry.getValue();
            Object description2 = multiRepoProject ? DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + GitPushResultNotification.formRepoDescription(result2) : GitPushResultNotification.formRepoDescription(result2);
            return HtmlChunk.raw((String)description2);
        })).toString();
    }

    @Nls
    private static String selectBundleMessageWithTags(List<@NlsSafe String> pushedTags, @Nls @Nls Supplier<@Nls String> withoutTagsMessage, @Nls @Nls Supplier<@Nls String> singleTagMessage, @Nls @Nls Supplier<@Nls String> manyTagsMessage) {
        if (pushedTags.isEmpty()) {
            return withoutTagsMessage.get();
        }
        if (pushedTags.size() == 1) {
            return singleTagMessage.get();
        }
        return manyTagsMessage.get();
    }

    @NlsSafe
    private static String tagName(List<@NlsSafe String> pushedTags) {
        return GitBranchUtil.stripRefsPrefix(pushedTags.get(0));
    }

    @NlsContexts.NotificationContent
    private static String formRepoDescription(@NotNull GitPushRepoResult result2) {
        String description2;
        String sourceBranch = GitBranchUtil.stripRefsPrefix(result2.getSourceBranch());
        String targetBranch = GitBranchUtil.stripRefsPrefix(result2.getTargetBranch());
        @NotNull List<String> pushedTags = result2.getPushedTags();
        @NotNull String remoteName = result2.getTargetRemote();
        switch (result2.getType()) {
            case SUCCESS: {
                int commitNum = result2.getNumberOfPushedCommits();
                description2 = GitPushResultNotification.selectBundleMessageWithTags(pushedTags, () -> GitBundle.message("push.notification.description.pushed", commitNum, targetBranch), () -> GitBundle.message("push.notification.description.pushed.with.single.tag", commitNum, targetBranch, GitPushResultNotification.tagName(pushedTags), remoteName), () -> GitBundle.message("push.notification.description.pushed.with.many.tags", commitNum, targetBranch, pushedTags.size(), remoteName));
                break;
            }
            case NEW_BRANCH: {
                description2 = GitPushResultNotification.selectBundleMessageWithTags(pushedTags, () -> GitBundle.message("push.notification.description.new.branch", sourceBranch, targetBranch), () -> GitBundle.message("push.notification.description.new.branch.with.single.tag", sourceBranch, targetBranch, GitPushResultNotification.tagName(pushedTags), remoteName), () -> GitBundle.message("push.notification.description.new.branch.with.many.tags", sourceBranch, targetBranch, pushedTags.size(), remoteName));
                break;
            }
            case UP_TO_DATE: {
                description2 = GitPushResultNotification.selectBundleMessageWithTags(pushedTags, () -> GitBundle.message("push.notification.description.up.to.date", new Object[0]), () -> GitBundle.message("push.notification.description.pushed.single.tag", GitPushResultNotification.tagName(pushedTags), remoteName), () -> GitBundle.message("push.notification.description.pushed.many.tags", pushedTags.size(), remoteName));
                break;
            }
            case FORCED: {
                description2 = GitBundle.message("push.notification.description.force.pushed", sourceBranch, targetBranch);
                break;
            }
            case REJECTED_NO_FF: {
                GitUpdateResult updateResult = result2.getUpdateResult();
                if (updateResult == null || updateResult == GitUpdateResult.SUCCESS || updateResult == GitUpdateResult.NOTHING_TO_UPDATE) {
                    description2 = GitBundle.message("push.notification.description.rejected", targetBranch);
                    break;
                }
                if (updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    description2 = GitBundle.message("push.notification.description.rejected.and.conflicts", new Object[0]);
                    break;
                }
                if (updateResult == GitUpdateResult.INCOMPLETE) {
                    description2 = GitBundle.message("push.notification.description.rejected.and.incomplete", new Object[0]);
                    break;
                }
                if (updateResult == GitUpdateResult.CANCEL) {
                    description2 = GitBundle.message("push.notification.description.rejected.and.cancelled", new Object[0]);
                    break;
                }
                description2 = GitBundle.message("push.notification.description.rejected.and.failed", new Object[0]);
                break;
            }
            case REJECTED_STALE_INFO: {
                description2 = GitBundle.message("push.notification.description.push.with.lease.rejected", sourceBranch, targetBranch);
                break;
            }
            case REJECTED_OTHER: {
                description2 = GitBundle.message("push.notification.description.rejected.by.remote", sourceBranch, targetBranch);
                break;
            }
            case ERROR: {
                description2 = XmlStringUtil.escapeString((String)result2.getError());
                break;
            }
            default: {
                LOG.error("Unexpected push result: " + result2);
                description2 = "";
            }
        }
        return description2;
    }

    private static final class ForcePushNotificationAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitPushOperation myOperation;
        @NotNull
        private final List<GitRepository> myRepositories;

        private ForcePushNotificationAction(@NotNull Project project, @NotNull GitPushOperation pushOperation, @NotNull List<GitRepository> repositories) {
            super(GitBundle.message("push.notification.force.push.anyway.action", new Object[0]));
            this.myProject = project;
            this.myOperation = pushOperation;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
            notification2.expire();
            final Project project = this.myProject;
            new Task.Backgroundable(project, GitBundle.message("push.notification.force.push.progress.title.pushing", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    GitPushOperation forcePushOperation = myOperation.deriveForceWithoutLease(myRepositories);
                    GitPusher.pushAndNotify(project, forcePushOperation);
                }
            }.queue();
        }
    }
}

