/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeChangeCollector {
    @NotNull
    private final HashSet<String> myUnmergedPaths = new HashSet();
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final GitRevisionNumber myStart;
    @NotNull
    private final GitRepository myRepository;

    public MergeChangeCollector(@NotNull Project project, @NotNull GitRepository repository, @NotNull GitRevisionNumber start) {
        this.myStart = start;
        this.myProject = project;
        this.myRoot = repository.getRoot();
        this.myRepository = repository;
    }

    public void collect(@NotNull UpdatedFiles updatedFiles) throws VcsException {
        Set<String> paths = this.getUnmergedPaths();
        MergeChangeCollector.addAll(updatedFiles, "MERGED_WITH_CONFLICTS", paths);
        TreeSet<String> updated = new TreeSet<String>();
        TreeSet<String> created = new TreeSet<String>();
        TreeSet<String> removed = new TreeSet<String>();
        String revisionsForDiff = this.getRevisionsForDiff();
        if (revisionsForDiff == null) {
            return;
        }
        this.getChangedFilesExceptUnmerged(updated, created, removed, revisionsForDiff);
        MergeChangeCollector.addAll(updatedFiles, "UPDATED", updated);
        MergeChangeCollector.addAll(updatedFiles, "CREATED", created);
        MergeChangeCollector.addAll(updatedFiles, "REMOVED_FROM_REPOSITORY", removed);
    }

    public int calcUpdatedFilesCount() throws VcsException {
        String revisionsForDiff = this.getRevisionsForDiff();
        if (revisionsForDiff == null) {
            return 0;
        }
        HashSet updated = new HashSet();
        this.getChangedFilesExceptUnmerged(updated, updated, updated, revisionsForDiff);
        return updated.size() + this.getUnmergedPaths().size();
    }

    @NotNull
    private Set<String> getUnmergedPaths() throws VcsException {
        String root = this.myRoot.getPath();
        GitLineHandler h2 = new GitLineHandler(this.myProject, this.myRoot, GitCommand.LS_FILES);
        h2.setSilent(true);
        h2.addParameters("--unmerged");
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        HashSet<String> paths = new HashSet<String>();
        StringScanner s = new StringScanner(output);
        while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            s.boundedToken('\t');
            String relative = s.line();
            if (!this.myUnmergedPaths.add(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            paths.add(path);
        }
        return paths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String getRevisionsForDiff() throws VcsException {
        GitRevisionNumber currentHead = GitRevisionNumber.resolve(this.myProject, this.myRoot, "HEAD");
        if (!currentHead.equals(this.myStart)) return this.myStart.getRev() + "..HEAD";
        File mergeHeadsFile = this.myRepository.getRepositoryFiles().getMergeHeadFile();
        try {
            if (!mergeHeadsFile.exists()) return null;
            String mergeHeads = new String(FileUtil.loadFileText((File)mergeHeadsFile, (String)"UTF-8"));
            StringScanner s = new StringScanner(mergeHeads);
            while (s.hasMoreData()) {
                String head = s.line();
                if (head.length() == 0) continue;
                return this.myStart.getRev() + "..." + head;
            }
            return null;
        }
        catch (IOException e) {
            throw new VcsException(GitBundle.message("merge.error.unable.to.read.merge.head", mergeHeadsFile, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private void getChangedFilesExceptUnmerged(@NotNull Collection<? super String> updated, @NotNull Collection<? super String> created, @NotNull Collection<? super String> removed, @NotNull String revisions) throws VcsException {
        String root = this.myRoot.getPath();
        GitLineHandler h2 = new GitLineHandler(this.myProject, this.myRoot, GitCommand.DIFF);
        h2.setSilent(true);
        h2.addParameters("--name-status", "--diff-filter=ADMRUX", "--no-renames", revisions);
        StringScanner s = new StringScanner(Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]));
        block5: while (s.hasMoreData()) {
            if (s.isEol()) {
                s.nextLine();
                continue;
            }
            char status = s.peek();
            s.boundedToken('\t');
            String relative = s.line();
            if (this.myUnmergedPaths.contains(relative)) continue;
            String path = root + "/" + GitUtil.unescapePath(relative);
            switch (status) {
                case 'M': {
                    updated.add(path);
                    continue block5;
                }
                case 'A': {
                    created.add(path);
                    continue block5;
                }
                case 'D': {
                    removed.add(path);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected status: " + status);
        }
    }

    private static void addAll(@NotNull UpdatedFiles updates, @NotNull String groupId, @NotNull Set<String> paths) {
        FileGroup fileGroup = updates.getGroupById(groupId);
        for (String path : paths) {
            fileGroup.add(path, GitVcs.getKey(), null);
        }
    }
}

