/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitMergeUtil {
    private static final Logger LOG = Logger.getInstance(GitMergeUtil.class);
    static final int ORIGINAL_REVISION_NUM = 1;
    static final int YOURS_REVISION_NUM = 2;
    static final int THEIRS_REVISION_NUM = 3;

    private GitMergeUtil() {
    }

    public static MergeData loadMergeData(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, boolean isReversed) throws VcsException {
        byte[] originalContent = GitMergeUtil.loadOriginalContent(project, root, path);
        byte[] yoursContent = GitMergeUtil.loadRevisionCatchingErrors(project, root, path, 2);
        byte[] theirsContent = GitMergeUtil.loadRevisionCatchingErrors(project, root, path, 3);
        GitRevisionNumber yoursRevision = GitMergeUtil.resolveHead(project, root);
        GitRevisionNumber theirsRevision = GitMergeUtil.resolveMergeHead(project, root);
        GitRevisionNumber originalRevision = GitMergeUtil.findOriginalRevisionNumber(project, root, (VcsRevisionNumber)yoursRevision, (VcsRevisionNumber)theirsRevision);
        Trinity<String, String, String> blobs = GitMergeUtil.getAffectedBlobs(project, root, path);
        FilePath originalPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getFirst(), (VcsRevisionNumber)originalRevision);
        FilePath yoursPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getSecond(), (VcsRevisionNumber)yoursRevision);
        FilePath theirsPath = GitMergeUtil.getBlobPathInRevision(project, root, path, (String)blobs.getThird(), (VcsRevisionNumber)theirsRevision);
        MergeData mergeData = new MergeData();
        mergeData.ORIGINAL = originalContent;
        mergeData.CURRENT = !isReversed ? yoursContent : theirsContent;
        mergeData.LAST = isReversed ? yoursContent : theirsContent;
        mergeData.ORIGINAL_REVISION_NUMBER = originalRevision;
        mergeData.CURRENT_REVISION_NUMBER = !isReversed ? yoursRevision : theirsRevision;
        mergeData.LAST_REVISION_NUMBER = isReversed ? yoursRevision : theirsRevision;
        mergeData.ORIGINAL_FILE_PATH = originalPath;
        mergeData.CURRENT_FILE_PATH = !isReversed ? yoursPath : theirsPath;
        mergeData.LAST_FILE_PATH = isReversed ? yoursPath : theirsPath;
        return mergeData;
    }

    @Nullable
    private static GitRevisionNumber findOriginalRevisionNumber(@NotNull Project project, @NotNull VirtualFile root, @Nullable VcsRevisionNumber yoursRevision, @Nullable VcsRevisionNumber theirsRevision) {
        if (yoursRevision == null || theirsRevision == null) {
            return null;
        }
        try {
            return GitHistoryUtils.getMergeBase(project, root, yoursRevision.asString(), theirsRevision.asString());
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber resolveMergeHead(@NotNull Project project, @NotNull VirtualFile root) {
        try {
            return GitRevisionNumber.resolve(project, root, "MERGE_HEAD");
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve the MERGE_HEAD in " + root + ": " + e.getMessage());
            try {
                return GitRevisionNumber.resolve(project, root, "CHERRY_PICK_HEAD");
            }
            catch (VcsException e2) {
                LOG.info("Couldn't resolve the CHERRY_PICK_HEAD in " + root + ": " + e2.getMessage());
                GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
                assert (repository != null);
                File rebaseApply = repository.getRepositoryFiles().getRebaseApplyDir();
                GitRevisionNumber rebaseRevision = GitMergeUtil.readRevisionFromFile(project, root, new File(rebaseApply, "original-commit"));
                if (rebaseRevision != null) {
                    return rebaseRevision;
                }
                File rebaseMerge = repository.getRepositoryFiles().getRebaseMergeDir();
                GitRevisionNumber mergeRevision = GitMergeUtil.readRevisionFromFile(project, root, new File(rebaseMerge, "stopped-sha"));
                if (mergeRevision != null) {
                    return mergeRevision;
                }
                return null;
            }
        }
    }

    @Nullable
    private static GitRevisionNumber readRevisionFromFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull File file) {
        if (!file.exists()) {
            return null;
        }
        String revision = DvcsUtil.tryLoadFileOrReturn((File)file, null, (String)"UTF-8");
        if (revision == null) {
            return null;
        }
        try {
            return GitRevisionNumber.resolve(project, root, revision);
        }
        catch (VcsException e) {
            LOG.info("Couldn't resolve revision  '" + revision + "' in " + root + ": " + e.getMessage());
            return null;
        }
    }

    @Nullable
    private static GitRevisionNumber resolveHead(@NotNull Project project, @NotNull VirtualFile root) {
        try {
            return GitRevisionNumber.resolve(project, root, "HEAD");
        }
        catch (VcsException e) {
            LOG.warn("Couldn't resolve the HEAD in " + root, (Throwable)e);
            return null;
        }
    }

    private static byte @NotNull [] loadOriginalContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path) {
        try {
            return GitMergeUtil.loadRevisionContent(project, root, path, 1);
        }
        catch (Exception ex) {
            try {
                return (byte[])ReadAction.compute(() -> {
                    VirtualFile file = path.getVirtualFile();
                    if (file == null || !file.isValid()) {
                        LOG.debug("File not found: " + path);
                        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
                    }
                    return file.contentsToByteArray();
                });
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
        }
    }

    private static byte @NotNull [] loadRevisionCatchingErrors(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, int stageNum) throws VcsException {
        try {
            return GitMergeUtil.loadRevisionContent(project, root, path, stageNum);
        }
        catch (VcsException e) {
            String m = e.getMessage().trim();
            if (m.startsWith("fatal: ambiguous argument ") || m.startsWith("fatal: Path '") && m.contains("' exists on disk, but not in '") || m.contains("is in the index, but not at stage ") || m.contains("bad revision") || m.startsWith("fatal: Not a valid object name")) {
                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
            throw e;
        }
    }

    private static byte @NotNull [] loadRevisionContent(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, int stageNum) throws VcsException {
        return GitFileUtils.getFileContent(project, root, ":" + stageNum, VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
    }

    @NotNull
    private static Trinity<String, String, String> getAffectedBlobs(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path) {
        try {
            GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LS_FILES);
            h2.addParameters("--exclude-standard", "--unmerged", "-z");
            h2.endOptions();
            h2.addRelativePaths(path);
            String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
            StringScanner s = new StringScanner(output);
            String originalBlob = null;
            String yoursBlob = null;
            String theirsBlob = null;
            while (s.hasMoreData()) {
                s.spaceToken();
                String blob = s.spaceToken();
                int source = Integer.parseInt(s.tabToken());
                s.boundedToken('\u0000');
                if (source == 1) {
                    originalBlob = blob;
                    continue;
                }
                if (source == 2) {
                    yoursBlob = blob;
                    continue;
                }
                if (source == 3) {
                    theirsBlob = blob;
                    continue;
                }
                throw new IllegalStateException("Unknown revision " + source + " for the file: " + path);
            }
            return Trinity.create(originalBlob, yoursBlob, theirsBlob);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return Trinity.create(null, null, null);
        }
    }

    @Nullable
    private static FilePath getBlobPathInRevision(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable String blob, @Nullable VcsRevisionNumber revision) {
        if (blob == null || revision == null) {
            return null;
        }
        FilePath revisionPath = GitMergeUtil.doGetBlobPathInRevision(project, root, blob, revision, path);
        if (revisionPath != null) {
            return revisionPath;
        }
        return GitMergeUtil.doGetBlobPathInRevision(project, root, blob, revision, null);
    }

    @Nullable
    private static FilePath doGetBlobPathInRevision(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull String blob, @NotNull VcsRevisionNumber revision, @Nullable FilePath path) {
        final FilePath[] result2 = new FilePath[1];
        final boolean[] pathAmbiguous = new boolean[1];
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LS_TREE);
        h2.addParameters(revision.asString());
        if (path != null) {
            h2.endOptions();
            h2.addRelativePaths(path);
        } else {
            h2.addParameters("-r");
            h2.endOptions();
        }
        h2.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (!line.contains(blob)) {
                    return;
                }
                if (pathAmbiguous[0]) {
                    return;
                }
                GitIndexUtil.StagedFileOrDirectory stagedFile = GitIndexUtil.parseListTreeRecord(root, line);
                if (stagedFile instanceof GitIndexUtil.StagedFile && blob.equals(((GitIndexUtil.StagedFile)stagedFile).getBlobHash())) {
                    if (result2[0] == null) {
                        result2[0] = stagedFile.getPath();
                    } else {
                        pathAmbiguous[0] = true;
                    }
                }
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h2);
        if (pathAmbiguous[0]) {
            return null;
        }
        return result2[0];
    }

    public static void acceptOneVersion(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends GitConflict> conflicts, @NotNull GitConflict.ConflictSide side) throws VcsException {
        boolean isCurrent = side == GitConflict.ConflictSide.OURS;
        for (GitConflict gitConflict : conflicts) {
            assert (root.equals(gitConflict.getRoot()));
        }
        ArrayList<FilePath> toCheckout = new ArrayList<FilePath>();
        for (GitConflict gitConflict : conflicts) {
            GitConflict.Status status = gitConflict.getStatus(side);
            FilePath filePath = gitConflict.getFilePath();
            if (status == GitConflict.Status.DELETED) continue;
            toCheckout.add(filePath);
        }
        for (List list2 : VcsFileUtil.chunkPaths((VirtualFile)root, toCheckout)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHECKOUT);
            handler.addParameters(isCurrent ? "--ours" : "--theirs");
            handler.endOptions();
            handler.addParameters(list2);
            GitCommandResult result2 = Git.getInstance().runCommand(handler);
            if (result2.success()) continue;
            throw new VcsException(result2.getErrorOutputAsJoinedString());
        }
    }

    public static void markConflictResolved(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<? extends GitConflict> conflicts, @Nullable GitConflict.ConflictSide side) throws VcsException {
        String[] stringArray;
        ArrayList<FilePath> toAdd = new ArrayList<FilePath>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        for (GitConflict gitConflict : conflicts) {
            FilePath filePath = gitConflict.getFilePath();
            if (side == null || gitConflict.getStatus(side) != GitConflict.Status.DELETED) {
                toAdd.add(filePath);
                continue;
            }
            toDelete.add(filePath);
        }
        if (GitVersionSpecialty.ADD_REJECTS_SPARSE_FILES_FOR_CONFLICTS.existsIn(project)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--sparse";
        } else {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] addParameters = stringArray;
        GitFileUtils.addPaths(project, root, toAdd, true, false, addParameters);
        GitFileUtils.deletePaths(project, root, toDelete, new String[0]);
    }

    public static boolean isReverseRoot(@NotNull GitRepository repository) {
        return repository.getState().equals((Object)Repository.State.REBASING);
    }
}

