/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitDisposable;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitConflictResolver {
    private static final Logger LOG = Logger.getInstance(GitConflictResolver.class);
    @NotNull
    private final Collection<? extends VirtualFile> myRoots;
    @NotNull
    private final Params myParams;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final AbstractVcsHelper myVcsHelper;

    public GitConflictResolver(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull Params params) {
        this.myProject = project;
        this.myRoots = roots;
        this.myParams = params;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
    }

    public final boolean merge() {
        return this.merge(false);
    }

    protected boolean proceedIfNothingToMerge() throws VcsException {
        return true;
    }

    @RequiresBackgroundThread
    protected boolean proceedAfterAllMerged() throws VcsException {
        return true;
    }

    @RequiresBackgroundThread
    public final void mergeNoProceed() {
        this.merge(true);
    }

    @RequiresEdt
    public final void mergeNoProceedInBackground() {
        new Task.Backgroundable(this.myProject, GitBundle.message("apply.changes.resolving.conflicts.progress.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                GitConflictResolver.this.mergeNoProceed();
            }
        }.queue();
    }

    protected void notifyUnresolvedRemain() {
        this.notifyWarning(this.myParams.myErrorNotificationTitle, GitBundle.message("merge.unresolved.conflicts.remaining.notification.body", new Object[0]) + this.myParams.myErrorNotificationAdditionalDescription);
    }

    private void notifyUnresolvedRemainAfterNotification() {
        this.notifyWarning(GitBundle.message("merge.unresolved.conflicts.remaining.notification.title", new Object[0]), this.myParams.myErrorNotificationAdditionalDescription);
    }

    protected void notifyWarning(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content2) {
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, content2, NotificationType.WARNING);
        notification2.setDisplayId("git.cannot.resolve.conflict");
        notification2.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.text.resolve", new Object[0]), () -> {
            notification2.expire();
            BackgroundTaskUtil.executeOnPooledThread((Disposable)GitDisposable.getInstance(this.myProject), () -> this.mergeNoProceed());
        }));
        VcsNotifier.getInstance((Project)this.myProject).notify(notification2);
    }

    private boolean merge(boolean mergeDialogInvokedFromNotification) {
        try {
            Collection<VirtualFile> initiallyUnmergedFiles = this.getUnmergedFiles(this.myRoots);
            if (initiallyUnmergedFiles.isEmpty()) {
                LOG.info("merge: no unmerged files");
                return mergeDialogInvokedFromNotification || this.proceedIfNothingToMerge();
            }
            this.showMergeDialog(initiallyUnmergedFiles);
            Collection<VirtualFile> unmergedFilesAfterResolve = this.getUnmergedFiles(this.myRoots);
            if (unmergedFilesAfterResolve.isEmpty()) {
                LOG.info("merge no more unmerged files");
                return mergeDialogInvokedFromNotification || this.proceedAfterAllMerged();
            }
            LOG.info("mergeFiles unmerged files remain: " + unmergedFilesAfterResolve);
            if (mergeDialogInvokedFromNotification) {
                this.notifyUnresolvedRemainAfterNotification();
            } else {
                this.notifyUnresolvedRemain();
            }
        }
        catch (VcsException e) {
            this.notifyException(e);
        }
        return false;
    }

    private void showMergeDialog(@NotNull Collection<? extends VirtualFile> initiallyUnmergedFiles) {
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitMergeProvider mergeProvider = new GitMergeProvider(this.myProject, this.myParams.reverse);
            this.myVcsHelper.showMergeDialog(new ArrayList(initiallyUnmergedFiles), (MergeProvider)mergeProvider, this.myParams.myMergeDialogCustomizer);
        });
    }

    private void notifyException(@NotNull VcsException e) {
        LOG.info("mergeFiles ", (Throwable)e);
        String description2 = GitBundle.message("conflict.resolver.unmerged.files.check.error.notification.description.text", this.myParams.myErrorNotificationAdditionalDescription);
        VcsNotifier.getInstance((Project)this.myProject).notifyError("git.conflict.resolving.error", this.myParams.myErrorNotificationTitle, new HtmlBuilder().appendRaw(description2).br().appendRaw(e.getLocalizedMessage()).toString());
    }

    @NotNull
    private Collection<VirtualFile> getUnmergedFiles(@NotNull Collection<? extends VirtualFile> roots) throws VcsException {
        HashSet<VirtualFile> unmergedFiles = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : roots) {
            unmergedFiles.addAll(this.getUnmergedFiles(virtualFile));
        }
        return unmergedFiles;
    }

    @NotNull
    private Collection<VirtualFile> getUnmergedFiles(@NotNull VirtualFile root) throws VcsException {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository not found for root " + root);
            return Collections.emptyList();
        }
        List<FilePath> files = GitChangeUtils.getUnmergedFiles(repository);
        return ContainerUtil.mapNotNull(files, it -> LocalFileSystem.getInstance().refreshAndFindFileByPath(it.getPath()));
    }

    public static class Params {
        private boolean reverse;
        private @NlsContexts.NotificationTitle String myErrorNotificationTitle = "";
        private @NlsContexts.NotificationContent String myErrorNotificationAdditionalDescription = "";
        private String myMergeDescription = "";
        private MergeDialogCustomizer myMergeDialogCustomizer;

        public Params() {
            this.myMergeDialogCustomizer = new MergeDialogCustomizer(){

                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    return myMergeDescription;
                }
            };
        }

        public Params(Project project) {
            this.myMergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(project){

                @Override
                @NotNull
                public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
                    if (!StringUtil.isEmpty((String)myMergeDescription)) {
                        return myMergeDescription;
                    }
                    return super.getMultipleFileMergeDescription(files);
                }
            };
        }

        public Params setReverse(boolean reverseMerge) {
            this.reverse = reverseMerge;
            return this;
        }

        public Params setErrorNotificationTitle(@NlsContexts.NotificationTitle String errorNotificationTitle) {
            this.myErrorNotificationTitle = errorNotificationTitle;
            return this;
        }

        public Params setErrorNotificationAdditionalDescription(@NlsContexts.NotificationContent String errorNotificationAdditionalDescription) {
            this.myErrorNotificationAdditionalDescription = errorNotificationAdditionalDescription;
            return this;
        }

        public Params setMergeDescription(@Nls String mergeDescription) {
            this.myMergeDescription = mergeDescription;
            return this;
        }

        public Params setMergeDialogCustomizer(MergeDialogCustomizer mergeDialogCustomizer) {
            this.myMergeDialogCustomizer = mergeDialogCustomizer;
            return this;
        }
    }
}

