/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.CompareWithLocalDialog;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogDiffHandler
implements VcsLogDiffHandler {
    private static final Logger LOG = Logger.getInstance(GitLogDiffHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiffContentFactoryEx myDiffContentFactory;

    public GitLogDiffHandler(@NotNull Project project) {
        this.myProject = project;
        this.myDiffContentFactory = DiffContentFactoryEx.getInstanceEx();
    }

    public void showDiff(@NotNull VirtualFile root, @Nullable FilePath leftPath, @NotNull Hash leftHash, @Nullable FilePath rightPath, @NotNull Hash rightHash) {
        if (leftPath == null && rightPath == null) {
            return;
        }
        FilePath filePath = (FilePath)ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath);
        if (filePath.isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(filePath), leftHash, rightHash);
        } else {
            DiffRequestProducer requestProducer = SimpleDiffRequestProducer.create((FilePath)filePath, () -> {
                DiffContent leftDiffContent = this.createDiffContent(root, leftPath, leftHash);
                DiffContent rightDiffContent = this.createDiffContent(root, rightPath, rightHash);
                return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)leftPath, (FilePath)rightPath, (String)" -> "), leftDiffContent, rightDiffContent, leftHash.asString(), rightHash.asString());
            });
            SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)requestProducer);
            UIUtil.invokeLaterIfNeeded(() -> DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT));
        }
    }

    public void showDiffWithLocal(@NotNull VirtualFile root, @Nullable FilePath revisionPath, @NotNull Hash revisionHash, @NotNull FilePath localPath) {
        if (localPath.isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(localPath), revisionHash, null);
        } else {
            DiffRequestProducer requestProducer = SimpleDiffRequestProducer.create((FilePath)localPath, () -> {
                DiffContent leftDiffContent = this.createDiffContent(root, revisionPath, revisionHash);
                DiffContent rightDiffContent = this.createCurrentDiffContent(localPath);
                return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)revisionPath, (FilePath)localPath, (String)" -> "), leftDiffContent, rightDiffContent, revisionHash.asString(), GitBundle.message("git.log.diff.handler.local.version.content.title", new Object[0]));
            });
            SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducer((DiffRequestProducer)requestProducer);
            UIUtil.invokeLaterIfNeeded(() -> DiffManager.getInstance().showDiff(this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT));
        }
    }

    public void showDiffForPaths(@NotNull VirtualFile root, @Nullable Collection<FilePath> affectedPaths, @NotNull Hash leftRevision, @Nullable Hash rightRevision) {
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean isWithLocal = rightRevision == null;
            Set<FilePath> filePaths = affectedPaths != null ? affectedPaths : Collections.singleton(VcsUtil.getFilePath((VirtualFile)root));
            String leftRevisionTitle = leftRevision.toShortString();
            String rightRevisionTitle = isWithLocal ? GitBundle.message("git.log.diff.handler.local.version.name", new Object[0]) : rightRevision.toShortString();
            String dialogTitle = affectedPaths != null ? GitBundle.message("git.log.diff.handler.changes.between.revisions.in.paths.title", leftRevisionTitle, rightRevisionTitle, GitLogDiffHandler.getTitleForPaths(root, affectedPaths)) : GitBundle.message("git.log.diff.handler.changes.between.revisions.title", leftRevisionTitle, rightRevisionTitle);
            CompareWithLocalDialog.LocalContent localContentSide = isWithLocal ? CompareWithLocalDialog.LocalContent.AFTER : CompareWithLocalDialog.LocalContent.NONE;
            CompareWithLocalDialog.showChanges((Project)this.myProject, (String)dialogTitle, (CompareWithLocalDialog.LocalContent)localContentSide, () -> {
                if (isWithLocal) {
                    return GitChangeUtils.getDiffWithWorkingDir(this.myProject, root, leftRevision.asString(), filePaths, false);
                }
                return GitChangeUtils.getDiff(this.myProject, root, leftRevision.asString(), rightRevision.asString(), filePaths);
            });
        });
    }

    @NotNull
    private static String getTitleForPaths(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) {
        String joinedPaths = StringUtil.join(filePaths, path -> VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path), (String)", ");
        return StringUtil.shortenTextWithEllipsis((String)joinedPaths, (int)100, (int)0);
    }

    @NotNull
    private DiffContent createCurrentDiffContent(@NotNull FilePath localPath) throws VcsException {
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, localPath);
        if (submodule != null) {
            ContentRevision revision = GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
            String content2 = revision.getContent();
            return content2 != null ? this.myDiffContentFactory.create(this.myProject, content2) : this.myDiffContentFactory.createEmpty();
        }
        VirtualFile file = localPath.getVirtualFile();
        LOG.assertTrue(file != null);
        return this.myDiffContentFactory.create(this.myProject, file);
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull VirtualFile root, @Nullable FilePath path, @NotNull Hash hash) throws VcsException {
        EmptyContent diffContent;
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        if (path == null) {
            diffContent = new EmptyContent();
        } else {
            GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, path);
            if (submodule != null) {
                ContentRevision revision = GitSubmoduleContentRevision.createRevision(submodule, (VcsRevisionNumber)revisionNumber);
                String content2 = revision.getContent();
                diffContent = content2 != null ? this.myDiffContentFactory.create(this.myProject, content2) : this.myDiffContentFactory.createEmpty();
            } else {
                try {
                    byte[] content3 = GitFileUtils.getFileContent(this.myProject, root, hash.asString(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
                    diffContent = this.myDiffContentFactory.createFromBytes(this.myProject, content3, path);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
        }
        diffContent.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)new Pair((Object)path, (Object)revisionNumber));
        return diffContent;
    }

    @NotNull
    public ContentRevision createContentRevision(@NotNull FilePath filePath, @NotNull Hash hash) {
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        return GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, this.myProject);
    }
}

