/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.log.GitShowCommitInLogAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCommitTooltipLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance(GitCommitTooltipLinkHandler.class);

    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Hash hash = GitCommitTooltipLinkHandler.tryCreateHash(refSuffix);
        if (hash == null) {
            LOG.warn("Bad revision: " + refSuffix);
            return false;
        }
        GitShowCommitInLogAction.jumpToRevision(project, hash);
        return true;
    }

    @Nullable
    public static String createLink(@NotNull @Nls String text, @NotNull VcsRevisionNumber revisionNumber) {
        Hash hash = GitCommitTooltipLinkHandler.tryCreateHash(revisionNumber.asString());
        if (hash == null) {
            return null;
        }
        return HtmlChunk.link((String)("#git_commit/" + hash.asString()), (String)text).toString();
    }

    @Nullable
    private static Hash tryCreateHash(@NotNull String revision) {
        try {
            return HashImpl.build((String)revision);
        }
        catch (Exception e) {
            return null;
        }
    }
}

