/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.util.VcsCommitsDataLoader;
import git4idea.commands.Git;
import git4idea.commands.GitLineHandler;
import git4idea.commit.signature.GitCommitSignature;
import git4idea.history.GitLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J*\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0005J4\u0010\u001e\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020\u0018\u0012\u0004\u0012\u00020\u00160\"J*\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0002J>\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u001e\u0010!\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00020\u0018\u0012\u0004\u0012\u00020\u00160\"H$R/\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/log/GitCommitSignatureLoaderBase;", "Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;", "Lgit4idea/commit/signature/GitCommitSignature;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "Lcom/intellij/openapi/progress/ProgressIndicator;", "currentIndicator", "getCurrentIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setCurrentIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "currentIndicator$delegate", "Lkotlin/properties/ReadWriteProperty;", "createSignature", "status", "", "signer", "fingerprint", "dispose", "", "loadCommitSignatures", "", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "commits", "", "loadData", "", "Lcom/intellij/vcs/log/CommitId;", "onChange", "Lkotlin/Function1;", "parseSignatures", "lines", "Lkotlin/sequences/Sequence;", "requestData", "indicator", "Companion", "intellij.vcs.git"})
public abstract class GitCommitSignatureLoaderBase
implements VcsCommitsDataLoader<GitCommitSignature>,
Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadWriteProperty currentIndicator$delegate;
    private final Project project;
    private static final Logger LOG;
    private static final String NEW_LINE = "%n";
    private static final String HASH = "%H";
    private static final String SIGNATURE_STATUS = "%G?";
    private static final String SIGNER = "%GS";
    private static final String FINGERPRINT = "%GF";
    private static final String COMMIT_SIGNATURES_FORMAT;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(GitCommitSignatureLoaderBase.class, "currentIndicator", "getCurrentIndicator()Lcom/intellij/openapi/progress/ProgressIndicator;", 0))};
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitCommitSignatureLoaderBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        COMMIT_SIGNATURES_FORMAT = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{HASH, SIGNATURE_STATUS, SIGNER, FINGERPRINT}), (CharSequence)NEW_LINE, null, null, (int)0, null, null, (int)62, null);
    }

    private final ProgressIndicator getCurrentIndicator() {
        return (ProgressIndicator)this.currentIndicator$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setCurrentIndicator(ProgressIndicator progressIndicator) {
        this.currentIndicator$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)progressIndicator);
    }

    public final void loadData(@NotNull List<? extends CommitId> commits2, @NotNull Function1<? super Map<CommitId, ? extends GitCommitSignature>, Unit> onChange) {
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
        this.setCurrentIndicator((ProgressIndicator)new EmptyProgressIndicator());
        ProgressIndicator progressIndicator = this.getCurrentIndicator();
        if (progressIndicator == null) {
            return;
        }
        ProgressIndicator indicator = progressIndicator;
        this.requestData(indicator, commits2, onChange);
    }

    protected abstract void requestData(@NotNull ProgressIndicator var1, @NotNull List<? extends CommitId> var2, @NotNull Function1<? super Map<CommitId, ? extends GitCommitSignature>, Unit> var3);

    public void dispose() {
        this.setCurrentIndicator(null);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    protected final Map<Hash, GitCommitSignature> loadCommitSignatures(@NotNull VirtualFile root, @NotNull Collection<? extends Hash> commits2) throws VcsException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        GitLineHandler gitLineHandler = GitLogUtil.createGitHandler(this.project, root);
        Intrinsics.checkNotNullExpressionValue((Object)gitLineHandler, (String)"GitLogUtil.createGitHandler(project, root)");
        GitLineHandler h2 = gitLineHandler;
        h2.setStdoutSuppressed(true);
        h2.addParameters(GitLogUtil.getNoWalkParameter(this.project));
        h2.addParameters("--format=" + COMMIT_SIGNATURES_FORMAT);
        h2.addParameters("--stdin");
        h2.endOptions();
        Iterable $this$map$iv = commits2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hash hash = (Hash)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.asString();
            collection.add(string);
        }
        GitLogUtil.sendHashesToStdin((List)destination$iv$iv, h2);
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String output = string;
        return this.parseSignatures(this.project, (Sequence<String>)StringsKt.lineSequence((CharSequence)output));
    }

    private final Map<Hash, GitCommitSignature> parseSignatures(Project project, Sequence<String> lines) {
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        VcsLogObjectsFactory factory = (VcsLogObjectsFactory)$this$service$iv.getService(VcsLogObjectsFactory.class);
        Map result2 = new LinkedHashMap();
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            Hash hash;
            GitCommitSignature gitCommitSignature;
            Intrinsics.checkNotNullExpressionValue((Object)factory.createHash((String)iterator.next()), (String)"factory.createHash(iterator.next())");
            GitCommitSignature signature = this.createSignature((String)iterator.next(), (String)iterator.next(), (String)iterator.next());
            if (signature == null) continue;
            GitCommitSignature it = gitCommitSignature;
            boolean bl = false;
            result2.put(hash, it);
        }
        return result2;
    }

    private final GitCommitSignature createSignature(String status, String signer, String fingerprint) {
        GitCommitSignature gitCommitSignature;
        switch (status) {
            case "G": {
                gitCommitSignature = new GitCommitSignature.Verified(signer, fingerprint);
                break;
            }
            case "U": {
                gitCommitSignature = new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.UNKNOWN);
                break;
            }
            case "X": {
                gitCommitSignature = new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.EXPIRED);
                break;
            }
            case "Y": {
                gitCommitSignature = new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.EXPIRED_KEY);
                break;
            }
            case "R": {
                gitCommitSignature = new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.REVOKED_KEY);
                break;
            }
            case "E": {
                gitCommitSignature = new GitCommitSignature.NotVerified(GitCommitSignature.VerificationFailureReason.CANNOT_VERIFY);
                break;
            }
            case "B": {
                gitCommitSignature = GitCommitSignature.Bad.INSTANCE;
                break;
            }
            case "N": {
                gitCommitSignature = null;
                break;
            }
            default: {
                Object var5_5 = null;
                Void it = var5_5;
                boolean bl = false;
                LOG.error("Unknown signature status " + status);
                gitCommitSignature = var5_5;
            }
        }
        return gitCommitSignature;
    }

    public GitCommitSignatureLoaderBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Delegates delegates = Delegates.INSTANCE;
        Object initialValue$iv = null;
        boolean $i$f$observable = false;
        this.currentIndicator$delegate = (ReadWriteProperty)new ObservableProperty<ProgressIndicator>(initialValue$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue2) {
                block0: {
                    void old;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    ProgressIndicator progressIndicator = (ProgressIndicator)newValue2;
                    ProgressIndicator progressIndicator2 = (ProgressIndicator)oldValue;
                    KProperty $noName_0 = property;
                    boolean bl = false;
                    void v0 = old;
                    if (v0 == null) break block0;
                    v0.cancel();
                }
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/log/GitCommitSignatureLoaderBase$Companion;", "", "()V", "COMMIT_SIGNATURES_FORMAT", "", "FINGERPRINT", "HASH", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NEW_LINE", "SIGNATURE_STATUS", "SIGNER", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

