/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.util.GitFileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 52\u00020\u0001:\u00045678B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001fJ\u0016\u0010 \u001a\b\u0018\u00010\u0014R\u00020\u00002\u0006\u0010!\u001a\u00020\tH\u0002J(\u0010 \u001a\b\u0018\u00010\u0014R\u00020\u00002\u0006\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010+\u001a\u00020\u00112\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0-J\u0016\u0010+\u001a\u00020\u00112\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0002J/\u0010/\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\t2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020%H\u0000\u00a2\u0006\u0002\b4RN\u0010\u0005\u001aB\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b* \u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0001\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Key;", "kotlin.jvm.PlatformType", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "disposable", "Lorg/jetbrains/annotations/NotNull;", "executor", "Ljava/util/concurrent/ExecutorService;", "isShutDown", "", "applyRefresh", "", "fileDataList", "", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher$IndexFileData;", "createIndexVirtualFile", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "key", "dispose", "getFile", "readContentFromGit", "", "readContentFromGit$intellij_vcs_git", "readFromGit", "file", "oldHash", "Lcom/intellij/vcs/log/Hash;", "oldModificationStamp", "", "readLengthFromGit", "hash", "", "readMetadataFromGit", "Lgit4idea/index/GitIndexUtil$StagedFile;", "refresh", "condition", "Lkotlin/Function1;", "filesToRefresh", "write", "requestor", "", "newContent", "newModificationStamp", "write$intellij_vcs_git", "Companion", "IndexFileData", "Key", "MyEncodingManagerListener", "intellij.vcs.git"})
public final class GitIndexFileSystemRefresher
implements Disposable {
    private final ExecutorService executor;
    private final Disposable disposable;
    private volatile boolean isShutDown;
    private final LoadingCache<Key, GitIndexVirtualFile> cache;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final GitIndexVirtualFile getFile(@NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            return (GitIndexVirtualFile)((Object)this.cache.get((Object)new Key(root, filePath)));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                throw cause;
            }
            throw (Throwable)e;
        }
    }

    private final GitIndexVirtualFile createIndexVirtualFile(VirtualFile root, FilePath filePath) {
        if (this.isShutDown) {
            return null;
        }
        GitIndexUtil.StagedFile stagedFile = this.readMetadataFromGit(root, filePath);
        if (stagedFile == null) {
            return null;
        }
        GitIndexUtil.StagedFile stagedFile2 = stagedFile;
        String string = stagedFile2.getBlobHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stagedFile.blobHash");
        long length = this.readLengthFromGit(root, string);
        return new GitIndexVirtualFile(this.project, root, filePath, GitIndexFileSystemRefresher.Companion.hash(stagedFile2), length, stagedFile2.isExecutable());
    }

    private final GitIndexVirtualFile createIndexVirtualFile(Key key) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isDispatchThread()) {
            return this.createIndexVirtualFile(key.getRoot(), key.getFilePath());
        }
        return (GitIndexVirtualFile)((Object)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(this, key){
            final /* synthetic */ GitIndexFileSystemRefresher this$0;
            final /* synthetic */ Key $key;

            @Nullable
            public final GitIndexVirtualFile compute() {
                return GitIndexFileSystemRefresher.access$createIndexVirtualFile(this.this$0, this.$key.getRoot(), this.$key.getFilePath());
            }
            {
                this.this$0 = gitIndexFileSystemRefresher;
                this.$key = key;
            }
        }, GitBundle.message("stage.vfs.read.process", key.getFilePath().getName()), false, this.project));
    }

    /*
     * WARNING - void declaration
     */
    public final void refresh(@NotNull Function1<? super GitIndexVirtualFile, Boolean> condition) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterable $this$filter$iv = this.cache.asMap().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)condition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filesToRefresh = (List)destination$iv$iv;
        if (filesToRefresh.isEmpty()) {
            return;
        }
        this.refresh(filesToRefresh);
    }

    private final void refresh(List<GitIndexVirtualFile> filesToRefresh) {
        if (this.isShutDown) {
            return;
        }
        LOG.debug("Starting async refresh for " + CollectionsKt.joinToString$default((Iterable)filesToRefresh, null, null, null, (int)0, null, (Function1)refresh.1.INSTANCE, (int)31, null));
        BackgroundTaskUtil.execute((Executor)this.executor, (Disposable)this.disposable, (Runnable)new Runnable(this, filesToRefresh){
            final /* synthetic */ GitIndexFileSystemRefresher this$0;
            final /* synthetic */ List $filesToRefresh;

            public final void run() {
                List fileDataList = new ArrayList<E>();
                for (GitIndexVirtualFile file : this.$filesToRefresh) {
                    IndexFileData indexFileData;
                    if (GitIndexFileSystemRefresher.access$readFromGit(this.this$0, file) == null) continue;
                    IndexFileData it = indexFileData;
                    boolean bl = false;
                    fileDataList.add(it);
                }
                if (fileDataList.isEmpty()) {
                    return;
                }
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                git4idea.index.vfs.GitIndexFileSystemRefresher$Companion.access$writeInEdtAndWait(GitIndexFileSystemRefresher.Companion, (Function0)new Function0<Unit>(this, fileDataList){
                    final /* synthetic */ refresh.2 this$0;
                    final /* synthetic */ List $fileDataList;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$filterTo$iv$iv;
                        if (GitIndexFileSystemRefresher.access$isShutDown$p(this.this$0.this$0)) {
                            return;
                        }
                        Iterable $this$filter$iv = this.$fileDataList;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            IndexFileData it = (IndexFileData)element$iv$iv;
                            boolean bl = false;
                            if (!(!it.isOutdated())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List dataToApply = (List)destination$iv$iv;
                        if (dataToApply.isEmpty()) {
                            return;
                        }
                        GitIndexFileSystemRefresher.access$applyRefresh(this.this$0.this$0, dataToApply);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fileDataList = list2;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = gitIndexFileSystemRefresher;
                this.$filesToRefresh = list2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IndexFileData readFromGit(GitIndexVirtualFile file) {
        void oldHash;
        boolean $i$f$runReadAction = false;
        Pair pair = (Pair)ApplicationManager.getApplication().runReadAction(new Computable(file){
            final /* synthetic */ GitIndexVirtualFile $file$inlined;
            {
                this.$file$inlined = gitIndexVirtualFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)new Pair((Object)this.$file$inlined.getHash$intellij_vcs_git(), (Object)this.$file$inlined.getModificationStamp());
            }
        });
        Hash hash = (Hash)pair.component1();
        long oldModificationStamp = ((Number)pair.component2()).longValue();
        return this.readFromGit(file, (Hash)oldHash, oldModificationStamp);
    }

    private final IndexFileData readFromGit(GitIndexVirtualFile file, Hash oldHash, long oldModificationStamp) {
        Hash newHash;
        GitIndexUtil.StagedFile stagedFile;
        GitIndexUtil.StagedFile stagedFile2 = stagedFile = this.readMetadataFromGit(file.getRoot(), file.getFilePath());
        Hash hash = newHash = stagedFile2 != null ? GitIndexFileSystemRefresher.Companion.hash(stagedFile2) : null;
        if (Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true) {
            long l;
            if (stagedFile != null) {
                VirtualFile virtualFile = file.getRoot();
                String string = stagedFile.getBlobHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stagedFile.blobHash");
                l = this.readLengthFromGit(virtualFile, string);
            } else {
                l = 0L;
            }
            long newLength = l;
            LOG.debug("Preparing refresh for " + file);
            GitIndexUtil.StagedFile stagedFile3 = stagedFile;
            return new IndexFileData(file, oldHash, newHash, file.getLength$intellij_vcs_git(), newLength, stagedFile3 != null ? stagedFile3.isExecutable() : false, oldModificationStamp);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyRefresh(List<IndexFileData> fileDataList) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = fileDataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexFileData indexFileData = (IndexFileData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VFileContentChangeEvent vFileContentChangeEvent = it.getEvent();
            collection.add(vFileContentChangeEvent);
        }
        List events = (List)destination$iv$iv;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        ((BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).before(events);
        Iterable $this$forEach$iv = fileDataList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexFileData it = (IndexFileData)element$iv;
            boolean bl = false;
            it.apply();
        }
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        ((BulkFileListener)application2.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).after(events);
    }

    public final void write$intellij_vcs_git(@NotNull GitIndexVirtualFile file, @Nullable Object requestor, @NotNull byte[] newContent, long newModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        try {
            long newModStamp = newModificationStamp > 0L ? newModificationStamp : LocalTimeCounter.currentTime();
            VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, (VirtualFile)file, file.getModificationStamp(), newModStamp, false);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            ((BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).before(CollectionsKt.listOf((Object)event));
            Hash oldHash = file.getHash$intellij_vcs_git();
            long oldModificationStamp = file.getModificationStamp();
            String string = GitBundle.message("stage.vfs.write.process", file.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"stage\u2026rite.process\", file.name)");
            Function0 applyChanges2 = (Function0)GitIndexFileSystemRefresher.Companion.computeUnderPotemkinProgress(this.project, string, (Function0)new Function0<Function0<? extends Unit>>(this, file, oldHash, oldModificationStamp, newContent, newModStamp){
                final /* synthetic */ GitIndexFileSystemRefresher this$0;
                final /* synthetic */ GitIndexVirtualFile $file;
                final /* synthetic */ Hash $oldHash;
                final /* synthetic */ long $oldModificationStamp;
                final /* synthetic */ byte[] $newContent;
                final /* synthetic */ long $newModStamp;

                @NotNull
                public final Function0<Unit> invoke() {
                    IndexFileData indexFileData = GitIndexFileSystemRefresher.access$readFromGit(this.this$0, this.$file, this.$oldHash, this.$oldModificationStamp);
                    if (indexFileData != null) {
                        GitIndexFileSystemRefresher.access$getLOG$cp().info("Detected memory-disk conflict in " + this.$file);
                        return (Function0)new Function0<Unit>(this, indexFileData){
                            final /* synthetic */ write.applyChanges.1 this$0;
                            final /* synthetic */ IndexFileData $indexFileData;

                            public final void invoke() {
                                GitIndexFileSystemRefresher.access$applyRefresh(this.this$0.this$0, CollectionsKt.listOf((Object)this.$indexFileData));
                            }
                            {
                                this.this$0 = var1_1;
                                this.$indexFileData = indexFileData;
                                super(0);
                            }
                        };
                    }
                    Hash hash = GitIndexUtil.write(GitIndexFileSystemRefresher.access$getProject$p(this.this$0), this.$file.getRoot(), this.$file.getFilePath(), new ByteArrayInputStream(this.$newContent), this.$file.isExecutable$intellij_vcs_git());
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitIndexUtil.write(proje\u2026tent), file.isExecutable)");
                    Hash newHash = hash;
                    GitIndexFileSystemRefresher.access$getLOG$cp().debug("Written " + this.$file + ". newHash=" + newHash);
                    return (Function0)new Function0<Unit>(this, newHash){
                        final /* synthetic */ write.applyChanges.1 this$0;
                        final /* synthetic */ Hash $newHash;

                        public final void invoke() {
                            this.this$0.$file.setDataFromWrite$intellij_vcs_git(this.$newHash, this.this$0.$newContent.length, this.this$0.$newModStamp);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$newHash = hash;
                            super(0);
                        }
                    };
                }
                {
                    this.this$0 = gitIndexFileSystemRefresher;
                    this.$file = gitIndexVirtualFile;
                    this.$oldHash = hash;
                    this.$oldModificationStamp = l;
                    this.$newContent = byArray;
                    this.$newModStamp = l2;
                    super(0);
                }
            });
            applyChanges2.invoke();
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            ((BulkFileListener)application2.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).after(CollectionsKt.listOf((Object)event));
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e);
        }
    }

    @NotNull
    public final byte[] readContentFromGit$intellij_vcs_git(@NotNull VirtualFile root, @NotNull FilePath filePath) throws IOException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            byte[] byArray2 = GitFileUtils.getFileContent(this.project, root, "", VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath));
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"GitFileUtils.getFileCont\u2026tivePath(root, filePath))");
            byArray = byArray2;
        }
        catch (VcsException e) {
            throw (Throwable)new IOException(e);
        }
        return byArray;
    }

    private final GitIndexUtil.StagedFile readMetadataFromGit(VirtualFile root, FilePath filePath) {
        List<GitIndexUtil.StagedFile> list2 = GitIndexUtil.listStaged(this.project, root, CollectionsKt.listOf((Object)filePath));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"GitIndexUtil.listStaged(\u2026, root, listOf(filePath))");
        return (GitIndexUtil.StagedFile)CollectionsKt.singleOrNull(list2);
    }

    private final long readLengthFromGit(VirtualFile root, String hash) {
        try {
            String output;
            GitLineHandler h2 = new GitLineHandler(this.project, root, GitCommand.CAT_FILE);
            h2.setSilent(true);
            h2.addParameters("-s");
            h2.addParameters(hash);
            h2.endOptions();
            String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
            String string2 = output = string;
            Long l = Long.valueOf(((Object)StringsKt.trim((CharSequence)string2)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(output.trim())");
            return l;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return 0L;
        }
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    public GitIndexFileSystemRefresher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Git index file system refresher", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026ile system refresher\", 1)");
        this.executor = executorService;
        Disposable disposable = Disposer.newDisposable((String)"Git Index File System");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable(\"Git Index File System\")");
        this.disposable = disposable;
        this.cache = Caffeine.newBuilder().weakValues().build(new CacheLoader(this){
            final /* synthetic */ GitIndexFileSystemRefresher this$0;

            @Nullable
            public final GitIndexVirtualFile load(Key key) {
                Key key2 = key;
                Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"key");
                return GitIndexFileSystemRefresher.access$createIndexVirtualFile(this.this$0, key2);
            }
            {
                this.this$0 = gitIndexFileSystemRefresher;
            }
        });
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(this.disposable);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(disposable)");
        MessageBusConnection connection = messageBusConnection;
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GitRepository.GIT_REPO_CHANGE");
        connection.subscribe(topic, (Object)new GitRepositoryChangeListener(){

            @Override
            public final void repositoryChanged(final @NotNull GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Logger logger = LOG;
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
                logger.debug("Scheduling refresh for repository " + virtualFile.getName());
                this.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(){

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return Intrinsics.areEqual((Object)it.getRoot(), (Object)repository.getRoot());
                    }
                }));
            }
        });
        Topic topic2 = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"ProjectManager.TOPIC");
        connection.subscribe(topic2, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (Intrinsics.areEqual((Object)project, (Object)p)) {
                    isShutDown = true;
                    Disposer.dispose((Disposable)disposable);
                    executor.shutdown();
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this){
                        final /* synthetic */ 2 this$0;

                        public final void run() {
                            GitIndexFileSystemRefresher.access$getExecutor$p(this.this$0.this).awaitTermination(100L, TimeUnit.MILLISECONDS);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, GitBundle.message("stage.vfs.shutdown.process", new Object[0]), false, project);
                }
            }
        });
        Topic topic3 = EncodingManagerListener.ENCODING_MANAGER_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"EncodingManagerListener.ENCODING_MANAGER_CHANGES");
        connection.subscribe(topic3, (Object)new MyEncodingManagerListener());
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitIndexFileSystemRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitIn\u2026temRefresher::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ GitIndexVirtualFile access$createIndexVirtualFile(GitIndexFileSystemRefresher $this, VirtualFile root, FilePath filePath) {
        return $this.createIndexVirtualFile(root, filePath);
    }

    public static final /* synthetic */ IndexFileData access$readFromGit(GitIndexFileSystemRefresher $this, GitIndexVirtualFile file) {
        return $this.readFromGit(file);
    }

    public static final /* synthetic */ boolean access$isShutDown$p(GitIndexFileSystemRefresher $this) {
        return $this.isShutDown;
    }

    public static final /* synthetic */ void access$applyRefresh(GitIndexFileSystemRefresher $this, List fileDataList) {
        $this.applyRefresh(fileDataList);
    }

    public static final /* synthetic */ IndexFileData access$readFromGit(GitIndexFileSystemRefresher $this, GitIndexVirtualFile file, Hash oldHash, long oldModificationStamp) {
        return $this.readFromGit(file, oldHash, oldModificationStamp);
    }

    public static final /* synthetic */ GitIndexVirtualFile access$createIndexVirtualFile(GitIndexFileSystemRefresher $this, Key key) {
        return $this.createIndexVirtualFile(key);
    }

    @JvmStatic
    @NotNull
    public static final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
        Companion.refreshVirtualFiles(project, paths);
    }

    @JvmStatic
    public static final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        Companion.refreshRoots(project, roots);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000bJ\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$IndexFileData;", "", "file", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "oldHash", "Lcom/intellij/vcs/log/Hash;", "newHash", "oldLength", "", "newLength", "newExecutable", "", "oldModificationStamp", "(Lgit4idea/index/vfs/GitIndexFileSystemRefresher;Lgit4idea/index/vfs/GitIndexVirtualFile;Lcom/intellij/vcs/log/Hash;Lcom/intellij/vcs/log/Hash;JJZJ)V", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "getEvent", "()Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "apply", "", "isOutdated", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    private final class IndexFileData {
        @NotNull
        private final VFileContentChangeEvent event;
        private final GitIndexVirtualFile file;
        private final Hash oldHash;
        private final Hash newHash;
        private final long newLength;
        private final boolean newExecutable;

        @NotNull
        public final VFileContentChangeEvent getEvent() {
            return this.event;
        }

        public final boolean isOutdated() {
            return Intrinsics.areEqual((Object)this.file.getHash$intellij_vcs_git(), (Object)this.oldHash) ^ true;
        }

        public final void apply() {
            LOG.debug("Refreshing " + this.file);
            this.file.setDataFromRefresh$intellij_vcs_git(this.newHash, this.newLength, this.newExecutable);
        }

        @NotNull
        public String toString() {
            return "IndexFileData: " + this.file;
        }

        public IndexFileData(@Nullable GitIndexVirtualFile file, @Nullable Hash oldHash, Hash newHash, long oldLength, long newLength, boolean newExecutable, long oldModificationStamp) {
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            this.file = file;
            this.oldHash = oldHash;
            this.newHash = newHash;
            this.newLength = newLength;
            this.newExecutable = newExecutable;
            this.event = new VFileContentChangeEvent(null, (VirtualFile)this.file, oldModificationStamp, -1L, 0L, 0L, oldLength, this.newLength, true);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Key;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class Key {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final FilePath filePath;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final FilePath getFilePath() {
            return this.filePath;
        }

        public Key(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.root = root;
            this.filePath = filePath;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final FilePath component2() {
            return this.filePath;
        }

        @NotNull
        public final Key copy(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new Key(root, filePath);
        }

        public static /* synthetic */ Key copy$default(Key key, VirtualFile virtualFile, FilePath filePath, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = key.root;
            }
            if ((n & 2) != 0) {
                filePath = key.filePath;
            }
            return key.copy(virtualFile, filePath);
        }

        @NotNull
        public String toString() {
            return "Key(root=" + this.root + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.root;
            FilePath filePath = this.filePath;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (filePath != null ? filePath.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Key)) break block3;
                    Key key = (Key)object;
                    if (!Intrinsics.areEqual((Object)this.root, (Object)key.root) || !Intrinsics.areEqual((Object)this.filePath, (Object)key.filePath)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener;", "Lcom/intellij/openapi/vfs/encoding/EncodingManagerListener;", "(Lgit4idea/index/vfs/GitIndexFileSystemRefresher;)V", "propertyChanged", "", "eventDocument", "Lcom/intellij/openapi/editor/Document;", "propertyName", "", "oldValue", "", "newValue", "reloadCachedPropertiesFiles", "intellij.vcs.git"})
    private final class MyEncodingManagerListener
    implements EncodingManagerListener {
        public void propertyChanged(@Nullable Document eventDocument, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue2) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            if (Intrinsics.areEqual((Object)"native2ascii", (Object)propertyName) || Intrinsics.areEqual((Object)"propertiesFilesEncoding", (Object)propertyName)) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ MyEncodingManagerListener this$0;

                    public final void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                            final /* synthetic */ propertyChanged.1 this$0;

                            public final void run() {
                                MyEncodingManagerListener.access$reloadCachedPropertiesFiles(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = myEncodingManagerListener;
                    }
                });
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void reloadCachedPropertiesFiles() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = GitIndexFileSystemRefresher.this.cache.asMap().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GitIndexVirtualFile it = (GitIndexVirtualFile)((Object)element$iv$iv);
                boolean bl = false;
                if (!FileTypeRegistry.getInstance().isFileOfType((VirtualFile)it, (FileType)StdFileTypes.PROPERTIES)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List virtualFiles = (List)destination$iv$iv;
            for (GitIndexVirtualFile file : virtualFiles) {
                Document document = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                file.setCharset(null);
            }
            VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)virtualFiles);
            FileDocumentManager.getInstance().reloadFiles(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }

        public static final /* synthetic */ void access$reloadCachedPropertiesFiles(MyEncodingManagerListener $this) {
            $this.reloadCachedPropertiesFiles();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0016H\u0007J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0007J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014H\u0007J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0002J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "computeUnderPotemkinProgress", "T", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "computation", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getInstance", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "refreshFilePaths", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshRoots", "roots", "refreshVirtualFiles", "writeInEdtAndWait", "action", "hash", "Lcom/intellij/vcs/log/Hash;", "Lgit4idea/index/GitIndexUtil$StagedFile;", "intellij.vcs.git"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            return (GitIndexFileSystemRefresher)$this$service$iv.getService(GitIndexFileSystemRefresher.class);
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Set pathsSet = CollectionsKt.toSet((Iterable)paths);
                Project $this$serviceIfCreated$iv = project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(pathsSet){
                    final /* synthetic */ Set $pathsSet;

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return this.$pathsSet.contains(it.getFilePath());
                    }
                    {
                        this.$pathsSet = set;
                        super(1);
                    }
                }));
            }
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Project $this$serviceIfCreated$iv = project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(paths){
                    final /* synthetic */ Map $paths;

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        Collection collection = (Collection)this.$paths.get(it.getRoot());
                        return collection != null && collection.contains(it.getFilePath());
                    }
                    {
                        this.$paths = map2;
                        super(1);
                    }
                }));
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
            Collection<FilePath> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable iterable = paths;
            Project project2 = project;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)p1);
                collection.add(filePath);
            }
            collection = (List)destination$iv$iv;
            companion.refreshFilePaths(project2, (Collection<? extends FilePath>)collection);
        }

        @JvmStatic
        public final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                Project $this$serviceIfCreated$iv = project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)new Function1<GitIndexVirtualFile, Boolean>(roots){
                    final /* synthetic */ Collection $roots;

                    public final boolean invoke(@NotNull GitIndexVirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        return this.$roots.contains(it.getRoot());
                    }
                    {
                        this.$roots = collection;
                        super(1);
                    }
                }));
            }
        }

        private final Hash hash(GitIndexUtil.StagedFile $this$hash) {
            Hash hash = HashImpl.build((String)$this$hash.getBlobHash());
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"HashImpl.build(blobHash)");
            return hash;
        }

        private final void writeInEdtAndWait(Function0<Unit> action) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(action){
                final /* synthetic */ Function0 $action;

                public final void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                        final /* synthetic */ writeInEdtAndWait.1 this$0;

                        public final void run() {
                            this.this$0.$action.invoke();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$action = function0;
                }
            });
        }

        private final <T> T computeUnderPotemkinProgress(Project project, @NlsContexts.ProgressTitle String message, Function0<? extends T> computation) {
            Ref result2 = new Ref(null);
            new PotemkinProgress(message, project, null, null).runInBackground(new Runnable(result2, computation){
                final /* synthetic */ Ref $result;
                final /* synthetic */ Function0 $computation;

                public final void run() {
                    this.$result.set(this.$computation.invoke());
                }
                {
                    this.$result = ref;
                    this.$computation = function0;
                }
            });
            return (T)result2.get();
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$writeInEdtAndWait(Companion $this, Function0 action) {
            $this.writeInEdtAndWait((Function0<Unit>)action);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

