/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitFullDetailsCollector;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.InternedGitLogRecordBuilder;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GitLogUtil {
    private static final Logger LOG = Logger.getInstance(GitLogUtil.class);
    public static final String GRAFTED = "grafted";
    public static final String REPLACED = "replaced";
    public static final List<String> LOG_ALL = List.of("HEAD", "--branches", "--remotes", "--tags");
    public static final String STDIN = "--stdin";
    static final GitLogParser.GitLogOption[] COMMIT_METADATA_OPTIONS = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};

    public static void readTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @Nullable Consumer<? super VcsUser> userConsumer, @Nullable Consumer<? super VcsRef> refConsumer, @NotNull Consumer<? super TimedVcsCommit> commitConsumer) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
        ArrayList options = ContainerUtil.newArrayList((Object[])new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME});
        if (userConsumer != null) {
            options.add(GitLogParser.GitLogOption.AUTHOR_NAME);
            options.add(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        }
        if (refConsumer != null) {
            options.add(GitLogParser.GitLogOption.REF_NAMES);
        }
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options.toArray(new GitLogParser.GitLogOption[0]));
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
        handler.addParameters("--decorate=full");
        handler.addParameters(parameters);
        handler.endOptions();
        GitLogOutputSplitter<GitLogRecord> handlerListener = new GitLogOutputSplitter<GitLogRecord>(handler, parser, record -> {
            Hash hash = HashImpl.build((String)record.getHash());
            List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
            commitConsumer.consume((Object)factory.createTimedCommit(hash, parents, record.getCommitTime()));
            if (refConsumer != null) {
                for (VcsRef ref : GitLogUtil.parseRefs(record.getRefs(), hash, factory, root)) {
                    refConsumer.consume((Object)ref);
                }
            }
            if (userConsumer != null) {
                userConsumer.consume((Object)factory.createUser(record.getAuthorName(), record.getAuthorEmail()));
            }
        });
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        handlerListener.reportErrors();
    }

    @NotNull
    public static List<? extends VcsCommitMetadata> collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2) throws VcsException {
        CollectConsumer collectConsumer = new CollectConsumer();
        GitLogUtil.collectMetadata(project, root, hashes2, (Consumer<? super VcsCommitMetadata>)collectConsumer);
        return new ArrayList(collectConsumer.getResult());
    }

    public static void collectMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull Consumer<? super VcsCommitMetadata> consumer2) throws VcsException {
        if (hashes2.isEmpty()) {
            return;
        }
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler h2 = GitLogUtil.createGitHandler(project, root);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, COMMIT_METADATA_OPTIONS);
        h2.setSilent(true);
        h2.addParameters(GitLogUtil.getNoWalkParameter(project));
        h2.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h2.addParameters(STDIN);
        h2.endOptions();
        GitLogUtil.sendHashesToStdin(hashes2, h2);
        GitLogOutputSplitter<GitLogRecord> outputHandler = new GitLogOutputSplitter<GitLogRecord>(h2, parser, record -> {
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            record.setUsedHandler(h2);
            consumer2.consume((Object)factory.createCommitMetadata(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp()));
        });
        Git.getInstance().runCommandWithoutCollectingOutput(h2).throwOnError(new int[0]);
        outputHandler.reportErrors();
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData collectMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return LogDataImpl.empty();
        }
        ObjectOpenCustomHashSet refs = new ObjectOpenCustomHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        ArrayList commits2 = new ArrayList();
        Consumer recordConsumer = arg_0 -> GitLogUtil.lambda$collectMetadata$3(root, factory, commits2, (Set)refs, arg_0);
        try {
            GitLineHandler handler = GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
            GitLogParser.GitLogOption[] options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])COMMIT_METADATA_OPTIONS, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
            GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, options);
            handler.setStdoutSuppressed(true);
            handler.addParameters(params);
            handler.addParameters(parser.getPretty(), "--encoding=UTF-8");
            handler.addParameters("--decorate=full");
            handler.endOptions();
            StopWatch sw = StopWatch.start((String)("loading commit metadata in [" + root.getName() + "]"));
            GitLogOutputSplitter<GitLogRecord> handlerListener = new GitLogOutputSplitter<GitLogRecord>(handler, parser, recordConsumer);
            Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
            handlerListener.reportErrors();
            sw.report();
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return new LogDataImpl((Set)refs, commits2);
    }

    public static void readFullDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetails(commitConsumer, GitCommitRequirements.DEFAULT, false, parameters);
    }

    public static void readFullDetailsForHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull GitCommitRequirements requirements, @NotNull Consumer<? super GitCommit> commitConsumer) throws VcsException {
        if (hashes2.isEmpty()) {
            return;
        }
        new GitFullDetailsCollector(project, root, new InternedGitLogRecordBuilder()).readFullDetailsForHashes(hashes2, requirements, false, commitConsumer);
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        return ContainerUtil.mapNotNull(refs, refName -> {
            if (refName.equals(GRAFTED) || refName.equals(REPLACED)) {
                return null;
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
    }

    @Nullable
    public static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        return (VcsLogObjectsFactory)ReadAction.compute(() -> {
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    static VcsCommitMetadata createMetadata(@NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) {
        List parents = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        return factory.createCommitMetadata(factory.createHash(record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
    }

    public static void sendHashesToStdin(@NotNull Collection<String> hashes2, @NotNull GitHandler handler) {
        handler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(hashes2, "\n", handler.getCharset(), true));
    }

    @NotNull
    public static String getNoWalkParameter(@NotNull Project project) {
        return GitVersionSpecialty.NO_WALK_UNSORTED.existsIn(project) ? "--no-walk=unsorted" : "--no-walk";
    }

    @NotNull
    public static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root) {
        return GitLogUtil.createGitHandler(project, root, Collections.emptyList(), false);
    }

    @NotNull
    static GitLineHandler createGitHandler(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> configParameters, boolean lowPriorityProcess) {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.LOG, configParameters);
        if (lowPriorityProcess) {
            handler.withLowPriority();
        }
        handler.setWithMediator(false);
        return handler;
    }

    public static long parseTime(@NotNull String timeString) {
        return Long.parseLong(timeString.trim()) * 1000L;
    }

    private static /* synthetic */ void lambda$collectMetadata$3(VirtualFile root, VcsLogObjectsFactory factory, List commits2, Set refs, GitLogRecord record) {
        VcsCommitMetadata commit = GitLogUtil.createMetadata(root, record, factory);
        commits2.add(commit);
        Collection<VcsRef> refsInRecord = GitLogUtil.parseRefs(record.getRefs(), (Hash)commit.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
    }
}

