/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import git4idea.config.GitProtectedBranchProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="GitSharedSettings", storages={@Storage(value="vcs.xml")})
public class GitSharedSettings
implements PersistentStateComponent<State> {
    private final Project myProject;
    private State myState = new State();

    public GitSharedSettings(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    public static GitSharedSettings getInstance(@NotNull Project project) {
        return (GitSharedSettings)project.getService(GitSharedSettings.class);
    }

    public boolean isSynchronizeBranchProtectionRules() {
        return this.myState.synchronizeBranchProtectionRules;
    }

    public void setSynchronizeBranchProtectionRules(boolean sync) {
        this.myState.synchronizeBranchProtectionRules = sync;
    }

    @NotNull
    public List<String> getForcePushProhibitedPatterns() {
        return Collections.unmodifiableList(this.myState.FORCE_PUSH_PROHIBITED_PATTERNS);
    }

    public void setForcePushProhibitedPatterns(@NotNull List<String> patterns) {
        this.myState.FORCE_PUSH_PROHIBITED_PATTERNS = new ArrayList<String>(patterns);
    }

    public boolean isBranchProtected(@NotNull String branch) {
        return Stream.of(this.getForcePushProhibitedPatterns(), this.getAdditionalProhibitedPatterns()).flatMap(Collection::stream).anyMatch(pattern -> branch.matches("^" + pattern + "$"));
    }

    @NotNull
    public List<String> getAdditionalProhibitedPatterns() {
        if (!this.isSynchronizeBranchProtectionRules()) {
            return Collections.emptyList();
        }
        return GitProtectedBranchProvider.getProtectedBranchPatterns(this.myProject);
    }

    public static class State {
        public List<@NonNls String> FORCE_PUSH_PROHIBITED_PATTERNS = ContainerUtil.newArrayList((Object[])new String[]{"master"});
        public boolean synchronizeBranchProtectionRules = true;
    }
}

