/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.text.ParseException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitExecutableDetector myExecutableDetector = new GitExecutableDetector();
    @NotNull
    private final CachingFileTester myVersionCache = new CachingFileTester(){

        @Override
        @NotNull
        protected GitVersion testExecutable(@NotNull GitExecutable executable) throws VcsException, ParseException {
            return GitExecutableManager.doGetGitVersion(executable);
        }
    };
    public static final Topic<GitExecutableListener> TOPIC = new Topic(GitExecutableListener.class, Topic.BroadcastDirection.NONE);

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ApplicationManager.getApplication().getService(GitExecutableManager.class);
    }

    private static GitVersion doGetGitVersion(@NotNull GitExecutable executable) throws VcsException, ParseException {
        GitVersion.Type type = null;
        if (executable instanceof GitExecutable.Unknown) {
            type = GitVersion.Type.UNDEFINED;
        } else if (executable instanceof GitExecutable.Wsl) {
            WSLDistribution distribution = ((GitExecutable.Wsl)executable).getDistribution();
            type = distribution.getVersion() == 1 ? GitVersion.Type.WSL1 : GitVersion.Type.WSL2;
        }
        LOG.debug("Acquiring git version for " + executable);
        GitLineHandler handler = new GitLineHandler(null, new File("."), executable, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setTerminationTimeout(1000);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult, type);
        LOG.info("Git version for " + executable + ": " + version);
        return version;
    }

    @NotNull
    public String getPathToGit() {
        return this.getPathToGit(null);
    }

    @NotNull
    public String getPathToGit(@Nullable Project project) {
        String pathToGit = this.getPathToGit(project, null, true);
        if (pathToGit == null) {
            pathToGit = GitExecutableDetector.getDefaultExecutable();
        }
        return pathToGit;
    }

    @Nullable
    private String getPathToGit(@Nullable Project project, @Nullable File gitDirectory, boolean detectIfNeeded) {
        String path = null;
        if (project != null && (project.isDefault() || TrustedProjects.isTrusted((Project)project))) {
            path = GitVcsSettings.getInstance(project).getPathToGit();
        }
        if (path == null) {
            path = GitVcsApplicationSettings.getInstance().getSavedPathToGit();
        }
        if (path == null) {
            WSLDistribution distribution = gitDirectory != null ? WslPath.getDistributionByWindowsUncPath((String)gitDirectory.getPath()) : GitExecutableManager.getProjectWslDistribution(project);
            path = this.myExecutableDetector.getExecutable(distribution, detectIfNeeded);
        }
        return path;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project) {
        return this.getExecutable(project, null);
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project, @Nullable File gitDirectory) {
        String path = this.getPathToGit(project, gitDirectory, true);
        if (path == null) {
            path = GitExecutableDetector.getDefaultExecutable();
        }
        return this.getExecutable(path);
    }

    @NotNull
    public GitExecutable getExecutable(@NotNull String pathToGit) {
        WslPath wslPath = WslPath.parseWindowsUncPath((String)pathToGit);
        if (wslPath != null) {
            return new GitExecutable.Wsl(wslPath.getLinuxPath(), wslPath.getDistribution());
        }
        return new GitExecutable.Local(pathToGit);
    }

    public static boolean supportWslExecutable() {
        return WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser");
    }

    @Nullable
    private static WSLDistribution getProjectWslDistribution(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        return WslPath.getDistributionByWindowsUncPath((String)basePath);
    }

    @Nullable
    public String getDetectedExecutable(@Nullable Project project, boolean detectIfNeeded) {
        WSLDistribution distribution = GitExecutableManager.getProjectWslDistribution(project);
        return this.myExecutableDetector.getExecutable(distribution, detectIfNeeded);
    }

    @RequiresBackgroundThread
    public void dropExecutableCache() {
        this.myExecutableDetector.clear();
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String pathToGit = this.getPathToGit(project, null, false);
        if (pathToGit == null) {
            return GitVersion.NULL;
        }
        GitExecutable executable = this.getExecutable(pathToGit);
        return this.getVersion(executable);
    }

    @NotNull
    public GitVersion getVersion(@NotNull GitExecutable executable) {
        CachingFileTester.TestResult result2 = this.myVersionCache.getCachedResultFor(executable);
        if (result2 == null || result2.getResult() == null) {
            return GitVersion.NULL;
        }
        return result2.getResult();
    }

    @RequiresEdt
    @NotNull
    public GitVersion getVersionUnderModalProgressOrCancel(@NotNull Project project) throws ProcessCanceledException {
        return (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GitVersion version;
            GitExecutable executable = this.getExecutable(project);
            try {
                version = this.identifyVersion(executable);
            }
            catch (GitVersionIdentificationException e) {
                throw new ProcessCanceledException();
            }
            return version;
        }, GitBundle.message("git.executable.version.progress.title", new Object[0]), true, project);
    }

    @Nullable
    public GitVersion tryGetVersion(@NotNull Project project) {
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.message("git.executable.version.progress.title", new Object[0]), () -> {
            try {
                GitExecutable executable = this.getExecutable(project);
                return this.identifyVersion(executable);
            }
            catch (ProcessCanceledException | GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    @Nullable
    public GitVersion tryGetVersion(@Nullable Project project, @NotNull GitExecutable executable) {
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.message("git.executable.version.progress.title", new Object[0]), () -> {
            try {
                return this.identifyVersion(executable);
            }
            catch (ProcessCanceledException | GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    static <T> T runUnderProgressIfNeeded(@Nullable Project project, @NotNull @NlsContexts.ProgressTitle String title, @NotNull ThrowableComputable<T, RuntimeException> task2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, title, true, project);
        }
        return (T)task2.compute();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        return this.identifyVersion(this.getExecutable(pathToGit));
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@NotNull GitExecutable executable) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2 = this.myVersionCache.getResultFor(executable);
        if (result2.getResult() == null) {
            Exception e = result2.getException();
            if (e instanceof NoSuchFileException && executable.getExePath().equals(GitExecutableDetector.getDefaultExecutable())) {
                throw new GitNotInstalledException(GitBundle.message("executable.error.git.not.installed", new Object[0]), e);
            }
            throw new GitVersionIdentificationException(GitBundle.message("git.executable.validation.cant.identify.executable.message", executable), e);
        }
        return result2.getResult();
    }

    public void dropVersionCache(@NotNull GitExecutable executable) {
        this.myVersionCache.dropCache(executable);
    }

    @RequiresBackgroundThread
    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        GitExecutable executable = this.getExecutable(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, executable);
        if (version == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, version, new NotificationErrorNotifier(project));
        return false;
    }

    @RequiresBackgroundThread
    @Nullable
    private GitVersion identifyVersionOrDisplayError(@NotNull Project project, @NotNull GitExecutable executable) {
        try {
            return this.identifyVersion(executable);
        }
        catch (GitVersionIdentificationException e) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            return null;
        }
    }
}

