/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.BaseOutputReader;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.config.GitExecutable;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitTextHandler
extends GitHandler {
    private static final int WAIT_TIMEOUT_MS = 50;
    private static final int TERMINATION_TIMEOUT_MS = 60000;
    private OSProcessHandler myHandler;
    private volatile boolean myIsDestroyed;
    private final Object myProcessStateLock = new Object();
    protected boolean myWithMediator = true;
    private int myTerminationTimeoutMs = 60000;

    protected GitTextHandler(@Nullable Project project, @NotNull File directory, @NotNull GitCommand command) {
        super(project, directory, command, Collections.emptyList());
    }

    protected GitTextHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command) {
        super(project, vcsRoot, command, Collections.emptyList());
    }

    protected GitTextHandler(@Nullable Project project, @NotNull VirtualFile vcsRoot, @NotNull GitCommand command, List<String> configParameters) {
        super(project, vcsRoot, command, configParameters);
    }

    public GitTextHandler(@Nullable Project project, @NotNull File directory, @NotNull GitExecutable executable, @NotNull GitCommand command, @NotNull List<String> configParameters) {
        super(project, directory, executable, command, configParameters);
    }

    public void setWithMediator(boolean value) {
        this.myWithMediator = value;
    }

    public void setTerminationTimeout(int timeoutMs) {
        this.myTerminationTimeoutMs = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Process startProcess() throws ExecutionException {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return null;
            }
            this.myHandler = this.createProcess(this.myCommandLine);
            return this.myHandler.getProcess();
        }
    }

    @Override
    protected void startHandlingStreams() {
        this.myHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode = event.getExitCode();
                GitHandler.OUTPUT_LOG.debug(String.format("%s %% %s terminated (%s)", GitTextHandler.this.getCommand(), GitTextHandler.this.hashCode(), exitCode));
                try {
                    GitTextHandler.this.setExitCode(exitCode);
                    GitTextHandler.this.processTerminated(exitCode);
                }
                finally {
                    GitTextHandler.this.listeners().processTerminated(exitCode);
                }
            }
        });
        this.myHandler.startNotify();
    }

    protected abstract void processTerminated(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyProcess() {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            this.myIsDestroyed = true;
            if (this.myHandler != null) {
                this.myHandler.destroyProcess();
            }
        }
    }

    @Override
    protected void waitForProcess() {
        if (this.myHandler != null) {
            ProgressManager progressManager = ProgressManager.getInstance();
            while (!this.myHandler.waitFor(50L)) {
                try {
                    ProgressIndicator indicator = progressManager.getProgressIndicator();
                    if (indicator == null) continue;
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    progressManager.executeNonCancelableSection(() -> {
                        if (!this.tryKill()) {
                            LOG.warn("Could not terminate [" + this.printableCommandLine() + "].");
                        }
                    });
                    throw pce;
                }
            }
        }
    }

    private boolean tryKill() {
        this.myHandler.destroyProcess();
        if (this.myHandler.waitFor((long)this.myTerminationTimeoutMs)) {
            return true;
        }
        LOG.warn("Soft-kill failed for [" + this.printableCommandLine() + "].");
        ExecutionManagerImpl.stopProcess((ProcessHandler)this.myHandler);
        return this.myHandler.waitFor((long)this.myTerminationTimeoutMs);
    }

    protected OSProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new MyOSProcessHandler(commandLine, this.myWithMediator && this.myExecutable.isLocal() && Registry.is((String)"git.execute.with.mediator"));
    }

    protected static class MyOSProcessHandler
    extends KillableProcessHandler {
        protected MyOSProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
            super(commandLine, withMediator);
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return Registry.is((String)"git.blocking.read") ? BaseOutputReader.Options.BLOCKING : BaseOutputReader.Options.NON_BLOCKING;
        }
    }
}

